/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import org.jetbrains.annotations.ApiStatus;
import pers.solid.extshape.block.ExtShapeBlocks;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.config.ExtShapeConfig;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.BlockCollections;
import pers.solid.extshape.util.EntryVariantAppender;

public final class VanillaItemGroup {
    private static final Map<class_5321<class_1761>, Multimap<class_1792, class_1792>> APPENDING_RULES = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_5321<class_1761>, Multimap<class_1792, class_1792>> PREPENDING_RULES = new Object2ObjectLinkedOpenHashMap();
    public static final Event<Runnable> UPDATE_SHAPES_EVENT = EventFactory.createArrayBacked(Runnable.class, runnables -> () -> {
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    });

    private VanillaItemGroup() {
    }

    @ApiStatus.Internal
    public static Multimap<class_1792, class_1792> getAppendingRule(class_5321<class_1761> group) {
        return APPENDING_RULES.computeIfAbsent(group, itemGroup -> ArrayListMultimap.create());
    }

    @ApiStatus.Internal
    public static Multimap<class_1792, class_1792> getPrependingRule(class_5321<class_1761> group) {
        return PREPENDING_RULES.computeIfAbsent(group, itemGroup -> ArrayListMultimap.create());
    }

    @ApiStatus.Internal
    public static void registerForMod() {
        Multimap<class_1792, class_1792> apRedstone = VanillaItemGroup.getAppendingRule((class_5321<class_1761>)class_7706.field_40198);
        apRedstone.put((Object)class_1802.field_8781, (Object)Objects.requireNonNull(BlockBiMaps.getBlockOf(BlockShape.BUTTON, class_2246.field_10540)).method_8389());
        Multimap<class_1792, class_1792> preRedstone = VanillaItemGroup.getPrependingRule((class_5321<class_1761>)class_7706.field_40198);
        preRedstone.put((Object)class_1802.field_8780, (Object)Objects.requireNonNull(BlockBiMaps.getBlockOf(BlockShape.BUTTON, class_2246.field_10446)).method_8389());
        UPDATE_SHAPES_EVENT.register(() -> {
            PREPENDING_RULES.clear();
            APPENDING_RULES.clear();
        });
        UPDATE_SHAPES_EVENT.register(() -> VanillaItemGroup.recreateVanillaGroupRules(ExtShapeConfig.CURRENT_CONFIG.shapesToAddToVanilla));
    }

    @ApiStatus.Internal
    public static void recreateVanillaGroupRules(Collection<BlockShape> shapes) {
        Multimap<class_1792, class_1792> apBuilding = VanillaItemGroup.getAppendingRule((class_5321<class_1761>)class_7706.field_40195);
        Multimap<class_1792, class_1792> preBuilding = VanillaItemGroup.getPrependingRule((class_5321<class_1761>)class_7706.field_40195);
        preBuilding.put((Object)class_1802.field_8291, (Object)ExtShapeBlocks.SMOOTH_STONE_DOUBLE_SLAB.method_8389());
        apBuilding.put((Object)class_1802.field_8118, (Object)ExtShapeBlocks.PETRIFIED_OAK_PLANKS.method_8389());
        new EntryVariantAppender((class_5321<class_1761>)class_7706.field_40195, shapes, Iterables.filter(BlockBiMaps.BASE_BLOCKS, block -> !BlockCollections.WOOLS.contains(block) && !BlockCollections.STAINED_TERRACOTTA.contains(block) && !BlockCollections.CONCRETES.contains(block) && !BlockCollections.GLAZED_TERRACOTTA.contains(block) && block != class_2246.field_10415), arg_0 -> ExtShapeBlocks.getBlocks().contains(arg_0)).appendItems(apBuilding);
        new EntryVariantAppender((class_5321<class_1761>)class_7706.field_41059, shapes, Iterables.concat((Iterable[])new Iterable[]{BlockCollections.WOOLS, Collections.singleton(class_2246.field_10415), BlockCollections.STAINED_TERRACOTTA, BlockCollections.CONCRETES, BlockCollections.GLAZED_TERRACOTTA}), ExtShapeBlocks::contains).appendItems(VanillaItemGroup.getAppendingRule((class_5321<class_1761>)class_7706.field_41059));
        Set<class_2248> excludedInNatural = Set.of(class_2246.field_28888, class_2246.field_10515, class_2246.field_22091, class_2246.field_29032, class_2246.field_10471, class_2246.field_27159);
        new EntryVariantAppender((class_5321<class_1761>)class_7706.field_40743, shapes, Iterables.filter(BlockBiMaps.BASE_BLOCKS, block -> !BlockCollections.LOGS.contains(block) && !BlockCollections.STEMS.contains(block) && !excludedInNatural.contains(block)), ExtShapeBlocks::contains).appendItems(VanillaItemGroup.getAppendingRule((class_5321<class_1761>)class_7706.field_40743));
    }
}

