/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5547;
import net.minecraft.class_5797;
import net.minecraft.class_5955;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.jetbrains.annotations.NotNull;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.ExtShapeButtonBlock;
import pers.solid.extshape.block.ExtShapeFenceBlock;
import pers.solid.extshape.block.ExtShapeFenceGateBlock;
import pers.solid.extshape.block.ExtShapePressurePlateBlock;
import pers.solid.extshape.block.ExtShapeQuarterPieceBlock;
import pers.solid.extshape.block.ExtShapeSlabBlock;
import pers.solid.extshape.block.ExtShapeStairsBlock;
import pers.solid.extshape.block.ExtShapeVerticalQuarterPieceBlock;
import pers.solid.extshape.block.ExtShapeVerticalSlabBlock;
import pers.solid.extshape.block.ExtShapeVerticalStairsBlock;
import pers.solid.extshape.block.ExtShapeWallBlock;
import pers.solid.extshape.builder.AbstractBlockBuilder;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.builder.BlocksBuilder;
import pers.solid.extshape.builder.BlocksBuilderFactory;
import pers.solid.extshape.builder.ButtonBuilder;
import pers.solid.extshape.builder.FenceBuilder;
import pers.solid.extshape.builder.FenceGateBuilder;
import pers.solid.extshape.builder.PressurePlateBuilder;
import pers.solid.extshape.builder.QuarterPieceBuilder;
import pers.solid.extshape.builder.SlabBuilder;
import pers.solid.extshape.builder.StairsBuilder;
import pers.solid.extshape.builder.VerticalQuarterPieceBuilder;
import pers.solid.extshape.builder.VerticalSlabBuilder;
import pers.solid.extshape.builder.VerticalStairsBuilder;
import pers.solid.extshape.builder.WallBuilder;
import pers.solid.extshape.util.ActivationSettings;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.ExtShapeBlockTypes;
import pers.solid.extshape.util.FenceSettings;

public record CopperManager(List<class_2248> unwaxed, List<class_2248> waxed) {
    public static final ImmutableList<class_2248> COPPER_BLOCKS = ImmutableList.of((Object)class_2246.field_27119, (Object)class_2246.field_27118, (Object)class_2246.field_27117, (Object)class_2246.field_27116);
    public static final ImmutableList<class_2248> CUT_COPPER_BLOCKS = ImmutableList.of((Object)class_2246.field_27124, (Object)class_2246.field_27123, (Object)class_2246.field_27122, (Object)class_2246.field_27121);
    public static final ImmutableList<class_2248> WAXED_COPPER_BLOCKS = ImmutableList.of((Object)class_2246.field_27133, (Object)class_2246.field_27135, (Object)class_2246.field_27134, (Object)class_2246.field_33407);
    public static final ImmutableList<class_2248> WAXED_CUT_COPPER_BLOCKS = ImmutableList.of((Object)class_2246.field_27138, (Object)class_2246.field_27137, (Object)class_2246.field_27136, (Object)class_2246.field_33408);
    public static final ImmutableList<class_5955.class_5811> OXIDATION_LEVELS = ImmutableList.of((Object)class_5955.class_5811.field_28704, (Object)class_5955.class_5811.field_28705, (Object)class_5955.class_5811.field_28706, (Object)class_5955.class_5811.field_28707);
    public static final CopperManager COPPER = new CopperManager((List<class_2248>)COPPER_BLOCKS, (List<class_2248>)WAXED_COPPER_BLOCKS);
    public static final CopperManager CUT_COPPER = new CopperManager((List<class_2248>)CUT_COPPER_BLOCKS, (List<class_2248>)WAXED_CUT_COPPER_BLOCKS);

    public static BlocksBuilder registerCopperBlock(BlocksBuilderFactory blocksBuilderFactory, class_2248 copperBase, @NotNull class_5955.class_5811 oxidationLevel, boolean waxed) {
        BlocksBuilder builder = blocksBuilderFactory.createAllShapes(copperBase).setActivationSettings((ActivationSettings)ActivationSettings.COPPER.get((Object)oxidationLevel));
        if (!waxed) {
            builder.addPreBuildConsumer((blockShape, oneBuilder) -> {
                if (oneBuilder instanceof StairsBuilder) {
                    StairsBuilder s = (StairsBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeStairsBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof SlabBuilder) {
                    SlabBuilder s = (SlabBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeSlabBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof QuarterPieceBuilder) {
                    QuarterPieceBuilder s = (QuarterPieceBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeQuarterPieceBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof VerticalStairsBuilder) {
                    VerticalStairsBuilder s = (VerticalStairsBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeVerticalStairsBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof VerticalSlabBuilder) {
                    VerticalSlabBuilder s = (VerticalSlabBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeVerticalSlabBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof VerticalQuarterPieceBuilder) {
                    VerticalQuarterPieceBuilder s = (VerticalQuarterPieceBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeVerticalQuarterPieceBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof FenceBuilder) {
                    FenceBuilder s = (FenceBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeFenceBlock.WithOxidation(x.baseBlock, s.secondIngredient, x.blockSettings, oxidationLevel));
                } else if (oneBuilder instanceof FenceGateBuilder) {
                    FenceGateBuilder s = (FenceGateBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeFenceGateBlock.WithOxidation(x.baseBlock, x.blockSettings, s.fenceSettings, oxidationLevel));
                } else if (oneBuilder instanceof PressurePlateBuilder) {
                    PressurePlateBuilder s = (PressurePlateBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapePressurePlateBlock.WithOxidation(x.baseBlock, x.blockSettings, s.activationSettings, oxidationLevel));
                } else if (oneBuilder instanceof ButtonBuilder) {
                    ButtonBuilder s = (ButtonBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeButtonBlock.WithOxidation(x.baseBlock, x.blockSettings, s.activationSettings, oxidationLevel));
                } else if (oneBuilder instanceof WallBuilder) {
                    WallBuilder s = (WallBuilder)oneBuilder;
                    s.setInstanceSupplier(x -> new ExtShapeWallBlock.WithOxidation(x.baseBlock, x.blockSettings, oxidationLevel));
                }
            });
        }
        builder.markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_27022, ExtShapeBlockTypes.COPPER_WOOD_TYPE)).build();
        return builder;
    }

    public static void registerWithMultipleOxidizationLevel(BlocksBuilderFactory blocksBuilderFactory, List<class_2248> coppers, boolean waxed) {
        BlocksBuilder[] blocksBuilders = new BlocksBuilder[coppers.size()];
        for (int i = 0; i < coppers.size(); ++i) {
            BlocksBuilder blocksBuilder;
            blocksBuilders[i] = blocksBuilder = CopperManager.registerCopperBlock(blocksBuilderFactory, coppers.get(i), (class_5955.class_5811)OXIDATION_LEVELS.get(i), waxed);
            if (i <= 0 || waxed) continue;
            BlocksBuilder previous = blocksBuilders[i - 1];
            for (Map.Entry entry : blocksBuilder.entrySet()) {
                BlockShape key = (BlockShape)entry.getKey();
                AbstractBlockBuilder value = (AbstractBlockBuilder)entry.getValue();
                AbstractBlockBuilder previousValue = (AbstractBlockBuilder)previous.get(key);
                if (value == null || previousValue == null) continue;
                OxidizableBlocksRegistry.registerOxidizableBlockPair(previousValue.instance, value.instance);
            }
        }
    }

    public static void registerExtendedWax(BlocksBuilderFactory blocksBuilderFactory, List<class_2248> unwaxedBases, List<class_2248> waxedBases) {
        Preconditions.checkArgument((unwaxedBases.size() == waxedBases.size() ? 1 : 0) != 0, (Object)"unwaxedBases and waxedBases should be of same size!");
        for (int i = 0; i < unwaxedBases.size(); ++i) {
            class_2248 unwaxedBase = unwaxedBases.get(i);
            class_2248 waxedBase = waxedBases.get(i);
            for (BlockShape shape : BlockShape.values()) {
                class_2248 unwaxed = BlockBiMaps.getBlockOf(shape, unwaxedBase);
                class_2248 waxed = BlockBiMaps.getBlockOf(shape, waxedBase);
                if (unwaxed == null || waxed == null || blocksBuilderFactory.instanceCollection == null || !blocksBuilderFactory.instanceCollection.contains(unwaxed) || !blocksBuilderFactory.instanceCollection.contains(waxed)) continue;
                OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)unwaxed, (class_2248)waxed);
            }
        }
    }

    public void registerBlocks(BlocksBuilderFactory blocksBuilderFactory) {
        CopperManager.registerWithMultipleOxidizationLevel(blocksBuilderFactory, this.unwaxed, false);
        CopperManager.registerWithMultipleOxidizationLevel(blocksBuilderFactory, this.waxed, true);
        CopperManager.registerExtendedWax(blocksBuilderFactory, this.unwaxed, this.waxed);
    }

    public static <B extends class_2248 & class_5955> MapCodec<B> createCodec(RecordCodecBuilder<B, class_4970.class_2251> settingsCodec, Function3<class_2248, class_4970.class_2251, class_5955.class_5811, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_block").forGetter(rec$ -> ((ExtShapeBlockInterface)rec$).getBaseBlock()), (App)settingsCodec, CopperManager.weatheringStateField()).apply((Applicative)instance, function));
    }

    @NotNull
    public static <B extends class_5955> RecordCodecBuilder<B, class_5955.class_5811> weatheringStateField() {
        return class_5955.class_5811.field_46493.fieldOf("weathering_state").forGetter(class_5547::method_33622);
    }

    public static int getActivationRate(@NotNull class_5955.class_5811 oxidationLevel) {
        return switch (oxidationLevel) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 10;
            case class_5955.class_5811.field_28705 -> 40;
            case class_5955.class_5811.field_28706 -> 70;
            case class_5955.class_5811.field_28707 -> 100;
        };
    }

    public void generateWaxRecipes(class_2446 recipeGenerator, class_8790 exporter, Predicate<class_2248> blockPredicate) {
        Preconditions.checkArgument((this.unwaxed.size() == this.waxed.size() ? 1 : 0) != 0, (Object)"unwaxedBlocks and waxedBlocks must be of same size!");
        for (int i = 0; i < this.unwaxed.size(); ++i) {
            class_2248 unwaxedBaseBlock = this.unwaxed.get(i);
            class_2248 waxedBaseBlock = this.waxed.get(i);
            CopperManager.generateWaxRecipesForShapes(recipeGenerator, exporter, unwaxedBaseBlock, waxedBaseBlock, blockPredicate);
        }
    }

    private static void generateWaxRecipesForShapes(class_2446 recipeGenerator, class_8790 exporter, class_2248 unwaxedBaseBlock, class_2248 waxedBaseBlock, Predicate<class_2248> blockPredicate) {
        for (BlockShape shape : BlockShape.values()) {
            class_2248 unwaxed = BlockBiMaps.getBlockOf(shape, unwaxedBaseBlock);
            class_2248 waxed = BlockBiMaps.getBlockOf(shape, waxedBaseBlock);
            if (unwaxed == null || waxed == null || !blockPredicate.test(waxed)) continue;
            class_2450 recipe = recipeGenerator.method_62749(class_7800.field_40634, (class_1935)waxed).method_10454((class_1935)unwaxed).method_10454((class_1935)class_1802.field_20414).method_10452(class_2446.method_33716((class_1935)waxed)).method_10442(class_2446.method_32807((class_1935)unwaxed), recipeGenerator.method_10426((class_1935)unwaxed));
            recipe.method_17972(exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_2960.method_60655((String)class_5797.method_36442((class_1935)waxed).method_12836(), (String)class_2446.method_33714((class_1935)waxed, (class_1935)class_1802.field_20414))));
        }
    }
}

