/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_4910;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7788;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.data.ExtShapeModelProvider;
import pers.solid.extshape.data.RecipeGroupRegistry;

public interface ExtShapeBlockInterface {
    public static final ObjectSet<class_2248> STONECUTTABLE_BASE_BLOCKS = new ObjectOpenHashSet();
    public static final ObjectSet<class_2248> STONECUTTABLE_BLOCKS = new ObjectOpenHashSet();

    @NotNull
    public class_2248 getBaseBlock();

    default public String getRecipeGroup() {
        return RecipeGroupRegistry.getRecipeGroup((class_1935)this);
    }

    @Nullable
    default public class_3981 getStonecuttingRecipe(class_2446 recipeGenerato) {
        return null;
    }

    public static boolean isStoneCut(class_2248 baseBlock) {
        return baseBlock != null && STONECUTTABLE_BASE_BLOCKS.contains((Object)baseBlock);
    }

    default public class_52.class_53 getLootTable(class_7788 blockLootTableGenerator) {
        return blockLootTableGenerator.method_45976((class_1935)this);
    }

    default public class_5797 getCraftingRecipe(class_2446 recipeGenerator) {
        return null;
    }

    default public boolean shouldWriteStonecuttingRecipe() {
        return this instanceof class_2248 && STONECUTTABLE_BLOCKS.contains((Object)this) || ExtShapeBlockInterface.isStoneCut(this.getBaseBlock());
    }

    default public class_3981 simpleStoneCuttingRecipe(int resultCount, class_2446 recipeGenerator) {
        class_2248 baseBlock = this.getBaseBlock();
        return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{baseBlock}), (class_7800)this.getRecipeCategory(), (class_1935)((class_1935)this), (int)resultCount).method_17970("has_base_block", recipeGenerator.method_10426((class_1935)baseBlock));
    }

    @Contract(pure=true)
    default public BlockShape getBlockShape() {
        return null;
    }

    @Nullable
    default public class_7800 getRecipeCategory() {
        BlockShape blockShape = this.getBlockShape();
        if (blockShape.isConstruction) {
            return class_7800.field_40634;
        }
        if (blockShape == BlockShape.FENCE || blockShape == BlockShape.WALL) {
            return class_7800.field_40635;
        }
        if (blockShape == BlockShape.FENCE_GATE || blockShape == BlockShape.PRESSURE_PLATE || blockShape == BlockShape.BUTTON) {
            return class_7800.field_40636;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void registerModel(ExtShapeModelProvider var1, class_4910 var2);

    default public void registerRecipes(class_2446 recipeGenerator, class_8790 exporter) {
        class_3981 stonecuttingRecipe;
        class_5797 craftingRecipe = this.getCraftingRecipe(recipeGenerator);
        if (craftingRecipe != null) {
            craftingRecipe.method_10431(exporter);
        }
        if (this.shouldWriteStonecuttingRecipe() && (stonecuttingRecipe = this.getStonecuttingRecipe(recipeGenerator)) != null) {
            stonecuttingRecipe.method_17972(exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_7923.field_41178.method_10221((Object)stonecuttingRecipe.method_36441()).method_48331("_from_stonecutting")));
        }
    }

    public static <B extends class_2248> MapCodec<B> createCodecWithBaseBlock(RecordCodecBuilder<B, class_4970.class_2251> settings, BiFunction<class_2248, class_4970.class_2251, B> function) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)class_7923.field_41175.method_39673().fieldOf("base_block").forGetter(rec$ -> ((ExtShapeBlockInterface)rec$).getBaseBlock()), (App)settings).apply((Applicative)i, function));
    }
}

