/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.block;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.UnmodifiableView;
import pers.solid.extshape.ExtShape;
import pers.solid.extshape.block.BlockExtension;
import pers.solid.extshape.block.CopperManager;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.GlazedTerracottaSlabBlock;
import pers.solid.extshape.builder.AbstractBlockBuilder;
import pers.solid.extshape.builder.BlockBuilder;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.builder.BlocksBuilderFactory;
import pers.solid.extshape.builder.SlabBuilder;
import pers.solid.extshape.data.RecipeGroupRegistry;
import pers.solid.extshape.mixin.BlockAccessor;
import pers.solid.extshape.util.ActivationSettings;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.BlockCollections;
import pers.solid.extshape.util.ExtShapeBlockTypes;
import pers.solid.extshape.util.FenceSettings;

public final class ExtShapeBlocks {
    private static final ObjectSet<class_2248> BLOCKS = new ObjectLinkedOpenHashSet();
    private static final ObjectSet<class_2248> BASE_BLOCKS = new ObjectLinkedOpenHashSet();
    private static final BlocksBuilderFactory FACTORY = (BlocksBuilderFactory)class_156.method_654((Object)new BlocksBuilderFactory(), blocksBuilderFactory -> {
        blocksBuilderFactory.defaultNamespace = "extshape";
        blocksBuilderFactory.instanceCollection = BLOCKS;
        blocksBuilderFactory.baseBlockCollection = BASE_BLOCKS;
    });
    public static final class_2248 PETRIFIED_OAK_PLANKS;
    public static final class_2248 SMOOTH_STONE_DOUBLE_SLAB;

    public static @UnmodifiableView ObjectSet<class_2248> getBlocks() {
        return ObjectSets.unmodifiable(BLOCKS);
    }

    public static boolean contains(class_2248 block) {
        return BLOCKS.contains((Object)block);
    }

    public static @UnmodifiableView ObjectSet<class_2248> getBaseBlocks() {
        return ObjectSets.unmodifiable(BASE_BLOCKS);
    }

    public static boolean containsBaseBlock(class_2248 baseBlock) {
        return BASE_BLOCKS.contains((Object)baseBlock);
    }

    private ExtShapeBlocks() {
    }

    public static void init() {
    }

    static {
        for (class_2248 block : BlockCollections.STONES) {
            FACTORY.createAllShapes(block).markStoneCuttable().setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        }
        FACTORY.createAllShapes(class_2246.field_10566).setActivationSettings(ActivationSettings.GRAVEL).setFenceSettings(FenceSettings.DIRT).build();
        FACTORY.createAllShapes(class_2246.field_10253).setActivationSettings(ActivationSettings.GRAVEL).setFenceSettings(FenceSettings.DIRT).withoutRedstone().build();
        FACTORY.createAllShapes(class_2246.field_10445).markStoneCuttable().setFenceSettings(FenceSettings.STONE).build();
        BiConsumer<BlockShape, AbstractBlockBuilder<? extends class_2248>> woodFlammable = (blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 5, 5);
        FACTORY.createAllShapes(class_2246.field_41072).setFenceSettings(FenceSettings.BAMBOO_BLOCK).setActivationSettings(ActivationSettings.BAMBOO).setPillarUvLocked().addPreBuildConsumer((blockShape4, builder3) -> builder3.blockSettings.method_31710(class_3620.field_16004)).addPostBuildConsumer(woodFlammable).build();
        FACTORY.createAllShapes(class_2246.field_41073).setFenceSettings(FenceSettings.BAMBOO_BLOCK).setActivationSettings(ActivationSettings.BAMBOO).setPillarUvLocked().addPreBuildConsumer((blockShape2, builder2) -> builder2.blockSettings.method_31710(class_3620.field_16010)).addPostBuildConsumer(woodFlammable).build();
        Iterator woodenButtonSettings = Iterators.cycle((Object[])new ActivationSettings[]{ActivationSettings.wood(class_8177.field_42823), ActivationSettings.wood(class_8177.field_42824), ActivationSettings.wood(class_8177.field_42825), ActivationSettings.wood(class_8177.field_42828), ActivationSettings.wood(class_8177.field_42826), ActivationSettings.wood(class_8177.field_42827), ActivationSettings.wood(class_8177.field_42829), ActivationSettings.wood(class_8177.field_42832)});
        Iterator netherWoodButtonSettings = Iterators.cycle((Object[])new ActivationSettings[]{ActivationSettings.wood(class_8177.field_42831), ActivationSettings.wood(class_8177.field_42830)});
        Iterator woodTypes = Iterators.cycle((Object[])new class_4719[]{class_4719.field_21676, class_4719.field_21677, class_4719.field_21678, class_4719.field_21680, class_4719.field_21679, class_4719.field_42837, class_4719.field_21681, class_4719.field_37657});
        Iterator netherWoodTypes = Iterators.cycle((Object[])new class_4719[]{class_4719.field_22184, class_4719.field_22183});
        for (class_2248 block : BlockCollections.WOODS) {
            FACTORY.createAllShapes(block).setFenceSettings(new FenceSettings(class_1802.field_8600, (class_4719)woodTypes.next())).setActivationSettings((ActivationSettings)woodenButtonSettings.next()).setPillar().addPostBuildConsumer(woodFlammable).setRecipeGroup(blockShape -> "wood_" + blockShape.method_15434()).build();
        }
        for (class_2248 block : BlockCollections.STRIPPED_WOODS) {
            FACTORY.createAllShapes(block).setFenceSettings(new FenceSettings(class_1802.field_8600, (class_4719)woodTypes.next())).setActivationSettings((ActivationSettings)woodenButtonSettings.next()).setPillar().addPostBuildConsumer(woodFlammable).setRecipeGroup(blockShape -> "stripped_wood_" + blockShape.method_15434()).build();
        }
        for (class_2248 block : BlockCollections.HYPHAES) {
            ActivationSettings activationSettings = (ActivationSettings)netherWoodButtonSettings.next();
            FACTORY.createAllShapes(block).setFenceSettings(new FenceSettings(class_1802.field_8600, (class_4719)netherWoodTypes.next())).setActivationSettings(activationSettings).setPillar().setRecipeGroup(blockShape -> "wood_" + blockShape.method_15434()).build();
        }
        for (class_2248 block : BlockCollections.STRIPPED_HYPHAES) {
            FACTORY.createAllShapes(block).setFenceSettings(new FenceSettings(class_1802.field_8600, (class_4719)netherWoodTypes.next())).setActivationSettings((ActivationSettings)netherWoodButtonSettings.next()).setPillar().setRecipeGroup(blockShape -> "stripped_wood_" + blockShape.method_15434()).build();
        }
        for (class_2248 block : BlockCollections.PLANKS) {
            if (block == class_2246.field_40294 || block == class_2246.field_40295) {
                FACTORY.createAllShapes(block).setFenceSettings(FenceSettings.BAMBOO_PLANKS).setActivationSettings(ActivationSettings.BAMBOO).addPostBuildConsumer((blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 5, 20)).setRecipeGroup(blockShape -> "wooden_" + blockShape.method_15434()).build();
                continue;
            }
            if (block == class_2246.field_22126 || block == class_2246.field_22127) {
                FACTORY.createAllShapes(block).setFenceSettings(null).setActivationSettings(ActivationSettings.wood(block == class_2246.field_22127 ? class_8177.field_42831 : class_8177.field_42830)).setRecipeGroup(blockShape -> "wooden_" + blockShape.method_15434()).build();
                continue;
            }
            FACTORY.createAllShapes(block).setFenceSettings(null).setActivationSettings((ActivationSettings)woodenButtonSettings.next()).addPostBuildConsumer((blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 5, 20)).setRecipeGroup(blockShape -> "wooden_" + blockShape.method_15434()).build();
        }
        PETRIFIED_OAK_PLANKS = FACTORY.modify(new BlockBuilder()).setInstanceSupplier(builder -> {
            class_2248 block = new class_2248(builder.blockSettings);
            ExtShapeBlockInterface.STONECUTTABLE_BLOCKS.add((Object)block);
            return block;
        }).setBlockSettings(class_4970.class_2251.method_9630((class_4970)class_2246.field_10298)).setIdentifier(ExtShape.id("petrified_oak_planks")).build();
        BASE_BLOCKS.add((Object)PETRIFIED_OAK_PLANKS);
        BlockBiMaps.setBlockOf(BlockShape.SLAB, PETRIFIED_OAK_PLANKS, class_2246.field_10298);
        FACTORY.createAllShapes(class_2246.field_9987).markStoneCuttable().setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.HARD).addPreBuildConsumer((blockShape1, builder1) -> builder1.blockSettings.method_9629(-1.0f, 3600000.0f).method_26235(class_2246::method_26114).method_63502(Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)builder1.getBlockId().method_45138("blocks/")))).method_50012(class_3619.field_15972)).build();
        FACTORY.createAllShapes(class_2246.field_10441).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8759, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).build();
        for (class_2248 block : BlockCollections.UNCOLORED_SANDSTONES) {
            FACTORY.createConstructionOnly(block).markStoneCuttable().build();
        }
        for (class_2248 block : BlockCollections.RED_SANDSTONES) {
            FACTORY.createConstructionOnly(block).markStoneCuttable().build();
        }
        for (class_2248 block : new class_2248[]{class_2246.field_10467, class_2246.field_10483}) {
            FACTORY.createEmpty(block).markStoneCuttable().withFences(new FenceSettings(class_1802.field_8600, ExtShapeBlockTypes.STONE_WOOD_TYPE)).withPressurePlate(ActivationSettings.STONE).withButton(ActivationSettings.STONE).with(BlockShape.WALL).build();
        }
        for (class_2248 block : BlockCollections.WOOLS) {
            FACTORY.createAllShapes(block).setFenceSettings(FenceSettings.WOOL).setActivationSettings(ActivationSettings.WOOL).addPostBuildConsumer((blockShape, blockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(blockBuilder.instance, 30, 50)).setRecipeGroup(blockShape -> "wool_" + blockShape.method_15434()).build();
        }
        FACTORY.createAllShapes(class_2246.field_10205).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8695, ExtShapeBlockTypes.GOLD_WOOD_TYPE)).setActivationSettings(ActivationSettings.GOLD).without(BlockShape.PRESSURE_PLATE).build();
        FACTORY.createAllShapes(class_2246.field_10085).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8620, ExtShapeBlockTypes.IRON_WOOD_TYPE)).setActivationSettings(ActivationSettings.IRON).without(BlockShape.PRESSURE_PLATE).build();
        FACTORY.createAllShapes(class_2246.field_10104).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8621, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_9989).markStoneCuttable().setFenceSettings(FenceSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_10540).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.HARD_WOOD_TYPE)).setActivationSettings(ActivationSettings.HARD).addPreBuildConsumer((blockShape, abstractBlockBuilder) -> abstractBlockBuilder.blockSettings.method_50012(class_3619.field_15972)).build();
        FACTORY.createAllShapes(class_2246.field_10201).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8477, ExtShapeBlockTypes.DIAMOND_WOOD_TYPE)).setActivationSettings(new ActivationSettings(ExtShapeBlockTypes.METAL_BLOCK_SET_TYPE, 15, 10)).build();
        FACTORY.createAllShapes(class_2246.field_27159).markStoneCuttable().withExtension(BlockExtension.AMETHYST).setFenceSettings(FenceSettings.AMETHYST).withoutRedstone().build();
        FACTORY.createAllShapes(class_2246.field_10491).setFenceSettings(FenceSettings.SNOW).setActivationSettings(ActivationSettings.SNOW).build();
        FACTORY.createAllShapes(class_2246.field_10460).setFenceSettings(new FenceSettings(class_1802.field_8696, ExtShapeBlockTypes.GRAVEL_WOOD_TYPE)).setActivationSettings(ActivationSettings.GRAVEL).build();
        FACTORY.createAllShapes(class_2246.field_46282).setFenceSettings(new FenceSettings(class_1802.field_46249, class_4719.field_21676)).setActivationSettings(ActivationSettings.CROPS).compostingChance(0.65f).build();
        FACTORY.createAllShapes(class_2246.field_10515).markStoneCuttable().setFenceSettings(FenceSettings.NETHERRACK).setActivationSettings(ActivationSettings.NETHERRACK).build();
        FACTORY.createAllShapes(class_2246.field_10171).setFenceSettings(new FenceSettings(class_1802.field_8601, ExtShapeBlockTypes.GLOWSTONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.GLOWSTONE).build();
        for (class_2248 block : new class_2248[]{class_2246.field_10056, class_2246.field_10065}) {
            FACTORY.createAllShapes(block).markStoneCuttable().setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        }
        FACTORY.createAllShapes(class_2246.field_37556).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_37537, ExtShapeBlockTypes.PACKED_MUD)).setActivationSettings(ActivationSettings.stone(ExtShapeBlockTypes.PACKED_MUD_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_37557).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_37537, ExtShapeBlockTypes.MUD_BRICKS)).setActivationSettings(ActivationSettings.stone(ExtShapeBlockTypes.MUD_BRICKS_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_46283).setFenceSettings(new FenceSettings(class_1802.field_8497, class_4719.field_21676)).setActivationSettings(ActivationSettings.CROPS).compostingChance(0.65f).build();
        FACTORY.createAllShapes(class_2246.field_55053).setFenceSettings(FenceSettings.RESIN_BLOCK).setActivationSettings(ActivationSettings.RESIN).build();
        FACTORY.createAllShapes(class_2246.field_55054).markStoneCuttable().setFenceSettings(FenceSettings.RESIN_BRICKS).setActivationSettings(ActivationSettings.RESIN_BRICKS).build();
        FACTORY.createAllShapes(class_2246.field_10266).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8729, ExtShapeBlockTypes.NETHER_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone(ExtShapeBlockTypes.NETHER_BRICKS_BLOCK_SET_TYPE)).withoutRedstone().build();
        FACTORY.createAllShapes(class_2246.field_10471).markStoneCuttable().setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_10462).markStoneCuttable().setFenceSettings(FenceSettings.STONE).setActivationSettings(ActivationSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_10234).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8687, ExtShapeBlockTypes.METAL_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).build();
        FACTORY.createConstructionOnly(class_2246.field_10153).with(BlockShape.WALL).markStoneCuttable().setFenceSettings(FenceSettings.QUARTZ).setActivationSettings(ActivationSettings.QUARTZ).build();
        FACTORY.createConstructionOnly(class_2246.field_10044).with(BlockShape.WALL, BlockShape.PRESSURE_PLATE).markStoneCuttable().setFenceSettings(FenceSettings.QUARTZ).setActivationSettings(ActivationSettings.QUARTZ).build();
        FACTORY.createConstructionOnly(class_2246.field_23868).with(BlockShape.WALL, BlockShape.PRESSURE_PLATE).markStoneCuttable().setFenceSettings(FenceSettings.QUARTZ).setActivationSettings(ActivationSettings.QUARTZ).build();
        FACTORY.createAllShapes(class_2246.field_9978).markStoneCuttable().setFenceSettings(FenceSettings.QUARTZ).setActivationSettings(ActivationSettings.QUARTZ).build();
        FACTORY.createAllShapes(class_2246.field_9986).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8729, ExtShapeBlockTypes.STONE_WOOD_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_10415).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_19060, ExtShapeBlockTypes.STONE_WOOD_TYPE)).build();
        for (class_2248 block : BlockCollections.STAINED_TERRACOTTA) {
            FACTORY.createAllShapes(block).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_19060, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.STONE).build();
        }
        FACTORY.createAllShapes(class_2246.field_10381).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8713, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).fuelTime(16000).build();
        FACTORY.createAllShapes(class_2246.field_10225).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8426, ExtShapeBlockTypes.STONE_WOOD_TYPE)).build();
        for (class_2248 block : new class_2248[]{class_2246.field_10135, class_2246.field_10006, class_2246.field_10297}) {
            FACTORY.createAllShapes(block).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8662, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.STONE).build();
        }
        FACTORY.createConstructionOnly(class_2246.field_10174).build();
        SMOOTH_STONE_DOUBLE_SLAB = FACTORY.modify(new BlockBuilder()).setInstanceSupplier(builder -> new class_2248(builder.blockSettings)).setBlockSettings(class_4970.class_2251.method_9630((class_4970)class_2246.field_10360)).setIdentifier(ExtShape.id("smooth_stone_slab_double")).build();
        FACTORY.createAllShapes(class_2246.field_10360).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.STONE_WOOD_TYPE)).withoutConstructionShapes().build();
        BASE_BLOCKS.add((Object)SMOOTH_STONE_DOUBLE_SLAB);
        ExtShapeBlockInterface.STONECUTTABLE_BASE_BLOCKS.add((Object)SMOOTH_STONE_DOUBLE_SLAB);
        BlockBiMaps.setBlockOf(BlockShape.SLAB, SMOOTH_STONE_DOUBLE_SLAB, class_2246.field_10136);
        FACTORY.createAllShapes(class_2246.field_10286).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8815, ExtShapeBlockTypes.STONE_WOOD_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_10541).compostingChance(0.85f).setFenceSettings(new FenceSettings(class_1802.field_8790, ExtShapeBlockTypes.WART_BLOCK_WOOD_TYPE)).setActivationSettings(ActivationSettings.WART).build();
        FACTORY.createAllShapes(class_2246.field_22115).compostingChance(0.85f).setFenceSettings(new FenceSettings(class_1802.field_8790, ExtShapeBlockTypes.WART_BLOCK_WOOD_TYPE)).setActivationSettings(ActivationSettings.WART).build();
        for (class_2248 block : BlockCollections.GLAZED_TERRACOTTA) {
            BASE_BLOCKS.add((Object)block);
            ExtShapeBlockInterface.STONECUTTABLE_BASE_BLOCKS.add((Object)block);
            class_2482 slabBlock = FACTORY.modify(new SlabBuilder(block)).setInstanceSupplier(builder -> new GlazedTerracottaSlabBlock(builder.baseBlock, builder.blockSettings)).build();
            RecipeGroupRegistry.setRecipeGroup((class_1935)slabBlock, "glazed_terracotta_slab");
        }
        for (class_2248 block : BlockCollections.CONCRETES) {
            FACTORY.createAllShapes(block).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_19060, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.STONE).setRecipeGroup(blockShape -> "concrete_" + blockShape.method_15434()).build();
        }
        FACTORY.createAllShapes(class_2246.field_22122).setFenceSettings(new FenceSettings(class_1802.field_8601, ExtShapeBlockTypes.SHROOMLIGHT_WOOD_TYPE)).setActivationSettings(ActivationSettings.soft(ExtShapeBlockTypes.SHROMLIGHT_BLOCK_SET_TYPE)).compostingChance(0.65f).build();
        FACTORY.createAllShapes(class_2246.field_21212).setFenceSettings(new FenceSettings(class_1802.field_20414, ExtShapeBlockTypes.HONEYCOMB_WOOD_TYPE)).setActivationSettings(ActivationSettings.soft(ExtShapeBlockTypes.HONEYCOMB_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_22108).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_22020, ExtShapeBlockTypes.NETHERITE_WOOD_TYPE)).setActivationSettings(ActivationSettings.hard(ExtShapeBlockTypes.NETHERITE_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_22109).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_22021, ExtShapeBlockTypes.ANCIENT_DEBRIS_WOOD_TYPE)).setActivationSettings(ActivationSettings.hard(ExtShapeBlockTypes.ANCIENT_DEBRIS_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_22423).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.HARD_WOOD_TYPE)).setActivationSettings(ActivationSettings.HARD).addPreBuildConsumer((blockShape, abstractBlockBuilder) -> abstractBlockBuilder.blockSettings.method_50012(class_3619.field_15972)).build();
        FACTORY.createAllShapes(class_2246.field_23869).markStoneCuttable().setFenceSettings(FenceSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_23873).markStoneCuttable().setFenceSettings(FenceSettings.STONE).build();
        FACTORY.createAllShapes(class_2246.field_23874).markStoneCuttable().setFenceSettings(FenceSettings.STONE).without(BlockShape.FENCE, BlockShape.FENCE_GATE, BlockShape.BUTTON).build();
        FACTORY.createConstructionOnly(class_2246.field_23880).markStoneCuttable().build();
        FACTORY.createAllShapes(class_2246.field_27165).markStoneCuttable().setFenceSettings(FenceSettings.TUFF).setActivationSettings(ActivationSettings.TUFF).build();
        FACTORY.createAllShapes(class_2246.field_47030).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.POLISHED_TUFF_WOOD_TYPE)).setActivationSettings(ActivationSettings.softerStone(ExtShapeBlockTypes.POLISHED_TUFF_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_47035).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.TUFF_BRICKS_WOOD_TYPE)).setActivationSettings(ActivationSettings.softerStone(ExtShapeBlockTypes.TUFF_BRICKS_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_27114).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.CALCITE_WOOD_TYPE)).setActivationSettings(ActivationSettings.softerStone(ExtShapeBlockTypes.CALCITE_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_37568).setFenceSettings(new FenceSettings(class_1802.field_37524, ExtShapeBlockTypes.SCULK_WOOD_TYPE)).setActivationSettings(ActivationSettings.wood(ExtShapeBlockTypes.SCULK_BLOCK_SET_TYPE)).addPreBuildConsumer((blockShape, x) -> x.withExtension(BlockExtension.builder().setStacksDroppedCallback((state, world, pos, stack, dropExperience) -> {
            float logicalCompleteness;
            if (dropExperience && ((logicalCompleteness = blockShape.logicalCompleteness(state)) == 1.0f || world.method_8409().method_43057() < logicalCompleteness)) {
                ((BlockAccessor)state.method_26204()).callDropExperienceWhenMined(world, pos, stack, (class_6017)class_6016.method_34998((int)1));
            }
        }).build())).build();
        CopperManager.COPPER.registerBlocks(FACTORY);
        CopperManager.CUT_COPPER.registerBlocks(FACTORY);
        FACTORY.createAllShapes(class_2246.field_28049).markStoneCuttable().setFenceSettings(FenceSettings.DRIPSTONE).setActivationSettings(ActivationSettings.DRIPSTONE).build();
        FACTORY.createAllShapes(class_2246.field_28681).setFenceSettings(new FenceSettings(class_1802.field_28653, ExtShapeBlockTypes.MOSS_BLOCK_WOOD_TYPE)).compostingChance(0.65f).setActivationSettings(ActivationSettings.MOSS).build();
        FACTORY.createAllShapes(class_2246.field_54731).setFenceSettings(new FenceSettings(class_1802.field_54608, ExtShapeBlockTypes.MOSS_BLOCK_WOOD_TYPE)).compostingChance(0.65f).setActivationSettings(ActivationSettings.MOSS).addPostBuildConsumer((blockShape, abstractBlockBuilder) -> FlammableBlockRegistry.getDefaultInstance().add(abstractBlockBuilder.instance, 5, 100)).build();
        FACTORY.createAllShapes(class_2246.field_28888).markStoneCuttable().setFenceSettings(FenceSettings.DEEPSLATE).setActivationSettings(ActivationSettings.DEEPSLATE).setPillar().build();
        FACTORY.createAllShapes(class_2246.field_29031).markStoneCuttable().setFenceSettings(FenceSettings.DEEPSLATE).setActivationSettings(ActivationSettings.DEEPSLATE).build();
        FACTORY.createAllShapes(class_2246.field_28892).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.POLISHED_DEEPSLATE_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone(ExtShapeBlockTypes.POLISHED_DEEPSLATE_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_28896).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_8145, ExtShapeBlockTypes.DEEPSLATE_TILES_WOOD_TYPE)).setActivationSettings(ActivationSettings.stone(ExtShapeBlockTypes.DEEPSLATE_TILES_BLOCK_SET_TYPE)).build();
        FACTORY.createAllShapes(class_2246.field_28900).markStoneCuttable().setFenceSettings(FenceSettings.DEEPSLATE_BRICKS).setActivationSettings(ActivationSettings.DEEPSLATE_BRICKS).build();
        FACTORY.createAllShapes(class_2246.field_22091).markStoneCuttable().setFenceSettings(FenceSettings.BASALT).setActivationSettings(ActivationSettings.BASALT).setPillar().build();
        FACTORY.createAllShapes(class_2246.field_29032).markStoneCuttable().setFenceSettings(FenceSettings.BASALT).setActivationSettings(ActivationSettings.BASALT).build();
        FACTORY.createAllShapes(class_2246.field_33508).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_33400, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).build();
        FACTORY.createAllShapes(class_2246.field_33509).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_33401, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).build();
        FACTORY.createAllShapes(class_2246.field_33510).markStoneCuttable().setFenceSettings(new FenceSettings(class_1802.field_33402, ExtShapeBlockTypes.STONE_WOOD_TYPE)).setActivationSettings(ActivationSettings.ORE_BLOCK).build();
        for (class_2248 block : (class_2248[])ArrayUtils.toArray((Object[])new class_2248[]{class_2246.field_37572, class_2246.field_37573, class_2246.field_37574})) {
            FACTORY.createAllShapes(block).setFenceSettings(new FenceSettings(class_1802.field_8777, ExtShapeBlockTypes.FROGLIGHT_WOOD_TYPE)).setActivationSettings(ActivationSettings.soft(ExtShapeBlockTypes.FROGLIGHT_BLOCK_SET_TYPE)).setPillar().build();
        }
        ExtShape.LOGGER.info("Extended Block Shapes mod created {} blocks for {} base blocks. So swift!", (Object)BLOCKS.size(), (Object)BASE_BLOCKS.size());
    }
}

