/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.builder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10215;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.spongepowered.include.com.google.common.collect.ImmutableMap;
import pers.solid.extshape.ExtShapeBlockItem;
import pers.solid.extshape.block.BlockExtension;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.util.BlockBiMaps;

public abstract class AbstractBlockBuilder<T extends class_2248> {
    public final class_2248 baseBlock;
    public final boolean buildItem;
    public class_4970.class_2251 blockSettings;
    @Nullable
    protected Collection<class_2248> instanceCollection;
    @Nullable
    protected String defaultNamespace;
    protected BlockShape shape;
    public boolean shouldAddToBlockBiMap;
    @NotNull
    protected Function<AbstractBlockBuilder<T>, T> instanceSupplier;
    @NotNull
    protected Function<AbstractBlockBuilder<T>, class_1747> itemInstanceSupplier = builder -> new ExtShapeBlockItem((class_2248)builder.instance, builder.itemSettings);
    public T instance;
    public boolean registerBlock;
    public boolean registerItem;
    public class_1792.class_1793 itemSettings;
    public class_2960 identifier;
    public class_1747 itemInstance;
    private static final @Unmodifiable Map<Pattern, String> blockNameConversion = new ImmutableMap.Builder().put((Object)Pattern.compile("bamboo_block$"), (Object)"bamboo_block").put((Object)Pattern.compile("_planks$"), (Object)"").put((Object)Pattern.compile("_block$"), (Object)"").put((Object)Pattern.compile("^block_of_"), (Object)"").put((Object)Pattern.compile("tiles$"), (Object)"tile").put((Object)Pattern.compile("bricks$"), (Object)"brick").build();

    protected AbstractBlockBuilder(@Nullable class_2248 baseBlock, class_4970.class_2251 settings, @NotNull Function<AbstractBlockBuilder<T>, T> instanceSupplier) {
        class_10215 component;
        this.baseBlock = baseBlock;
        this.registerBlock = true;
        this.registerItem = true;
        this.blockSettings = settings;
        this.buildItem = true;
        this.shouldAddToBlockBiMap = true;
        this.itemSettings = new class_1792.class_1793();
        if (baseBlock != null && baseBlock.method_8389() != null && (component = (class_10215)baseBlock.method_8389().method_57347().method_58694(class_9334.field_54273)) != null && class_8103.field_42246.equals((Object)component.comp_3210())) {
            this.itemSettings.method_24359();
        }
        this.instanceSupplier = instanceSupplier;
    }

    protected AbstractBlockBuilder(class_2248 baseBlock, @NotNull Function<AbstractBlockBuilder<T>, T> instanceSupplier) {
        this(baseBlock, class_4970.class_2251.method_9630((class_4970)baseBlock), instanceSupplier);
    }

    @NotNull
    public static String getPathPrefixOf(@NotNull String path) {
        for (Map.Entry<Pattern, String> entry : blockNameConversion.entrySet()) {
            Pattern key = entry.getKey();
            Matcher matcher = key.matcher(path);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(entry.getValue());
        }
        return path;
    }

    public static class_2960 convertIdentifier(@NotNull class_2960 identifier, @Nullable String namespace, @NotNull String suffix) {
        String path = identifier.method_12832();
        String basePath = AbstractBlockBuilder.getPathPrefixOf(path);
        return class_2960.method_60655((String)(namespace == null ? identifier.method_12836() : namespace), (String)(basePath + suffix));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setBlockSettings(class_4970.class_2251 settings) {
        this.blockSettings = settings;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setItemSettings(class_1792.class_1793 settings) {
        this.itemSettings = settings;
        return this;
    }

    protected class_2960 getBaseIdentifier() {
        return class_7923.field_41175.method_10221((Object)this.baseBlock);
    }

    public class_2960 getBlockId() {
        if (this.identifier == null) {
            this.identifier = AbstractBlockBuilder.convertIdentifier(this.getBaseIdentifier(), this.defaultNamespace, this.getSuffix());
        }
        return this.identifier;
    }

    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setIdentifier(class_2960 identifier) {
        this.identifier = identifier;
        return this;
    }

    @Contract(pure=true)
    protected abstract String getSuffix();

    protected void addToBlockBiMap() {
        if (this.shape != null) {
            BlockBiMaps.setBlockOf(this.shape, this.baseBlock, this.instance);
        }
    }

    @ApiStatus.Internal
    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setInstanceDirectly(T instance) {
        this.instance = instance;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setInstanceSupplier(Function<AbstractBlockBuilder<T>, T> supplier) {
        this.instanceSupplier = supplier;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public AbstractBlockBuilder<T> setItemInstanceSupplier(Function<AbstractBlockBuilder<T>, class_1747> supplier) {
        this.itemInstanceSupplier = supplier;
        return this;
    }

    protected void createInstance() {
        this.blockSettings.method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)this.getBlockId()));
        this.instance = (class_2248)this.instanceSupplier.apply(this);
    }

    protected void createItemInstance() {
        this.itemSettings.method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)this.getBlockId()));
        this.itemInstance = this.itemInstanceSupplier.apply(this);
    }

    public T build() {
        if (this.instance == null) {
            this.createInstance();
        }
        if (this.registerBlock) {
            class_2960 blockId = this.getBlockId();
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                class_2960 vanillaId = class_2960.method_60656((String)blockId.method_12832());
                Validate.validState((!class_7923.field_41175.method_10250(vanillaId) ? 1 : 0) != 0, (String)"The block with id cannot be registered because there is a same block whose id is %s!", (Object[])new Object[]{blockId, vanillaId});
            }
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockId, this.instance);
        }
        if (this.buildItem) {
            this.createItemInstance();
            if (this.registerItem) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.identifier, (Object)this.itemInstance);
            }
        }
        if (this.instanceCollection != null) {
            this.instanceCollection.add((class_2248)this.instance);
        }
        if (this.shouldAddToBlockBiMap) {
            this.addToBlockBiMap();
        }
        return this.instance;
    }

    @Contract(value="_ -> this")
    public AbstractBlockBuilder<T> withExtension(BlockExtension blockExtension) {
        return this;
    }
}

