/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.builder;

import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3542;
import net.minecraft.class_5794;
import net.minecraft.class_7800;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.QuarterPieceBlock;
import pers.solid.extshape.block.VerticalQuarterPieceBlock;
import pers.solid.extshape.block.VerticalSlabBlock;
import pers.solid.extshape.block.VerticalStairsBlock;

public class BlockShape
implements class_3542,
Comparable<BlockShape>,
Predicate<class_2248> {
    private static final BiMap<String, BlockShape> NAME_TO_SHAPE = HashBiMap.create();
    private static final List<BlockShape> SHAPES = new ArrayList<BlockShape>();
    private static final @UnmodifiableView List<BlockShape> VALUES = Collections.unmodifiableList(SHAPES);
    public static final BlockShape STAIRS = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2510.class), class_5794.class_5796.field_28540, "stairs", 1.0f, true);
    public static final BlockShape SLAB = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2482.class), class_5794.class_5796.field_28539, "slab", 0.5f, true);
    public static final BlockShape VERTICAL_SLAB = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(VerticalSlabBlock.class), null, "vertical_slab", 0.5f, true);
    public static final BlockShape VERTICAL_STAIRS = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(VerticalStairsBlock.class), null, "vertical_stairs", 1.0f, true);
    public static final BlockShape QUARTER_PIECE = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(QuarterPieceBlock.class), null, "quarter_piece", 0.25f, true);
    public static final BlockShape VERTICAL_QUARTER_PIECE = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(VerticalQuarterPieceBlock.class), null, "vertical_quarter_piece", 0.25f, true);
    public static final BlockShape FENCE = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2354.class), class_5794.class_5796.field_28536, "fence", 1.0f, false);
    public static final BlockShape FENCE_GATE = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2349.class), class_5794.class_5796.field_28537, "fence_gate", 1.0f, false);
    public static final BlockShape WALL = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2544.class), class_5794.class_5796.field_28544, "wall", 1.0f, false);
    public static final BlockShape BUTTON = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2269.class), class_5794.class_5796.field_28533, "button", 0.33333334f, false);
    public static final BlockShape PRESSURE_PLATE = new BlockShape((Predicate<class_2248>)Predicates.instanceOf(class_2440.class), class_5794.class_5796.field_28541, "pressure_plate", 0.33333334f, false);
    public final Predicate<class_2248> blockPredicate;
    @Nullable
    public final class_5794.class_5796 vanillaVariant;
    @NotNull
    private final String name;
    public final float logicalCompleteness;
    public final boolean isConstruction;
    public final int id;

    public BlockShape(Predicate<class_2248> blockPredicate, @Nullable class_5794.class_5796 vanillaVariant, @NotNull String name, float logicalCompleteness, boolean isConstruction) {
        this.blockPredicate = blockPredicate;
        this.vanillaVariant = vanillaVariant;
        this.name = name;
        this.logicalCompleteness = logicalCompleteness;
        this.isConstruction = isConstruction;
        this.id = SHAPES.size();
        SHAPES.add(this);
        NAME_TO_SHAPE.put((Object)name, (Object)this);
    }

    @Nullable
    public static BlockShape getShapeOf(class_2248 block) {
        if (block instanceof ExtShapeBlockInterface) {
            ExtShapeBlockInterface e = (ExtShapeBlockInterface)block;
            return e.getBlockShape();
        }
        for (BlockShape shape : BlockShape.values()) {
            if (!shape.test(block)) continue;
            return shape;
        }
        return null;
    }

    public static List<BlockShape> values() {
        return VALUES;
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    @Override
    @Contract(pure=true)
    public boolean test(class_2248 block) {
        return this.blockPredicate.test(block);
    }

    public static BlockShape byName(String name) {
        return (BlockShape)NAME_TO_SHAPE.get((Object)name);
    }

    @Override
    public int compareTo(@NotNull BlockShape o) {
        return this.id - o.id;
    }

    public class_7800 getRecipeCategory() {
        if (this.isConstruction) {
            return class_7800.field_40634;
        }
        if (this == PRESSURE_PLATE || this == FENCE_GATE || this == BUTTON) {
            return class_7800.field_40636;
        }
        return class_7800.field_40635;
    }

    public float logicalCompleteness(@NotNull class_2680 blockState) {
        if (this == SLAB && blockState.method_28498((class_2769)class_2741.field_12485) && blockState.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682) {
            return 1.0f;
        }
        return this.logicalCompleteness;
    }

    public static enum Serializer implements JsonSerializer<BlockShape>,
    JsonDeserializer<BlockShape>
    {
        INSTANCE;


        public BlockShape deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return BlockShape.byName(json.getAsString());
        }

        public JsonElement serialize(BlockShape src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.method_15434());
        }
    }
}

