/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.builder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.extshape.block.BlockExtension;
import pers.solid.extshape.block.CircularPavingSlabBlock;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.ExtShapeHorizontalFacingPressurePlateBlock;
import pers.solid.extshape.block.ExtShapePillarSlabBlock;
import pers.solid.extshape.block.ExtShapePillarUvLockedSlabBlock;
import pers.solid.extshape.block.ExtShapePillarVerticalSlabBlock;
import pers.solid.extshape.builder.AbstractBlockBuilder;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.builder.ButtonBuilder;
import pers.solid.extshape.builder.FenceBuilder;
import pers.solid.extshape.builder.FenceGateBuilder;
import pers.solid.extshape.builder.PressurePlateBuilder;
import pers.solid.extshape.builder.QuarterPieceBuilder;
import pers.solid.extshape.builder.SlabBuilder;
import pers.solid.extshape.builder.StairsBuilder;
import pers.solid.extshape.builder.VerticalQuarterPieceBuilder;
import pers.solid.extshape.builder.VerticalSlabBuilder;
import pers.solid.extshape.builder.VerticalStairsBuilder;
import pers.solid.extshape.builder.WallBuilder;
import pers.solid.extshape.data.RecipeGroupRegistry;
import pers.solid.extshape.mixin.AbstractBlockStateAccessor;
import pers.solid.extshape.util.ActivationSettings;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.ExtShapeBlockTypes;
import pers.solid.extshape.util.FenceSettings;

public class BlocksBuilder
extends TreeMap<BlockShape, AbstractBlockBuilder<? extends class_2248>> {
    private static final BlockShape[] CONSTRUCTION_SHAPES = new BlockShape[]{BlockShape.STAIRS, BlockShape.SLAB, BlockShape.VERTICAL_QUARTER_PIECE, BlockShape.VERTICAL_SLAB, BlockShape.VERTICAL_STAIRS, BlockShape.QUARTER_PIECE};
    @Nullable
    protected String defaultNamespace;
    @Nullable
    protected Collection<class_2248> instanceCollection;
    protected final SortedSet<BlockShape> shapesToBuild;
    @NotNull
    public final class_2248 baseBlock;
    @Nullable
    protected FenceSettings fenceSettings;
    @Nullable
    protected ActivationSettings activationSettings;
    @Nullable
    protected BiConsumer<BlockShape, AbstractBlockBuilder<?>> preBuildConsumer;
    @Nullable
    protected BiConsumer<BlockShape, AbstractBlockBuilder<?>> postBuildConsumer;

    public BlocksBuilder setFenceSettings(FenceSettings fenceSettings) {
        this.fenceSettings = fenceSettings;
        return this;
    }

    public BlocksBuilder setStoneFenceSettings(class_1792 secondIngredient) {
        return this.setFenceSettings(new FenceSettings(secondIngredient, ExtShapeBlockTypes.STONE_WOOD_TYPE));
    }

    public BlocksBuilder setActivationSettings(ActivationSettings activationSettings) {
        this.activationSettings = activationSettings;
        return this;
    }

    public BlocksBuilder(@NotNull class_2248 baseBlock, SortedSet<BlockShape> shapesToBuild) {
        this.baseBlock = baseBlock;
        this.shapesToBuild = shapesToBuild;
        this.fenceSettings = FenceSettings.DEFAULT;
        this.activationSettings = ActivationSettings.STONE;
    }

    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder withExtension(@NotNull BlockExtension blockExtension) {
        return this.addPreBuildConsumer((blockShape, abstractBlockBuilder) -> abstractBlockBuilder.withExtension(blockExtension));
    }

    @Contract(value="-> this", mutates="this")
    public BlocksBuilder setPillar() {
        return this.addPreBuildConsumer((blockShape, abstractBlockBuilder) -> {
            if (blockShape == BlockShape.SLAB) {
                abstractBlockBuilder.instanceSupplier = builder -> new ExtShapePillarSlabBlock(builder.baseBlock, builder.blockSettings);
            } else if (blockShape == BlockShape.VERTICAL_SLAB) {
                abstractBlockBuilder.instanceSupplier = builder -> new ExtShapePillarVerticalSlabBlock(builder.baseBlock, builder.blockSettings);
            } else if (this.baseBlock.method_9595().method_11659().contains(class_2741.field_12496)) {
                abstractBlockBuilder.blockSettings.method_31710(((AbstractBlockStateAccessor)this.baseBlock.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048)).getMapColor());
            }
        });
    }

    @Contract(value="-> this", mutates="this")
    public BlocksBuilder setCircularPaving() {
        return this.addPreBuildConsumer((blockShape, abstractBlockBuilder) -> {
            if (blockShape == BlockShape.SLAB) {
                abstractBlockBuilder.instanceSupplier = builder -> new CircularPavingSlabBlock(builder.baseBlock, builder.blockSettings);
            } else if (blockShape == BlockShape.PRESSURE_PLATE) {
                ((PressurePlateBuilder)abstractBlockBuilder).instanceSupplier = builder -> new ExtShapeHorizontalFacingPressurePlateBlock(builder.baseBlock, builder.blockSettings, Objects.requireNonNull(this.activationSettings, "activationSettings"));
            }
        });
    }

    @Contract(value="-> this", mutates="this")
    public BlocksBuilder setPillarUvLocked() {
        return this.addPreBuildConsumer((blockShape, abstractBlockBuilder) -> {
            if (blockShape == BlockShape.SLAB) {
                abstractBlockBuilder.instanceSupplier = builder -> new ExtShapePillarUvLockedSlabBlock(builder.baseBlock, builder.blockSettings);
            } else if (this.baseBlock.method_9595().method_11659().contains(class_2741.field_12496)) {
                abstractBlockBuilder.blockSettings.method_31710(((AbstractBlockStateAccessor)this.baseBlock.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048)).getMapColor());
            }
        });
    }

    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder setPillar(boolean uvLocked) {
        return uvLocked ? this.setPillarUvLocked() : this.setPillar();
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder with(BlockShape shape) {
        this.shapesToBuild.add(shape);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder with(BlockShape ... shapes) {
        Collections.addAll(this.shapesToBuild, shapes);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder without(BlockShape shape) {
        this.shapesToBuild.remove(shape);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder without(BlockShape ... shapes) {
        for (BlockShape shape : shapes) {
            this.shapesToBuild.remove(shape);
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public BlocksBuilder withConstructionShapes() {
        return this.with(CONSTRUCTION_SHAPES);
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public BlocksBuilder withoutConstructionShapes() {
        return this.without(CONSTRUCTION_SHAPES);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder withFences(@NotNull FenceSettings fenceSettings) {
        this.with(BlockShape.FENCE, BlockShape.FENCE_GATE);
        this.fenceSettings = fenceSettings;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public BlocksBuilder withoutRedstone() {
        this.without(BlockShape.BUTTON, BlockShape.PRESSURE_PLATE);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder withButton(@NotNull ActivationSettings type) {
        this.with(BlockShape.BUTTON);
        this.activationSettings = type;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public BlocksBuilder withPressurePlate(@NotNull ActivationSettings activationSettings) {
        this.with(BlockShape.PRESSURE_PLATE);
        this.activationSettings = activationSettings;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_-> this", mutates="this")
    public BlocksBuilder addPreBuildConsumer(BiConsumer<BlockShape, AbstractBlockBuilder<? extends class_2248>> biConsumer) {
        if (this.preBuildConsumer == null) {
            this.preBuildConsumer = biConsumer;
        } else if (biConsumer != null) {
            this.preBuildConsumer = this.preBuildConsumer.andThen(biConsumer);
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_-> this", mutates="this")
    public BlocksBuilder addPostBuildConsumer(BiConsumer<BlockShape, AbstractBlockBuilder<? extends class_2248>> biConsumer) {
        if (this.postBuildConsumer == null) {
            this.postBuildConsumer = biConsumer;
        } else if (biConsumer != null) {
            this.postBuildConsumer = this.postBuildConsumer.andThen(biConsumer);
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_-> this")
    public BlocksBuilder compostingChance(float baseCompostingChance) {
        return this.addPostBuildConsumer((blockShape, builder) -> CompostingChanceRegistry.INSTANCE.add((class_1935)builder.itemInstance, (Object)Float.valueOf(blockShape.logicalCompleteness * baseCompostingChance)));
    }

    @CanIgnoreReturnValue
    @Contract(value="_-> this")
    public BlocksBuilder fuelTime(int baseFuelTime) {
        return this.addPostBuildConsumer((blockShape, builder) -> FuelRegistryEvents.BUILD.register((builder1, context) -> builder1.method_61762((class_1935)builder.itemInstance, (int)(blockShape.logicalCompleteness * (float)baseFuelTime))));
    }

    @CanIgnoreReturnValue
    @Contract(value="_-> this", mutates="this")
    public BlocksBuilder setRecipeGroup(Function<BlockShape, String> function) {
        this.addPostBuildConsumer((blockShape, blockBuilder) -> RecipeGroupRegistry.setRecipeGroup(blockBuilder.instance, (String)function.apply((BlockShape)blockShape)));
        return this;
    }

    public void build() {
        for (BlockShape shape : this.shapesToBuild) {
            AbstractBlockBuilder<? extends class_2248> blockBuilder;
            if (BlockBiMaps.getBlockOf(shape, this.baseBlock) != null || this.containsKey(shape) || (blockBuilder = this.createBlockBuilderFor(shape)) == null) continue;
            this.put(shape, blockBuilder);
        }
        Collection values = this.values();
        if (this.preBuildConsumer != null) {
            this.forEach(this.preBuildConsumer);
        }
        values.forEach(AbstractBlockBuilder::build);
        if (this.postBuildConsumer != null) {
            this.forEach(this.postBuildConsumer);
        }
    }

    @Contract(pure=true)
    @Nullable
    protected AbstractBlockBuilder<? extends class_2248> createBlockBuilderFor(@NotNull BlockShape shape) {
        int id = shape.id;
        AbstractBlockBuilder builder = switch (id) {
            case 0 -> new StairsBuilder(this.baseBlock);
            case 1 -> new SlabBuilder(this.baseBlock);
            case 2 -> new VerticalSlabBuilder(this.baseBlock);
            case 3 -> new VerticalStairsBuilder(this.baseBlock);
            case 4 -> new QuarterPieceBuilder(this.baseBlock);
            case 5 -> new VerticalQuarterPieceBuilder(this.baseBlock);
            case 6 -> new FenceBuilder(this.baseBlock, Objects.requireNonNull(this.fenceSettings, "fenceSettings").secondIngredient());
            case 7 -> new FenceGateBuilder(this.baseBlock, this.fenceSettings);
            case 8 -> new WallBuilder(this.baseBlock);
            case 9 -> new ButtonBuilder(this.baseBlock, Objects.requireNonNull(this.activationSettings, "activationSettings"));
            case 10 -> new PressurePlateBuilder(this.baseBlock, Objects.requireNonNull(this.activationSettings, "activationSettings"));
            default -> throw new IllegalArgumentException("The Shape object " + shape.method_15434() + " is not supported, which may be provided by other mod. You may extend BlocksBuilder class and define your own 'createBlockBuilderFor' with support for your Shape object.");
        };
        builder.defaultNamespace = this.defaultNamespace;
        builder.instanceCollection = this.instanceCollection;
        return builder;
    }

    @Contract(value="-> this")
    public BlocksBuilder markStoneCuttable() {
        ExtShapeBlockInterface.STONECUTTABLE_BASE_BLOCKS.add((Object)this.baseBlock);
        return this;
    }
}

