/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.builder;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_2248;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.extshape.builder.AbstractBlockBuilder;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.builder.BlocksBuilder;

public class BlocksBuilderFactory {
    private static final ImmutableSet<BlockShape> SHAPES = ImmutableSet.of((Object)BlockShape.STAIRS, (Object)BlockShape.SLAB, (Object)BlockShape.VERTICAL_SLAB, (Object)BlockShape.VERTICAL_STAIRS, (Object)BlockShape.QUARTER_PIECE, (Object)BlockShape.VERTICAL_QUARTER_PIECE, (Object[])new BlockShape[]{BlockShape.FENCE, BlockShape.FENCE_GATE, BlockShape.WALL, BlockShape.BUTTON, BlockShape.PRESSURE_PLATE});
    @Nullable
    public String defaultNamespace;
    @Nullable
    public Collection<class_2248> instanceCollection;
    @Nullable
    public Collection<class_2248> baseBlockCollection;

    protected BlocksBuilder createInternal(@NotNull class_2248 baseBlock, SortedSet<BlockShape> shapesToBuild) {
        return new BlocksBuilder(baseBlock, shapesToBuild);
    }

    protected BlocksBuilder create(@NotNull class_2248 baseBlock, SortedSet<BlockShape> shapesToBuild) {
        BlocksBuilder blocksBuilder = this.createInternal(baseBlock, shapesToBuild);
        blocksBuilder.defaultNamespace = this.defaultNamespace;
        blocksBuilder.instanceCollection = this.instanceCollection;
        if (this.baseBlockCollection != null) {
            this.baseBlockCollection.add(baseBlock);
        }
        return blocksBuilder;
    }

    public BlocksBuilder createAllShapes(@NotNull class_2248 baseBlock) {
        return this.create(baseBlock, new TreeSet<BlockShape>((Collection<BlockShape>)SHAPES));
    }

    @Contract(value="_ -> new")
    public BlocksBuilder createEmpty(@NotNull class_2248 baseBlock) {
        return this.create(baseBlock, new TreeSet<BlockShape>());
    }

    @Contract(value="_ -> new")
    public BlocksBuilder createConstructionOnly(@NotNull class_2248 baseBlock) {
        return this.createEmpty(baseBlock).withConstructionShapes();
    }

    @Contract(value="_ -> param1", mutates="param1")
    public <T extends AbstractBlockBuilder<?>> T modify(T blockBuilder) {
        blockBuilder.defaultNamespace = this.defaultNamespace;
        blockBuilder.instanceCollection = this.instanceCollection;
        return blockBuilder;
    }
}

