/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.extshape.builder.BlockShape;

public class ExtShapeConfig
implements Cloneable {
    public static final @Unmodifiable ExtShapeConfig DEFAULT_CONFIG = new ExtShapeConfig();
    public static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("extshape.json").toFile();
    static final Logger LOGGER = LoggerFactory.getLogger(ExtShapeConfig.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockShape.class, (Object)BlockShape.Serializer.INSTANCE).create();
    public static ExtShapeConfig CURRENT_CONFIG;
    public static boolean requireUpdateDisplay;
    public static boolean requireUpdateShapesToAddVanilla;
    public boolean addToVanillaGroups = true;
    public Collection<BlockShape> shapesToAddToVanilla = ImmutableList.of((Object)BlockShape.STAIRS, (Object)BlockShape.SLAB, (Object)BlockShape.QUARTER_PIECE, (Object)BlockShape.VERTICAL_STAIRS, (Object)BlockShape.VERTICAL_SLAB, (Object)BlockShape.VERTICAL_QUARTER_PIECE, (Object)BlockShape.FENCE, (Object)BlockShape.FENCE_GATE, (Object)BlockShape.WALL, (Object)BlockShape.PRESSURE_PLATE, (Object)BlockShape.BUTTON);
    public boolean showSpecificGroups = false;
    public Collection<BlockShape> shapesInSpecificGroups = this.shapesToAddToVanilla;

    public static void init() {
        if (CONFIG_FILE.exists()) {
            try {
                CURRENT_CONFIG = ExtShapeConfig.readFile(CONFIG_FILE);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read config file of Extended Block Shapes mod:", (Throwable)e);
                CURRENT_CONFIG = new ExtShapeConfig();
                CURRENT_CONFIG.tryWriteFile(CONFIG_FILE);
            }
        } else {
            LOGGER.info("No config file for Extended Block Shapes mod is found, creating new one.");
            CURRENT_CONFIG = new ExtShapeConfig();
            CURRENT_CONFIG.tryWriteFile(CONFIG_FILE);
        }
    }

    public void tryWriteFile(File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write Extended Block Shapes config file:", (Throwable)e);
        }
    }

    public static ExtShapeConfig readFile(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            ExtShapeConfig config = (ExtShapeConfig)GSON.fromJson((Reader)fileReader, ExtShapeConfig.class);
            if (config == null) {
                ExtShapeConfig newConfig = new ExtShapeConfig();
                newConfig.tryWriteFile(file);
                ExtShapeConfig extShapeConfig = newConfig;
                return extShapeConfig;
            }
            config.shapesToAddToVanilla = new LinkedHashSet<BlockShape>(config.shapesToAddToVanilla);
            config.shapesInSpecificGroups = new LinkedHashSet<BlockShape>(config.shapesInSpecificGroups);
            ExtShapeConfig extShapeConfig = config;
            return extShapeConfig;
        }
    }

    public ExtShapeConfig clone() {
        try {
            return (ExtShapeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtShapeConfig)) {
            return false;
        }
        ExtShapeConfig that = (ExtShapeConfig)o;
        return this.addToVanillaGroups == that.addToVanillaGroups && this.showSpecificGroups == that.showSpecificGroups && Objects.equals(this.shapesToAddToVanilla, that.shapesToAddToVanilla) && Objects.equals(this.shapesInSpecificGroups, that.shapesInSpecificGroups);
    }

    public int hashCode() {
        return Objects.hash(this.addToVanillaGroups, this.shapesToAddToVanilla, this.showSpecificGroups, this.shapesInSpecificGroups);
    }

    static {
        requireUpdateDisplay = false;
        requireUpdateShapesToAddVanilla = true;
    }
}

