/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.config;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7172;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.config.ExtShapeConfig;

@Environment(value=EnvType.CLIENT)
public class ExtShapeOptionsScreen
extends class_437 {
    private final class_437 parent;
    private final class_315 gameOptions;
    public final ExtShapeConfig oldConfig;
    public final ExtShapeConfig newConfig;
    private final class_342 shapesToAddToVanillaTextField;
    private final class_4185 resetShapesToAddToVanillaButton;
    private final class_342 shapesInSpecificGroupsTextField;
    private final class_4185 resetShapesInSpecificGroupsButton;
    private final class_339 addToVanillaGroupsButton;
    private final class_339 showSpecificGroupsButton;
    private final class_4185 finishButton;
    private boolean suppressedGroupsWarning;

    public ExtShapeOptionsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"options.extshape.title"));
        this.gameOptions = class_310.method_1551().field_1690;
        this.oldConfig = ExtShapeConfig.CURRENT_CONFIG;
        this.newConfig = ExtShapeConfig.CURRENT_CONFIG.clone();
        this.shapesToAddToVanillaTextField = (class_342)class_156.method_654((Object)new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - 205, 76, 358, 20, (class_2561)class_2561.method_43471((String)"options.extshape.shapesToAddToVanilla")), textFieldWidget -> {
            textFieldWidget.method_1880(Integer.MAX_VALUE);
            textFieldWidget.method_1852(ExtShapeOptionsScreen.convertCollectionToString(this.newConfig.shapesToAddToVanilla));
            textFieldWidget.method_1888(this.newConfig.addToVanillaGroups);
            textFieldWidget.method_1863(s -> {
                this.newConfig.shapesToAddToVanilla = ExtShapeOptionsScreen.convertStringToCollection(s);
                textFieldWidget.method_1887(ExtShapeOptionsScreen.getSuggestion(textFieldWidget.method_1882()));
            });
        });
        this.resetShapesToAddToVanillaButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"options.extshape.reset"), button -> this.shapesToAddToVanillaTextField.method_1852(ExtShapeOptionsScreen.convertCollectionToString(ExtShapeConfig.DEFAULT_CONFIG.shapesToAddToVanilla))).method_46434(this.field_22789 / 2 + 155, 76, 50, 20).method_46431();
        this.shapesInSpecificGroupsTextField = (class_342)class_156.method_654((Object)new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - 205, 121, 358, 20, (class_2561)class_2561.method_43471((String)"options.extshape.shapesInSpecificGroups")), textFieldWidget -> {
            textFieldWidget.method_1880(Integer.MAX_VALUE);
            textFieldWidget.method_1852(ExtShapeOptionsScreen.convertCollectionToString(this.newConfig.shapesInSpecificGroups));
            textFieldWidget.method_1888(this.newConfig.showSpecificGroups);
            textFieldWidget.method_1863(s -> {
                this.newConfig.shapesInSpecificGroups = ExtShapeOptionsScreen.convertStringToCollection(s);
                textFieldWidget.method_1887(ExtShapeOptionsScreen.getSuggestion(textFieldWidget.method_1882()));
            });
        });
        this.resetShapesInSpecificGroupsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"options.extshape.reset"), button -> this.shapesInSpecificGroupsTextField.method_1852(ExtShapeOptionsScreen.convertCollectionToString(ExtShapeConfig.DEFAULT_CONFIG.shapesInSpecificGroups))).method_46434(this.field_22789 / 2 + 155, 121, 50, 20).method_46431();
        this.addToVanillaGroupsButton = class_7172.method_41750((String)"options.extshape.addToVanillaGroups", (class_7172.class_7277)class_7172.method_42717((class_2561)class_2561.method_43469((String)"options.extshape.addToVanillaGroups.tooltip", (Object[])new Object[]{((class_1761)class_7923.field_44687.method_31140(class_7706.field_40195)).method_47313(), ((class_1761)class_7923.field_44687.method_31140(class_7706.field_41059)).method_7737(), ((class_1761)class_7923.field_44687.method_31140(class_7706.field_40743)).method_7737()}).method_10852((class_2561)(FabricLoader.getInstance().isModLoaded("extshape_blockus") ? class_2561.method_43470((String)"\n\n").method_10852((class_2561)class_2561.method_43471((String)"options.extshape.addToVanillaGroups.blockus").method_27692(class_124.field_1061)) : class_2561.method_43473())).method_27693("\n\n").method_10852((class_2561)class_2561.method_43469((String)"options.extshape.default", (Object[])new Object[]{class_5244.method_36134((boolean)ExtShapeConfig.DEFAULT_CONFIG.addToVanillaGroups)}).method_27692(class_124.field_1080)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"options.extshape.addToVanillaGroups.warning_for_1.20").method_27692(class_124.field_1054))), (boolean)true, value -> {
            this.newConfig.addToVanillaGroups = value;
            this.shapesToAddToVanillaTextField.method_1888(value.booleanValue());
        }).method_18520(this.gameOptions, this.field_22789 / 2 - 205, 36, 200);
        this.showSpecificGroupsButton = class_7172.method_41750((String)"options.extshape.showSpecificGroups", (class_7172.class_7277)class_7172.method_42717((class_2561)class_2561.method_43471((String)"options.extshape.showSpecificGroups.tooltip").method_27693("\n\n").method_10852((class_2561)class_2561.method_43469((String)"options.extshape.default", (Object[])new Object[]{class_5244.method_36134((boolean)ExtShapeConfig.DEFAULT_CONFIG.showSpecificGroups)}).method_27692(class_124.field_1080)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"options.extshape.showSpecificGroups.warning_for_1.20").method_27692(class_124.field_1054))), (boolean)false, value -> {
            this.newConfig.showSpecificGroups = value;
            this.shapesInSpecificGroupsTextField.method_1888(value.booleanValue());
        }).method_18520(this.gameOptions, this.field_22789 / 2 + 5, 36, 200);
        this.finishButton = new class_4185.class_7840(class_5244.field_24334, button -> this.method_25419()).method_46433(this.field_22789 / 2 - 100, this.field_22790 - 27).method_46437(200, 20).method_46431();
        this.suppressedGroupsWarning = false;
        this.parent = parent;
        this.addToVanillaGroupsButton.field_22763 = false;
        this.showSpecificGroupsButton.field_22763 = false;
        this.shapesInSpecificGroupsTextField.field_22763 = false;
        this.resetShapesInSpecificGroupsButton.field_22763 = false;
    }

    protected void method_25426() {
        this.addToVanillaGroupsButton.method_46421(this.field_22789 / 2 - 205);
        this.method_37063((class_364)this.addToVanillaGroupsButton);
        this.showSpecificGroupsButton.method_46421(this.field_22789 / 2 + 5);
        this.method_37063((class_364)this.showSpecificGroupsButton);
        this.shapesToAddToVanillaTextField.method_46421(this.field_22789 / 2 - 205);
        this.method_37063((class_364)this.shapesToAddToVanillaTextField);
        this.resetShapesToAddToVanillaButton.method_46421(this.field_22789 / 2 + 155);
        this.method_37063((class_364)this.resetShapesToAddToVanillaButton);
        this.shapesInSpecificGroupsTextField.method_46421(this.field_22789 / 2 - 205);
        this.method_37063((class_364)this.shapesInSpecificGroupsTextField);
        this.resetShapesInSpecificGroupsButton.method_46421(this.field_22789 / 2 + 155);
        this.method_37063((class_364)this.resetShapesInSpecificGroupsButton);
        this.finishButton.method_48229(this.field_22789 / 2 - 100, this.field_22790 - 27);
        this.method_37063((class_364)this.finishButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_35719(this.field_22793, this.field_22785.method_30937(), this.field_22789 / 2, 16, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"options.extshape.shapesToAddToVanilla.description"), this.field_22789 / 2 - 205, 61, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"options.extshape.shapesInSpecificGroups.description"), this.field_22789 / 2 - 205, 106, -1);
    }

    public void save() {
        ExtShapeConfig oldConfig = ExtShapeConfig.CURRENT_CONFIG;
        ExtShapeConfig.CURRENT_CONFIG = this.newConfig;
        if (!oldConfig.equals(this.newConfig)) {
            ExtShapeConfig.CURRENT_CONFIG.tryWriteFile(ExtShapeConfig.CONFIG_FILE);
        }
        if (oldConfig.showSpecificGroups != this.newConfig.showSpecificGroups || oldConfig.addToVanillaGroups != this.newConfig.addToVanillaGroups || !oldConfig.shapesToAddToVanilla.equals(this.newConfig.shapesToAddToVanilla) || !oldConfig.shapesInSpecificGroups.equals(this.newConfig.shapesInSpecificGroups)) {
            ExtShapeConfig.requireUpdateDisplay = true;
        }
        if (!oldConfig.shapesToAddToVanilla.equals(this.newConfig.shapesToAddToVanilla)) {
            ExtShapeConfig.requireUpdateShapesToAddVanilla = true;
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        if (!(this.suppressedGroupsWarning || this.newConfig.addToVanillaGroups || this.newConfig.showSpecificGroups || !this.oldConfig.addToVanillaGroups && !this.oldConfig.showSpecificGroups)) {
            this.field_22787.method_1507((class_437)new class_410(t -> {
                if (t) {
                    this.suppressedGroupsWarning = true;
                    this.method_25419();
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)"options.extshape.confirm"), (class_2561)class_2561.method_43469((String)"options.extshape.confirm.noGroups", (Object[])new Object[]{class_2561.method_43471((String)"options.extshape.addToVanillaGroups").method_27692(class_124.field_1080), class_2561.method_43471((String)"options.extshape.showSpecificGroups").method_27692(class_124.field_1080), class_5244.field_24333}), class_5244.field_24336, (class_2561)class_2561.method_43471((String)"options.extshape.confirm.redo")));
            return;
        }
        this.save();
        this.field_22787.method_1507(this.parent);
    }

    private static Collection<BlockShape> convertStringToCollection(String s) {
        return (Collection)Arrays.stream(StringUtils.split((String)s)).map(BlockShape::byName).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    private static String convertCollectionToString(Collection<BlockShape> list) {
        return list.stream().map(BlockShape::method_15434).collect(Collectors.joining(" "));
    }

    private static String getSuggestion(String currentValue) {
        String[] split = StringUtils.split((String)currentValue);
        if (split.length == 0) {
            return null;
        }
        String last = split[split.length - 1];
        if (StringUtils.isBlank((CharSequence)last)) {
            return null;
        }
        for (BlockShape value : BlockShape.values()) {
            String name = value.method_15434();
            if (!name.startsWith(last)) continue;
            return name.substring(last.length());
        }
        return null;
    }
}

