/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.data;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.data.RecipeGroupRegistry;
import pers.solid.extshape.data.VanillaStonecutting;
import pers.solid.extshape.mixin.StonecuttingRecipeJsonBuilderAccessor;
import pers.solid.extshape.util.BlockBiMaps;

public class CrossShapeDataGeneration {
    @NotNull
    public final class_2248 baseBlock;
    @Nullable
    public final String defaultNamespace;
    private final class_2446 recipeGenerator;
    @NotNull
    public final class_8790 exporter;
    public final boolean enableCuttingShape = false;

    public CrossShapeDataGeneration(@NotNull class_2248 baseBlock, @Nullable String defaultNamespace, @NotNull class_2446 recipeGenerator, @NotNull class_8790 exporter) {
        this.baseBlock = baseBlock;
        this.defaultNamespace = defaultNamespace;
        this.recipeGenerator = recipeGenerator;
        this.exporter = exporter;
    }

    public class_7800 getRecipeCategory() {
        return class_7800.field_40634;
    }

    public class_2960 recipeIdOf(class_1935 item, String suffix) {
        class_2960 identifier = class_5797.method_36442((class_1935)item);
        return class_2960.method_60655((String)(this.defaultNamespace == null ? identifier.method_12836() : this.defaultNamespace), (String)(suffix == null ? identifier.method_12832() : identifier.method_12832() + suffix));
    }

    public void slabToVerticalSlab(@NotNull class_2248 slab, @NotNull class_2248 verticalSlab) {
        this.writeBlockRotationRecipe(slab, verticalSlab, null, "has_slab");
    }

    public void verticalSlabToSlab(@NotNull class_2248 verticalSlab, @NotNull class_2248 slab) {
        this.writeBlockRotationRecipe(verticalSlab, slab, "_from_vertical_slab", "has_vertical_slab");
    }

    public void stairsToVerticalStairs(@NotNull class_2248 stairs, @NotNull class_2248 verticalStairs) {
        this.writeBlockRotationRecipe(stairs, verticalStairs, null, "has_stairs");
    }

    public void verticalStairsToStairs(@NotNull class_2248 verticalStairs, @NotNull class_2248 stairs) {
        this.writeBlockRotationRecipe(verticalStairs, stairs, "_from_vertical_stairs", "has_vertical_stairs");
    }

    public void quarterPieceToVerticalQuarterPiece(@NotNull class_2248 quarterPiece, @NotNull class_2248 verticalQuarterPiece) {
        this.writeBlockRotationRecipe(quarterPiece, verticalQuarterPiece, null, "has_quarter_piece");
    }

    public void verticalQuarterPieceToQuarterPiece(@NotNull class_2248 verticalQuarterPiece, @NotNull class_2248 quarterPiece) {
        this.writeBlockRotationRecipe(verticalQuarterPiece, quarterPiece, "_from_vertical_quarter_piece", "has_vertical_quarter_piece");
    }

    protected void writeBlockRotationRecipe(@NotNull class_2248 from, @NotNull class_2248 to, @Nullable String suffix, String criterionName) {
        class_2960 recipeId = this.recipeIdOf((class_1935)to, suffix);
        class_2450 recipe = this.recipeGenerator.method_62749(this.getRecipeCategory(), (class_1935)to).method_10451(class_1856.method_8091((class_1935[])new class_1935[]{from}));
        String recipeGroup = RecipeGroupRegistry.getRecipeGroup((class_1935)to);
        recipe.method_10452((String)(StringUtils.isEmpty((CharSequence)recipeGroup) ? recipeGroup : recipeGroup + "_from_rotation")).method_10442(criterionName, this.recipeGenerator.method_10426((class_1935)from));
        recipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId));
    }

    public void cutStairsToQuarterPiece(@NotNull class_2248 stairs, @NotNull class_2248 quarterPiece, @Nullable String suffix, int scale) {
        this.generateSimpleStonecuttingRecipe((class_1935)stairs, (class_1935)quarterPiece, 3 * scale, suffix == null ? "_from_stairs_stonecutting" : suffix, "has_stairs");
    }

    public void craftSlabToQuarterPiece(@NotNull class_2248 slab, @NotNull class_2248 quarterPiece, @Nullable String suffix) {
        class_2960 recipeId = this.recipeIdOf((class_1935)quarterPiece, suffix == null ? "_from_slab" : suffix);
        String recipeGroup = RecipeGroupRegistry.getRecipeGroup((class_1935)quarterPiece);
        class_2447 recipe = this.recipeGenerator.method_62747(this.getRecipeCategory(), (class_1935)quarterPiece, 6).method_10439("###").method_10434(Character.valueOf('#'), (class_1935)slab).method_10435((String)(StringUtils.isEmpty((CharSequence)recipeGroup) ? recipeGroup : recipeGroup + "_from_slab")).method_10429("has_slab", this.recipeGenerator.method_10426((class_1935)slab));
        recipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId));
    }

    public void cutSlabToQuarterPiece(@NotNull class_2248 slab, @NotNull class_2248 quarterPiece, @Nullable String suffix, int scale) {
        this.generateSimpleStonecuttingRecipe((class_1935)slab, (class_1935)quarterPiece, 2 * scale, suffix == null ? "_from_slab_stonecutting" : suffix, "has_slab");
    }

    public void craftVerticalSlabToQuarterPiece(@NotNull class_2248 verticalSlab, @NotNull class_2248 quarterPiece, @Nullable String suffix) {
        class_2960 recipeId = this.recipeIdOf((class_1935)quarterPiece, suffix == null ? "_from_vertical_slab" : suffix);
        String recipeGroup = RecipeGroupRegistry.getRecipeGroup((class_1935)quarterPiece);
        class_2447 recipe = this.recipeGenerator.method_62747(this.getRecipeCategory(), (class_1935)quarterPiece, 6).method_10439("###").method_10434(Character.valueOf('#'), (class_1935)verticalSlab).method_10435((String)(StringUtils.isEmpty((CharSequence)recipeGroup) ? recipeGroup : recipeGroup + "_from_vertical_slab")).method_10429("has_vertical_slab", this.recipeGenerator.method_10426((class_1935)verticalSlab));
        recipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId));
    }

    public void cutVerticalSlabToQuarterPiece(@NotNull class_2248 verticalSlab, @NotNull class_2248 quarterPiece, @Nullable String suffix, int scale) {
        this.generateSimpleStonecuttingRecipe((class_1935)verticalSlab, (class_1935)quarterPiece, 2 * scale, suffix == null ? "_from_vertical_slab_stonecutting" : suffix, "has_vertical_slab");
    }

    public void craftVerticalSlabToVerticalQuarterPiece(@NotNull class_2248 verticalSlab, @NotNull class_2248 verticalQuarterPiece, @Nullable String suffix) {
        class_2960 recipeId = this.recipeIdOf((class_1935)verticalQuarterPiece, suffix == null ? "_from_vertical_slab" : suffix);
        String recipeGroup = RecipeGroupRegistry.getRecipeGroup((class_1935)verticalQuarterPiece);
        class_2447 recipe = this.recipeGenerator.method_62747(this.getRecipeCategory(), (class_1935)verticalQuarterPiece, 6).method_10439("#").method_10439("#").method_10439("#").method_10434(Character.valueOf('#'), (class_1935)verticalSlab).method_10435((String)(StringUtils.isEmpty((CharSequence)recipeGroup) ? recipeGroup : recipeGroup + "_from_vertical_slab")).method_10429("has_vertical_slab", this.recipeGenerator.method_10426((class_1935)verticalSlab));
        recipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId));
    }

    public void cutVerticalSlabToVerticalQuarterPiece(@NotNull class_2248 verticalSlab, @NotNull class_2248 verticalQuarterPiece, @Nullable String suffix, int scale) {
        this.generateSimpleStonecuttingRecipe((class_1935)verticalSlab, (class_1935)verticalQuarterPiece, 2 * scale, suffix == null ? "_from_vertical_slab_stonecutting" : suffix, "has_vertical_slab");
    }

    public void cutVerticalStairsToVerticalQuarterPiece(@NotNull class_2248 verticalStairs, @NotNull class_2248 verticalQuarterPiece, @Nullable String suffix, int scale) {
        this.generateSimpleStonecuttingRecipe((class_1935)verticalStairs, (class_1935)verticalQuarterPiece, 3 * scale, suffix == null ? "_from_vertical_stairs_stonecutting" : suffix, "has_vertical_stairs");
    }

    protected void generateSimpleStonecuttingRecipe(class_1935 ingredient, class_1935 result, int count, @Nullable String suffix, String criterionName) {
        if (ingredient == null || result == null) {
            return;
        }
        class_2960 recipeId = this.recipeIdOf(result, suffix);
        class_3981 recipe = class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{ingredient}), (class_7800)this.getRecipeCategory(), (class_1935)result, (int)count).method_35919(RecipeGroupRegistry.getRecipeGroup(result)).method_17970(criterionName, this.recipeGenerator.method_10426(ingredient));
        recipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId));
    }

    public void generateCrossShapeData() {
        @NotNull Iterable<ObjectIntPair<class_2248>> uncutBaseBlocks = this.getUncutBaseBlocks();
        @Nullable class_2248 slab = BlockBiMaps.getBlockOf(BlockShape.SLAB, this.baseBlock);
        @Nullable class_2248 verticalSlab = BlockBiMaps.getBlockOf(BlockShape.VERTICAL_SLAB, this.baseBlock);
        if (slab != null && verticalSlab != null) {
            this.slabToVerticalSlab(slab, verticalSlab);
            this.verticalSlabToSlab(verticalSlab, slab);
        }
        @Nullable class_2248 stairs = BlockBiMaps.getBlockOf(BlockShape.STAIRS, this.baseBlock);
        @Nullable class_2248 verticalStairs = BlockBiMaps.getBlockOf(BlockShape.VERTICAL_STAIRS, this.baseBlock);
        if (stairs != null && verticalStairs != null) {
            this.stairsToVerticalStairs(stairs, verticalStairs);
            this.verticalStairsToStairs(verticalStairs, stairs);
        }
        @Nullable class_2248 quarterPiece = BlockBiMaps.getBlockOf(BlockShape.QUARTER_PIECE, this.baseBlock);
        @Nullable class_2248 verticalQuarterPiece = BlockBiMaps.getBlockOf(BlockShape.VERTICAL_QUARTER_PIECE, this.baseBlock);
        if (quarterPiece != null && verticalQuarterPiece != null) {
            this.quarterPieceToVerticalQuarterPiece(quarterPiece, verticalQuarterPiece);
            this.verticalQuarterPieceToQuarterPiece(verticalQuarterPiece, quarterPiece);
        }
        boolean shouldStoneCut = ExtShapeBlockInterface.isStoneCut(this.baseBlock);
        for (BlockShape blockShape : BlockShape.values()) {
            for (ObjectIntPair<class_2248> uncutBaseBlockInfo : uncutBaseBlocks) {
                class_3981 recipe;
                class_2248 uncutBaseBlock = (class_2248)uncutBaseBlockInfo.left();
                String path = class_7923.field_41175.method_10221((Object)uncutBaseBlock).method_12832();
                class_2248 output = BlockBiMaps.getBlockOf(blockShape, this.baseBlock);
                if (!(output instanceof ExtShapeBlockInterface) || !((ExtShapeBlockInterface)output).shouldWriteStonecuttingRecipe() || (recipe = ((ExtShapeBlockInterface)output).getStonecuttingRecipe(this.recipeGenerator)) == null) continue;
                class_2960 secondaryId = class_5797.method_36442((class_1935)output).method_48331("_from_" + path + "_stonecutting");
                StonecuttingRecipeJsonBuilderAccessor accessor = (StonecuttingRecipeJsonBuilderAccessor)recipe;
                class_3981 secondaryRecipe = class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{uncutBaseBlock}), (class_7800)accessor.getCategory(), (class_1935)accessor.getOutput(), (int)(accessor.getCount() * uncutBaseBlockInfo.rightInt())).method_17970("has_" + path, this.recipeGenerator.method_10426((class_1935)uncutBaseBlock));
                secondaryRecipe.method_17972(this.exporter, class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)secondaryId));
            }
        }
        if (quarterPiece != null) {
            if (stairs != null && shouldStoneCut) {
                this.cutStairsToQuarterPiece(stairs, quarterPiece, null, 1);
            }
            if (slab != null) {
                this.craftSlabToQuarterPiece(slab, quarterPiece, null);
                if (shouldStoneCut) {
                    this.cutSlabToQuarterPiece(slab, quarterPiece, null, 1);
                }
            }
            if (verticalSlab != null) {
                this.craftVerticalSlabToQuarterPiece(verticalSlab, quarterPiece, null);
                if (shouldStoneCut) {
                    this.cutVerticalSlabToQuarterPiece(verticalSlab, quarterPiece, null, 1);
                }
            }
        }
        if (verticalQuarterPiece != null) {
            if (verticalSlab != null) {
                this.craftVerticalSlabToVerticalQuarterPiece(verticalSlab, verticalQuarterPiece, null);
                if (shouldStoneCut) {
                    this.cutVerticalSlabToVerticalQuarterPiece(verticalSlab, verticalQuarterPiece, null, 1);
                }
            }
            if (verticalStairs != null && shouldStoneCut) {
                this.cutVerticalStairsToVerticalQuarterPiece(verticalStairs, verticalQuarterPiece, null, 1);
            }
        }
    }

    @NotNull
    protected Iterable<ObjectIntPair<class_2248>> getUncutBaseBlocks() {
        ImmutableCollection blocks = VanillaStonecutting.INSTANCE.get((Object)this.baseBlock);
        ImmutableCollection weightedBlocks = VanillaStonecutting.INSTANCE_WITH_WEIGHT.get((Object)this.baseBlock);
        return Iterables.concat(blocks.isEmpty() ? Collections.emptyList() : (Iterable)blocks.stream().map(block -> ObjectIntPair.of((Object)block, (int)1)).collect(Collectors.toList()), (Iterable)weightedBlocks);
    }
}

