/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_11389;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import org.apache.commons.lang3.Validate;
import pers.solid.extshape.block.CopperManager;
import pers.solid.extshape.block.ExtShapeBlocks;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.tag.ExtShapeTags;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.BlockCollections;

public class ExtShapeBlockTagProvider
extends FabricTagProvider.BlockTagProvider {
    public static final ImmutableList<ImmutableMap<BlockShape, class_6862<class_2248>>> TYPE_SHAPE_TAGS = ImmutableList.of(ExtShapeTags.SHAPE_TO_WOODEN_TAG, ExtShapeTags.SHAPE_TO_LOG_TAG, ExtShapeTags.SHAPE_TO_WOOLEN_TAG, ExtShapeTags.SHAPE_TO_CONCRETE_TAG, ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG);
    public static final ImmutableSet<class_2248> STONE_BASE_BLOCKS = ImmutableSet.of((Object)class_2246.field_10340, (Object)class_2246.field_10360, (Object)class_2246.field_23869, (Object)class_2246.field_23873, (Object)class_2246.field_23876, (Object)class_2246.field_23880, (Object[])new class_2248[0]);

    public ExtShapeBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        class_2248 slab;
        class_2248 stairs;
        this.valueLookupBuilder(class_3481.field_28088).method_71553(ExtShapeTags.WOOLEN_BLOCKS);
        for (class_6862 tag2 : ExtShapeTags.SHAPE_TO_LOG_TAG.values()) {
            this.valueLookupBuilder(ExtShapeTags.LOG_BLOCKS).method_71553(tag2);
        }
        ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG.forEach((blockShape, tag) -> {
            class_6862 stained = (class_6862)ExtShapeTags.SHAPE_TO_STAINED_TERRACOTTA_TAG.get(blockShape);
            Objects.requireNonNull(stained);
            this.valueLookupBuilder((class_6862)tag).method_71553(stained);
        });
        for (Map.Entry entry : ExtShapeTags.SHAPE_TO_TAG.entrySet()) {
            BlockShape shape2 = (BlockShape)entry.getKey();
            class_6862 shapeTag = (class_6862)entry.getValue();
            class_11389 builder = this.valueLookupBuilder(shapeTag);
            for (ImmutableMap map : TYPE_SHAPE_TAGS) {
                class_6862 typeShapeTag = (class_6862)map.get((Object)shape2);
                if (typeShapeTag != null && ExtShapeTags.SHAPE_TO_WOODEN_TAG.containsKey((Object)shape2) && map == ExtShapeTags.SHAPE_TO_LOG_TAG) {
                    this.valueLookupBuilder((class_6862)ExtShapeTags.SHAPE_TO_WOODEN_TAG.get((Object)shape2)).method_71553(typeShapeTag);
                    continue;
                }
                if (typeShapeTag == null || typeShapeTag.comp_327().method_12836().equals("minecraft")) continue;
                builder.method_71553(typeShapeTag);
            }
        }
        this.valueLookupBuilder(class_3481.field_15469).method_71553(ExtShapeTags.GLAZED_TERRACOTTA_SLABS);
        for (class_6862 tag2 : ExtShapeTags.SHAPE_TO_WOOLEN_TAG.values()) {
            this.valueLookupBuilder(ExtShapeTags.WOOLEN_BLOCKS).method_71553(tag2);
        }
        this.valueLookupBuilder(ExtShapeTags.WOODEN_BLOCKS).method_71553(ExtShapeTags.LOG_BLOCKS);
        for (class_6862 tag2 : ExtShapeTags.SHAPE_TO_WOODEN_TAG.values()) {
            this.valueLookupBuilder(ExtShapeTags.WOODEN_BLOCKS).method_71553(tag2);
        }
        this.valueLookupBuilder(class_3481.field_33715).method_71558((Object[])new class_2248[]{ExtShapeBlocks.PETRIFIED_OAK_PLANKS, ExtShapeBlocks.SMOOTH_STONE_DOUBLE_SLAB});
        this.addForShapes((class_6862<class_2248>)class_3481.field_33715, Iterables.concat((Iterable[])new Iterable[]{BlockCollections.STONES, BlockCollections.UNCOLORED_SANDSTONES, BlockCollections.RED_SANDSTONES, CopperManager.COPPER_BLOCKS, CopperManager.CUT_COPPER_BLOCKS, CopperManager.WAXED_COPPER_BLOCKS, CopperManager.WAXED_CUT_COPPER_BLOCKS, ImmutableSet.of((Object)class_2246.field_10445, (Object)class_2246.field_10441, (Object)class_2246.field_10205, (Object)class_2246.field_10085, (Object)class_2246.field_10104, (Object)class_2246.field_9989, (Object[])new class_2248[]{class_2246.field_10540, class_2246.field_10201, class_2246.field_27159, class_2246.field_10515, class_2246.field_10056, class_2246.field_10065, class_2246.field_37556, class_2246.field_37557, class_2246.field_55054, class_2246.field_10266, class_2246.field_10471, class_2246.field_10462, class_2246.field_10234, class_2246.field_10153, class_2246.field_10044, class_2246.field_23868, class_2246.field_9978, class_2246.field_9986, class_2246.field_10381, class_2246.field_10225, class_2246.field_10135, class_2246.field_10006, class_2246.field_10297, class_2246.field_10360, class_2246.field_10286, class_2246.field_22108, class_2246.field_22109, class_2246.field_22423, class_2246.field_23869, class_2246.field_23873, class_2246.field_23874, class_2246.field_23880, class_2246.field_27165, class_2246.field_47030, class_2246.field_47035, class_2246.field_27114, class_2246.field_28049, class_2246.field_28888, class_2246.field_29031, class_2246.field_28892, class_2246.field_28896, class_2246.field_28900, class_2246.field_22091, class_2246.field_29032, class_2246.field_33508, class_2246.field_33509, class_2246.field_33510})}));
        for (class_6862 tag2 : Iterables.concat((Iterable)ExtShapeTags.SHAPE_TO_CONCRETE_TAG.values(), (Iterable)ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG.values())) {
            this.valueLookupBuilder(class_3481.field_33715).method_71553(tag2);
        }
        this.valueLookupBuilder(class_3481.field_33715).method_71553(ExtShapeTags.GLAZED_TERRACOTTA_SLABS);
        this.valueLookupBuilder(class_3481.field_33713).method_71553(ExtShapeTags.WOODEN_BLOCKS);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33713, class_2246.field_46282, class_2246.field_46283);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33716, class_2246.field_10566, class_2246.field_10253, class_2246.field_10491, class_2246.field_10460);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33714, class_2246.field_10541, class_2246.field_22115, class_2246.field_22122, class_2246.field_37568, class_2246.field_28681, class_2246.field_54731);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33719, class_2246.field_10441, class_2246.field_10085, class_2246.field_33508, class_2246.field_33509);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33719, Iterables.concat(CopperManager.COPPER_BLOCKS, CopperManager.CUT_COPPER_BLOCKS, CopperManager.CUT_COPPER_BLOCKS, CopperManager.WAXED_CUT_COPPER_BLOCKS));
        this.addForShapes((class_6862<class_2248>)class_3481.field_33718, class_2246.field_10205, class_2246.field_10201, class_2246.field_10234, class_2246.field_33510);
        this.addForShapes((class_6862<class_2248>)class_3481.field_33717, class_2246.field_10540, class_2246.field_22108, class_2246.field_22109, class_2246.field_22423);
        for (class_2248 baseBlock : ExtShapeBlocks.getBaseBlocks()) {
            if (Stream.of(BlockCollections.LOGS, BlockCollections.STRIPPED_LOGS, BlockCollections.WOODS, BlockCollections.STRIPPED_WOODS, BlockCollections.STEMS, BlockCollections.STRIPPED_STEMS, BlockCollections.HYPHAES, BlockCollections.STRIPPED_HYPHAES).anyMatch(blocks -> blocks.contains((Object)baseBlock))) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_LOG_TAG);
                continue;
            }
            if (BlockCollections.PLANKS.contains((Object)baseBlock) || baseBlock == class_2246.field_41072 || baseBlock == class_2246.field_41073) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_WOODEN_TAG);
                continue;
            }
            if (BlockCollections.CONCRETES.contains((Object)baseBlock)) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_CONCRETE_TAG);
                continue;
            }
            if (BlockCollections.STAINED_TERRACOTTA.contains((Object)baseBlock)) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_STAINED_TERRACOTTA_TAG);
                continue;
            }
            if (baseBlock == class_2246.field_10415) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG);
                continue;
            }
            if (BlockCollections.WOOLS.contains((Object)baseBlock)) {
                this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_WOOLEN_TAG);
                continue;
            }
            if (BlockCollections.GLAZED_TERRACOTTA.contains((Object)baseBlock)) {
                this.addShapesToCorrespondingTags(baseBlock, Map.of(BlockShape.SLAB, ExtShapeTags.GLAZED_TERRACOTTA_SLABS));
                continue;
            }
            this.addShapesToCorrespondingTags(baseBlock, (Map<BlockShape, ? extends class_6862<class_2248>>)ExtShapeTags.SHAPE_TO_TAG);
        }
        this.addForConstructionShapes((class_6862<class_2248>)class_3481.field_15460, class_2246.field_10566, class_2246.field_46282, class_2246.field_46283);
        this.addForConstructionShapes((class_6862<class_2248>)class_3481.field_15497, class_2246.field_10566);
        this.addForConstructionShapes((class_6862<class_2248>)class_3481.field_56529, class_2246.field_10566);
        ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG.forEach((shape, tag) -> {
            if (shape.isConstruction) {
                this.valueLookupBuilder(class_3481.field_56529).method_71553(tag);
            }
        });
        this.addForShapes((class_6862<class_2248>)class_3481.field_25590, class_2246.field_9987);
        this.addForShapes((class_6862<class_2248>)class_3481.field_17754, class_2246.field_9987);
        for (class_2248 block : BlockCollections.UNCOLORED_SANDSTONES) {
            stairs = BlockBiMaps.getBlockOf(BlockShape.STAIRS, block);
            if (this.isValidBlock(stairs)) {
                this.valueLookupBuilder(ConventionalBlockTags.UNCOLORED_SANDSTONE_STAIRS).method_71554((Object)stairs);
            }
            if (!this.isValidBlock(slab = BlockBiMaps.getBlockOf(BlockShape.SLAB, block))) continue;
            this.valueLookupBuilder(ConventionalBlockTags.UNCOLORED_SANDSTONE_SLABS).method_71554((Object)slab);
        }
        for (class_2248 block : BlockCollections.RED_SANDSTONES) {
            stairs = BlockBiMaps.getBlockOf(BlockShape.STAIRS, block);
            if (this.isValidBlock(stairs)) {
                this.valueLookupBuilder(ConventionalBlockTags.RED_SANDSTONE_STAIRS).method_71554((Object)stairs);
            }
            if (!this.isValidBlock(slab = BlockBiMaps.getBlockOf(BlockShape.SLAB, block))) continue;
            this.valueLookupBuilder(ConventionalBlockTags.RED_SANDSTONE_SLABS).method_71554((Object)slab);
        }
        this.addForShapes((class_6862<class_2248>)class_3481.field_23800, class_2246.field_10205, class_2246.field_23880, class_2246.field_33510);
        this.addForShapes((class_6862<class_2248>)class_3481.field_17753, class_2246.field_10540);
        this.addForShapes(ExtShapeTags.SNOW, class_2246.field_10491);
        this.addForConstructionShapes((class_6862<class_2248>)class_3481.field_33641, class_2246.field_10460, class_2246.field_28681);
        this.addForConstructionShapes((class_6862<class_2248>)class_3481.field_15460, class_2246.field_10460);
        this.addForShapes((class_6862<class_2248>)class_3481.field_25588, class_2246.field_10515);
        this.addForShapes((class_6862<class_2248>)class_3481.field_17753, class_2246.field_10540, class_2246.field_10471, class_2246.field_10462, class_2246.field_22423);
        Iterator dyedTags = Iterators.cycle(BlockCollections.DYED_TAGS);
        for (class_2248 baseBlock : Iterables.concat(BlockCollections.WOOLS, BlockCollections.CONCRETES, BlockCollections.STAINED_TERRACOTTA, BlockCollections.GLAZED_TERRACOTTA)) {
            class_6862 dyedTag = (class_6862)dyedTags.next();
            this.addForShapes((class_6862<class_2248>)dyedTag, baseBlock);
        }
        Validate.validState((dyedTags.next() == BlockCollections.DYED_TAGS.getFirst() ? 1 : 0) != 0, (String)"BlockCollections.DYED_TAGS is not correctly iterated", (Object[])new Object[0]);
    }

    protected void addForShapes(class_6862<class_2248> tag, class_2248 baseBlock) {
        this.checkValidBaseBlock(baseBlock);
        class_11389 builder = this.valueLookupBuilder(tag);
        for (BlockShape shape : BlockShape.values()) {
            class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
            if (!this.isValidBlock(block)) continue;
            builder.method_71554((Object)block);
        }
    }

    protected void addForShapes(class_6862<class_2248> tag, class_2248 ... baseBlocks) {
        this.addForShapes(tag, Arrays.asList(baseBlocks));
    }

    protected void addForShapes(class_6862<class_2248> tag, Iterable<class_2248> baseBlocks) {
        class_11389 builder = this.valueLookupBuilder(tag);
        for (class_2248 baseBlock : baseBlocks) {
            this.checkValidBaseBlock(baseBlock);
            for (BlockShape shape : BlockShape.values()) {
                class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
                if (!this.isValidBlock(block)) continue;
                builder.method_71554((Object)block);
            }
        }
    }

    protected void addForConstructionShapes(class_6862<class_2248> tag, class_2248 baseBlock) {
        this.checkValidBaseBlock(baseBlock);
        class_11389 builder = this.valueLookupBuilder(tag);
        for (BlockShape shape : BlockShape.values()) {
            class_2248 block;
            if (!shape.isConstruction || !this.isValidBlock(block = BlockBiMaps.getBlockOf(shape, baseBlock))) continue;
            builder.method_71554((Object)block);
        }
    }

    protected void addForConstructionShapes(class_6862<class_2248> tag, class_2248 ... baseBlocks) {
        this.addForConstructionShapes(tag, Arrays.asList(baseBlocks));
    }

    protected void addForConstructionShapes(class_6862<class_2248> tag, Iterable<class_2248> baseBlocks) {
        class_11389 builder = this.valueLookupBuilder(tag);
        for (class_2248 baseBlock : baseBlocks) {
            this.checkValidBaseBlock(baseBlock);
            for (BlockShape shape : BlockShape.values()) {
                class_2248 block;
                if (!shape.isConstruction || !this.isValidBlock(block = BlockBiMaps.getBlockOf(shape, baseBlock))) continue;
                builder.method_71554((Object)block);
            }
        }
    }

    protected void addShapesToCorrespondingTags(class_2248 baseBlock, Map<BlockShape, ? extends class_6862<class_2248>> tags) {
        this.checkValidBaseBlock(baseBlock);
        for (BlockShape shape : BlockShape.values()) {
            class_6862 tag;
            class_6862 class_68622 = tag = tags.containsKey(shape) ? tags.get(shape) : (class_6862)ExtShapeTags.SHAPE_TO_TAG.get((Object)shape);
            if (STONE_BASE_BLOCKS.contains((Object)baseBlock)) {
                if (class_3481.field_24076.equals((Object)tag)) {
                    tag = class_3481.field_24077;
                } else if (class_3481.field_15493.equals((Object)tag)) {
                    tag = class_3481.field_44590;
                }
            }
            Preconditions.checkNotNull((Object)tag, (String)"tag of shape %s", (Object)shape);
            class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
            if (!this.isValidBlock(block)) continue;
            this.valueLookupBuilder(tag).method_71554((Object)block);
        }
    }

    protected void checkValidBaseBlock(class_2248 baseBlock) {
        Preconditions.checkArgument((boolean)ExtShapeBlocks.containsBaseBlock(baseBlock), (String)"%s is not a base block", (Object)baseBlock);
    }

    protected boolean isValidBlock(class_2248 block) {
        return ExtShapeBlocks.contains(block);
    }
}

