/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.data;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11389;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.data.ExtShapeBlockTagProvider;
import pers.solid.extshape.tag.ExtShapeTags;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.BlockCollections;

public class ExtShapeItemTagProvider
extends FabricTagProvider.ItemTagProvider {
    @NotNull
    protected final ExtShapeBlockTagProvider blockTagProvider;

    public ExtShapeItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @NotNull ExtShapeBlockTagProvider blockTagProvider) {
        super(output, completableFuture, (FabricTagProvider.BlockTagProvider)blockTagProvider);
        this.blockTagProvider = blockTagProvider;
    }

    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        this.copy(class_3481.field_38835, class_3489.field_28300);
        this.copyWithSameId(ExtShapeTags.WOOLEN_BLOCKS);
        this.copyWithSameId(ExtShapeTags.WOODEN_BLOCKS);
        this.copyWithSameId(ExtShapeTags.LOG_BLOCKS);
        for (class_6862 tag : Iterables.concat((Iterable[])new Iterable[]{ExtShapeTags.SHAPE_TO_TAG.values(), ExtShapeTags.SHAPE_TO_WOODEN_TAG.values(), ExtShapeTags.SHAPE_TO_LOG_TAG.values(), ExtShapeTags.SHAPE_TO_WOOLEN_TAG.values(), ExtShapeTags.SHAPE_TO_CONCRETE_TAG.values(), ExtShapeTags.SHAPE_TO_TERRACOTTA_TAG.values(), ExtShapeTags.SHAPE_TO_STAINED_TERRACOTTA_TAG.values()})) {
            this.copyWithSameId((class_6862<class_2248>)tag);
        }
        this.copyWithSameId(ExtShapeTags.GLAZED_TERRACOTTA_SLABS);
        this.copy(ConventionalBlockTags.UNCOLORED_SANDSTONE_STAIRS, ConventionalItemTags.UNCOLORED_SANDSTONE_STAIRS);
        this.copy(ConventionalBlockTags.UNCOLORED_SANDSTONE_SLABS, ConventionalItemTags.UNCOLORED_SANDSTONE_SLABS);
        this.copy(ConventionalBlockTags.RED_SANDSTONE_STAIRS, ConventionalItemTags.RED_SANDSTONE_STAIRS);
        this.copy(ConventionalBlockTags.RED_SANDSTONE_SLABS, ConventionalItemTags.RED_SANDSTONE_SLABS);
        for (int i = 0; i < BlockCollections.DYED_TAGS.size(); ++i) {
            this.copy((class_6862)BlockCollections.DYED_TAGS.get(i), (class_6862)BlockCollections.DYED_ITEM_TAGS.get(i));
        }
        this.addForShapes((class_6862<class_1792>)class_3489.field_23211, Iterables.concat(BlockCollections.HYPHAES, BlockCollections.STRIPPED_HYPHAES, Arrays.asList(class_2246.field_22126, class_2246.field_22127)));
        this.addForShapes((class_6862<class_1792>)class_3489.field_24481, class_2246.field_10205, class_2246.field_33510, class_2246.field_23880);
    }

    protected void copyWithSameId(class_6862<class_2248> blockTag) {
        this.copy(blockTag, class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)blockTag.comp_327()));
    }

    protected void addForShapes(class_6862<class_1792> tag, class_2248 baseBlock) {
        this.checkValidBaseBlock(baseBlock);
        class_11389 builder = this.valueLookupBuilder(tag);
        for (BlockShape shape : BlockShape.values()) {
            class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
            if (!this.isValidBlock(block)) continue;
            builder.method_71554((Object)block.method_8389());
        }
    }

    protected void addForShapes(class_6862<class_1792> tag, class_2248 ... baseBlocks) {
        this.addForShapes(tag, Arrays.asList(baseBlocks));
    }

    protected void addForShapes(class_6862<class_1792> tag, Iterable<class_2248> baseBlocks) {
        class_11389 builder = this.valueLookupBuilder(tag);
        for (class_2248 baseBlock : baseBlocks) {
            this.checkValidBaseBlock(baseBlock);
            for (BlockShape shape : BlockShape.values()) {
                class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
                if (!this.isValidBlock(block)) continue;
                builder.method_71554((Object)block.method_8389());
            }
        }
    }

    @Contract(value="null -> fail")
    protected void checkValidBaseBlock(class_2248 baseBlock) {
        this.blockTagProvider.checkValidBaseBlock(baseBlock);
    }

    @Contract(value="null -> false")
    protected boolean isValidBlock(class_2248 block) {
        return this.blockTagProvider.isValidBlock(block);
    }
}

