/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5953;
import net.minecraft.class_807;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.ExtShapeBlocks;
import pers.solid.extshape.mixin.BlockStateModelGeneratorAccessor;
import pers.solid.extshape.mixin.BlockTexturePoolAccessor;
import pers.solid.extshape.mixin.TextureMapAccessor;
import pers.solid.extshape.util.BlockCollections;

@Environment(value=EnvType.CLIENT)
public class ExtShapeModelProvider
extends FabricModelProvider {
    protected final Map<class_2248, class_4944> textureMaps = new HashMap<class_2248, class_4944>();
    protected final Map<class_2248, class_4910.class_4912> poolMap = new HashMap<class_2248, class_4910.class_4912>();

    public ExtShapeModelProvider(FabricDataOutput output) {
        super(output);
        this.registerTextureMaps();
    }

    protected void registerTextureMaps() {
        Iterator woods = Iterables.concat(BlockCollections.WOODS, BlockCollections.STRIPPED_WOODS, BlockCollections.HYPHAES, BlockCollections.STRIPPED_HYPHAES).iterator();
        Iterator logs = Iterables.concat(BlockCollections.LOGS, BlockCollections.STRIPPED_LOGS, BlockCollections.STEMS, BlockCollections.STRIPPED_STEMS).iterator();
        while (woods.hasNext()) {
            class_2248 wood = (class_2248)woods.next();
            class_2248 log = (class_2248)logs.next();
            this.textureMaps.put(wood, class_4944.method_25864((class_2248)log));
            this.textureMaps.put(log, class_4944.method_25897((class_2248)log));
        }
        this.textureMaps.put(class_2246.field_41072, class_4944.method_25897((class_2248)class_2246.field_41072));
        this.textureMaps.put(class_2246.field_41073, class_4944.method_25897((class_2248)class_2246.field_41073));
        for (class_2248 block : Arrays.asList(class_2246.field_22109, class_2246.field_46283, class_2246.field_22091, class_2246.field_23151, class_2246.field_10166, class_2246.field_10505, class_2246.field_10437, class_2246.field_37572, class_2246.field_37573, class_2246.field_37574, class_2246.field_46282)) {
            this.textureMaps.put(block, class_4944.method_25894((class_2248)block));
        }
        this.textureMaps.put(class_2246.field_10491, class_4944.method_25864((class_2248)class_2246.field_10477));
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        ObjectSet<class_2248> blocks = ExtShapeBlocks.getBlocks();
        for (class_2248 block : blocks) {
            if (block instanceof ExtShapeBlockInterface) {
                ExtShapeBlockInterface e = (ExtShapeBlockInterface)block;
                e.registerModel(this, blockStateModelGenerator);
                continue;
            }
            if (block == ExtShapeBlocks.PETRIFIED_OAK_PLANKS) {
                blockStateModelGenerator.method_25543(block, class_2246.field_10161);
                blockStateModelGenerator.method_25623(block, class_4941.method_25842((class_2248)class_2246.field_10161));
                continue;
            }
            if (block == ExtShapeBlocks.SMOOTH_STONE_DOUBLE_SLAB) {
                blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_807)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)class_2246.field_10136, (String)"_double"))));
                blockStateModelGenerator.method_25623(block, class_4941.method_25843((class_2248)class_2246.field_10136, (String)"_double"));
                continue;
            }
            throw new IllegalStateException("Not provided model for block: " + String.valueOf(block));
        }
    }

    public class_4944 getTextureMap(class_2248 baseBlock, class_4910 blockStateModelGenerator) {
        if (this.textureMaps.containsKey(baseBlock)) {
            return this.textureMaps.get(baseBlock);
        }
        Map<class_2248, class_4946> texturedModels = BlockStateModelGeneratorAccessor.getTEXTURED_MODELS();
        class_4946 texturedModel = texturedModels.containsKey(baseBlock) ? texturedModels.get(baseBlock) : class_4946.field_23036.get(baseBlock);
        class_4944 textures = texturedModel.method_25921();
        Map<class_4945, class_2960> entries = ((TextureMapAccessor)textures).getEntries();
        if (entries.containsKey(class_4945.field_23018) && !entries.containsKey(class_4945.field_23010)) {
            textures.method_25868(class_4945.field_23010, textures.method_25867(class_4945.field_23018));
        }
        return textures;
    }

    public class_4910.class_4912 getBlockTexturePool(class_2248 baseBlock, class_4910 blockStateModelGenerator) {
        if (((BiMap)class_5953.field_29561.get()).containsKey((Object)baseBlock)) {
            baseBlock = (class_2248)((BiMap)class_5953.field_29561.get()).get((Object)baseBlock);
        }
        return this.poolMap.computeIfAbsent(baseBlock, block -> {
            class_4910 class_49102 = blockStateModelGenerator;
            Objects.requireNonNull(class_49102);
            class_4910.class_4912 blockTexturePool = new class_4910.class_4912(class_49102, this.getTextureMap((class_2248)block, blockStateModelGenerator));
            ((BlockTexturePoolAccessor)blockTexturePool).setBaseModelId(class_4910.method_67806((class_2960)class_4941.method_25842((class_2248)block)));
            class_4944 textures = this.getTextureMap((class_2248)block, blockStateModelGenerator);
            try {
                textures.method_25867(class_4945.field_23010);
            }
            catch (IllegalStateException e) {
                textures.method_25868(class_4945.field_23010, textures.method_25867(class_4945.field_23018));
            }
            return blockTexturePool;
        });
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
    }
}

