/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.mixin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1182;
import net.minecraft.class_3551;
import net.minecraft.class_3579;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Contract;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pers.solid.extshape.ExtShape;
import pers.solid.extshape.builder.BlockShape;

@Mixin(value={class_3551.class})
public abstract class SchemasMixin {
    @Shadow
    @Final
    private static BiFunction<Integer, Schema, Schema> field_15775;

    @Shadow
    @Contract
    private static UnaryOperator<String> method_30070(Map<String, String> replacements) {
        throw new AssertionError();
    }

    @Inject(method={"method_15451(Lcom/mojang/datafixers/DataFixerBuilder;)V"}, at={@At(value="TAIL")})
    private static void postBuild(DataFixerBuilder builder, CallbackInfo ci) {
        Schema schema3939 = builder.addSchema(3939, field_15775);
        UnaryOperator<String> unaryOperator = SchemasMixin.method_30070(Map.of("extshape:tuff_stairs", "minecraft:tuff_stairs", "extshape:tuff_slab", "minecraft:tuff_slab", "extshape:tuff_wall", "minecraft:tuff_wall"));
        builder.addFixer(class_3579.method_15589((Schema)schema3939, (String)"Rename tuff stairs and slab blocks from 'extshape' namespace to vanilla ones", unaryOperator));
        builder.addFixer(class_1182.method_5019((Schema)schema3939, (String)"Rename tuff stairs and slab items from 'extshape' namespace to vanilla ones", unaryOperator));
        Schema schema4173 = builder.addSchema(4173, field_15775);
        ImmutableMap.Builder idMapBuilder = new ImmutableMap.Builder();
        List<BlockShape> constructionShapes = List.of(BlockShape.QUARTER_PIECE, BlockShape.SLAB, BlockShape.STAIRS, BlockShape.VERTICAL_QUARTER_PIECE, BlockShape.VERTICAL_SLAB, BlockShape.VERTICAL_STAIRS);
        List<String> logsAndStems = List.of("oak_log", "spruce_log", "birch_log", "jungle_log", "acacia_log", "cherry_log", "dark_oak_log", "pale_oak_log", "mangrove_log", "warped_stem", "crimson_stem");
        for (String path : Iterables.concat(logsAndStems, (Iterable)Lists.transform(logsAndStems, s -> "stripped_" + s))) {
            String replacedPath;
            Preconditions.checkState((!path.equals(replacedPath = path.replace("_log", "_wood").replace("_stem", "_hyphae")) ? 1 : 0) != 0);
            for (BlockShape shape : constructionShapes) {
                idMapBuilder.put((Object)("extshape:" + path + "_" + shape.method_15434()), (Object)("extshape:" + replacedPath + "_" + shape.method_15434()));
            }
        }
        idMapBuilder.put((Object)"extshape:cut_sandstone_wall", (Object)"extshape:smooth_sandstone_wall");
        idMapBuilder.put((Object)"extshape:cut_red_sandstone_wall", (Object)"extshape:smooth_red_sandstone_wall");
        idMapBuilder.put((Object)"extshape:chiseled_sandstone_wall", (Object)"minecraft:sandstone_wall");
        idMapBuilder.put((Object)"extshape:chiseled_red_sandstone_wall", (Object)"minecraft:sandstone_wall");
        for (BlockShape shape : constructionShapes) {
            boolean vanilla = shape == BlockShape.SLAB || shape == BlockShape.STAIRS || shape == BlockShape.WALL;
            idMapBuilder.put((Object)("extshape:chiseled_sandstone_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "sandstone_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:chiseled_red_sandstone_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "red_sandstone_" + shape.method_15434()));
        }
        idMapBuilder.put((Object)"extshape:chiseled_quartz_button", (Object)"extshape:smooth_quartz_button");
        idMapBuilder.put((Object)"extshape:chiseled_quartz_fence", (Object)"extshape:smooth_quartz_fence");
        idMapBuilder.put((Object)"extshape:chiseled_quartz_fence_gate", (Object)"extshape:smooth_quartz_fence_gate");
        idMapBuilder.put((Object)"extshape:quartz_brick_button", (Object)"extshape:smooth_quartz_button");
        idMapBuilder.put((Object)"extshape:quartz_brick_fence", (Object)"extshape:smooth_quartz_fence");
        idMapBuilder.put((Object)"extshape:quartz_brick_fence_gate", (Object)"extshape:smooth_quartz_fence_gate");
        idMapBuilder.put((Object)"extshape:quartz_button", (Object)"extshape:smooth_quartz_button");
        idMapBuilder.put((Object)"extshape:quartz_fence", (Object)"extshape:smooth_quartz_fence");
        idMapBuilder.put((Object)"extshape:quartz_fence_gate", (Object)"extshape:smooth_quartz_fence_gate");
        idMapBuilder.put((Object)"extshape:quartz_pressure_plate", (Object)"extshape:smooth_quartz_pressure_plate");
        for (BlockShape shape : constructionShapes) {
            boolean vanilla = shape == BlockShape.SLAB || shape == BlockShape.STAIRS;
            idMapBuilder.put((Object)("extshape:chiseled_polished_blackstone_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "polished_blackstone_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:chiseled_nether_brick_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "nether_brick_" + shape.method_15434()));
        }
        for (BlockShape shape : BlockShape.values()) {
            boolean vanilla = shape == BlockShape.SLAB || shape == BlockShape.STAIRS || shape == BlockShape.WALL;
            idMapBuilder.put((Object)("extshape:chiseled_tuff_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "tuff_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:chiseled_tuff_brick_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "tuff_brick_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:chiseled_deepslate_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "cobbled_deepslate_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:chiseled_stone_brick_" + shape.method_15434()), (Object)((vanilla ? "minecraft:" : "extshape:") + "stone_brick_" + shape.method_15434()));
            idMapBuilder.put((Object)("extshape:polished_basalt_" + shape.method_15434()), (Object)("extshape:basalt_" + shape.method_15434()));
        }
        ImmutableMap idMap = idMapBuilder.build();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            idMap.forEach((k, v) -> {
                Validate.validState((!k.contains("__") ? 1 : 0) != 0);
                Validate.validState((!v.contains("__") ? 1 : 0) != 0);
                Validate.validState((boolean)k.contains(":"));
                Validate.validState((boolean)v.contains(":"));
            });
            ExtShape.idMapToVerify = idMap;
        }
        UnaryOperator<String> unaryOperator2 = SchemasMixin.method_30070((Map<String, String>)idMap);
        builder.addFixer(class_3579.method_15589((Schema)schema4173, (String)"Rename some removed blocks of Extended Block Shapes mod", unaryOperator2));
        builder.addFixer(class_1182.method_5019((Schema)schema4173, (String)"Rename some removed items of Extended Block Shapes mod", unaryOperator2));
    }
}

