/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributiveBlockNameManager {
    public static final Pattern END_WITH_BLOCK = Pattern.compile("\\b Block$");
    public static final Pattern END_WITH_BRICKS = Pattern.compile("\\b Bricks$");
    public static final Pattern END_WITH_TILES = Pattern.compile("\\b Tiles$");
    public static final Pattern END_WITH_PLANKS = Pattern.compile("\\b Planks$");
    public static final Pattern BEGIN_WITH_BLOCK_OF = Pattern.compile("^Block [Oo]f \\b");
    public static final Map<Pattern, String> EN_REPLACEMENT = ImmutableMap.builder().put((Object)BEGIN_WITH_BLOCK_OF, (Object)"").put((Object)END_WITH_BLOCK, (Object)"").put((Object)END_WITH_BRICKS, (Object)" Brick").put((Object)END_WITH_TILES, (Object)" Tile").put((Object)END_WITH_PLANKS, (Object)"").build();
    public static final Map<Pattern, String> ZH_REPLACEMENT = ImmutableMap.builder().put((Object)Pattern.compile("\u65b9\u5757$"), (Object)"").put((Object)Pattern.compile("\u65b9\u584a$"), (Object)"").put((Object)Pattern.compile("\u5757$"), (Object)"").put((Object)Pattern.compile("\u584a$"), (Object)"").put((Object)Pattern.compile("\u6728+\u677f$"), (Object)"\u6728").put((Object)Pattern.compile("\u7af9\u677f"), (Object)"\u7af9").put((Object)Pattern.compile("\u6728+\u6750$"), (Object)"\u6728").put((Object)Pattern.compile("\u7af9\u6750"), (Object)"\u7af9").build();
    public static final Map<Pattern, String> LZH_REPLACEMENT = ImmutableMap.builder().put((Object)Pattern.compile("\u584a$"), (Object)"").put((Object)Pattern.compile("\u6750$"), (Object)"").build();
    public static final Map<Pattern, String> ZH_HK_REPLACEMENT = ImmutableMap.of((Object)Pattern.compile("\u78da$"), (Object)"");
    public static final Map<Pattern, String> JA_REPLACEMENT = ImmutableMap.builder().put((Object)Pattern.compile("\u30d6\u30ed\u30c3\u30af$"), (Object)"").put((Object)Pattern.compile("\u306e\u677f\u6750$"), (Object)"").put((Object)Pattern.compile("\u677f\u6750$"), (Object)"").build();
    public static final String ATTRIBUTIVE_KEY = "extshape.special.attributive";

    private AttributiveBlockNameManager() {
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    public static String replace(@NotNull String from, @NotNull Map<? extends Pattern, ? extends String> replacement, @Nullable String defaultValue) {
        for (Map.Entry<? extends Pattern, ? extends String> entry : replacement.entrySet()) {
            Matcher matcher = entry.getKey().matcher(from);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(entry.getValue());
        }
        return defaultValue;
    }

    @NotNull
    public static String replace(@NotNull String from, @NotNull Map<? extends Pattern, ? extends String> replacement) {
        return AttributiveBlockNameManager.replace(from, replacement, from);
    }

    public static class_5250 getAttributiveBlockName(class_5250 text) {
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableTextContent = (class_2588)class_74172;
            class_5250 translatable = class_2561.method_43469((String)ATTRIBUTIVE_KEY, (Object[])ArrayUtils.insert((int)0, (Object[])translatableTextContent.method_11023(), (Object[])new Object[]{translatableTextContent.method_11022()}));
            translatable.method_10862(text.method_10866());
            text.method_10855().forEach(arg_0 -> ((class_5250)translatable).method_10852(arg_0));
            return translatable;
        }
        return text;
    }

    @Contract(value="_, _, !null -> !null")
    public static String convertToAttributive(@NotNull String from, @NotNull class_2477 language, @Nullable String defaultValue) {
        String code = language.method_48307("language.code");
        Object result = AttributiveBlockNameManager.replace(from, EN_REPLACEMENT, null);
        if (result == null && code.startsWith("zho")) {
            result = AttributiveBlockNameManager.replace(from, ZH_REPLACEMENT, null);
        }
        if (result == null && code.startsWith("jpn")) {
            result = AttributiveBlockNameManager.replace(from, JA_REPLACEMENT, null);
        }
        if (result == null && code.endsWith("_HK")) {
            result = AttributiveBlockNameManager.replace(from, ZH_HK_REPLACEMENT, null);
        }
        if (result == null && code.equals("lzh")) {
            result = AttributiveBlockNameManager.replace(from, LZH_REPLACEMENT, null);
        }
        if (result == null) {
            result = defaultValue;
        }
        if (code.startsWith("jpn") && result != null && !((String)result).endsWith("\u6b6a\u3093\u3060")) {
            result = (String)result + "\u306e";
        }
        return result;
    }

    @NotNull
    public static String convertToAttributive(@NotNull String from, @NotNull class_2477 language) {
        return AttributiveBlockNameManager.convertToAttributive(from, language, from);
    }
}

