/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.extshape.ExtShape;
import pers.solid.extshape.builder.BlockShape;

public final class BlockBiMaps {
    private static final Map<BlockShape, BiMap<class_2248, class_2248>> SHAPE_TO_BI_MAP = new HashMap<BlockShape, BiMap<class_2248, class_2248>>();
    public static final LinkedHashSet<class_2248> BASE_BLOCKS = new LinkedHashSet();

    private BlockBiMaps() {
    }

    private static void importFromVanilla() {
        Stream vanillaBlockFamilies = class_5793.method_33467();
        vanillaBlockFamilies.forEach(blockFamily -> {
            class_2248 baseBlock = blockFamily.method_33469();
            Map variants = blockFamily.method_33474();
            for (BlockShape shape : BlockShape.values()) {
                if (shape.vanillaVariant == null) continue;
                class_2248 variant = (class_2248)variants.get(shape.vanillaVariant);
                if (variant == null) {
                    if (shape == BlockShape.FENCE) {
                        variant = (class_2248)variants.get(class_5794.class_5796.field_40592);
                    } else if (shape == BlockShape.FENCE_GATE) {
                        variant = (class_2248)variants.get(class_5794.class_5796.field_40593);
                    }
                }
                if (variant == null) continue;
                BlockBiMaps.setBlockOf(shape, baseBlock, variant);
                BASE_BLOCKS.add(baseBlock);
            }
        });
    }

    @NotNull
    public static BiMap<class_2248, class_2248> of(@NotNull BlockShape shape) {
        return SHAPE_TO_BI_MAP.computeIfAbsent(shape, shape1 -> HashBiMap.create());
    }

    @Nullable
    public static class_2248 getBlockOf(@NotNull BlockShape shape, @NotNull class_2248 baseBlock) {
        return (class_2248)BlockBiMaps.of(shape).get((Object)baseBlock);
    }

    public static void setBlockOf(@NotNull BlockShape shape, @NotNull class_2248 baseBlock, @NotNull class_2248 block) {
        BiMap<class_2248, class_2248> biMap = BlockBiMaps.of(shape);
        if (biMap.containsKey((Object)baseBlock)) {
            ExtShape.LOGGER.warn("Duplicate block mapping found: the shape {} of base block {} is {}, but will also be {}.", new Object[]{shape.method_15434(), baseBlock, biMap.get((Object)baseBlock), block});
        }
        biMap.put((Object)baseBlock, (Object)block);
        BASE_BLOCKS.add(baseBlock);
    }

    static {
        BlockBiMaps.importFromVanilla();
    }
}

