/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.util;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Predicate;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import pers.solid.extshape.ExtShape;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.config.ExtShapeConfig;
import pers.solid.extshape.util.BlockBiMaps;

public record EntryVariantAppender(class_5321<class_1761> itemGroup, Iterable<BlockShape> shapes, Iterable<class_2248> baseBlocks, Predicate<class_2248> blockPredicate) {
    public static final Multimap<class_2248, class_2248> ADJACENT_BASE_BLOCKS = ImmutableSetMultimap.builder().put((Object)class_2246.field_40294, (Object)class_2246.field_40295).put((Object)class_2246.field_23869, (Object)class_2246.field_23880).build();

    public void appendItems(Multimap<class_1792, class_1792> appendingRule) {
        if (!ExtShapeConfig.CURRENT_CONFIG.addToVanillaGroups) {
            return;
        }
        long prevTime = System.currentTimeMillis();
        for (class_2248 baseBlock : this.baseBlocks) {
            if (ADJACENT_BASE_BLOCKS.containsValue((Object)baseBlock)) continue;
            @NotNull class_2248 anchor = baseBlock;
            for (BlockShape shape : this.shapes) {
                class_2248 block = BlockBiMaps.getBlockOf(shape, baseBlock);
                if (block == null) continue;
                if (this.blockPredicate.test(block)) {
                    appendingRule.put((Object)anchor.method_8389(), (Object)block.method_8389());
                } else {
                    anchor = block;
                }
                for (class_2248 adjacentBaseBlock : ADJACENT_BASE_BLOCKS.get((Object)baseBlock)) {
                    class_2248 adjacentBlock = BlockBiMaps.getBlockOf(shape, adjacentBaseBlock);
                    if (adjacentBlock == null) continue;
                    if (this.blockPredicate.test(adjacentBlock)) {
                        appendingRule.put((Object)anchor.method_8389(), (Object)adjacentBlock.method_8389());
                        continue;
                    }
                    anchor = adjacentBlock;
                }
            }
        }
        double afterTime = System.currentTimeMillis();
        ExtShape.LOGGER.info("Time spent on adding items to group {}: {}", (Object)this.itemGroup.method_29177(), (Object)((afterTime - (double)prevTime) / 1000.0));
    }
}

