/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public enum HorizontalCornerDirection implements class_3542
{
    SOUTH_WEST(0, 2, "south_west", new class_2382(-1, 0, 1)),
    NORTH_WEST(1, 3, "north_west", new class_2382(-1, 0, -1)),
    NORTH_EAST(2, 0, "north_east", new class_2382(1, 0, -1)),
    SOUTH_EAST(3, 1, "south_east", new class_2382(1, 0, 1));

    private static final HorizontalCornerDirection[] ALL;
    private static final Map<String, HorizontalCornerDirection> NAME_MAP;
    private static final HorizontalCornerDirection[] VALUES;
    private final String name;
    private final int idOpposite;
    private final int id;
    private final class_2382 vector;

    private HorizontalCornerDirection(int id, int idOpposite, String name, class_2382 vector) {
        this.id = id;
        this.idOpposite = idOpposite;
        this.name = name;
        this.vector = vector;
    }

    @Nullable
    public static HorizontalCornerDirection byName(@Nullable String name) {
        return name == null ? null : NAME_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    public static HorizontalCornerDirection byId(int id) {
        return VALUES[class_3532.method_15382((int)(id % VALUES.length))];
    }

    public static HorizontalCornerDirection fromHorizontal(int value) {
        return VALUES[class_3532.method_15382((int)(value % VALUES.length))];
    }

    public static HorizontalCornerDirection fromRotation(double rotation) {
        return HorizontalCornerDirection.fromHorizontal(class_3532.method_15357((double)(rotation / 90.0)) & 3);
    }

    public static HorizontalCornerDirection random(class_5819 random) {
        return (HorizontalCornerDirection)((Object)class_156.method_27173((Object[])ALL, (class_5819)random));
    }

    public String method_15434() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public HorizontalCornerDirection getOpposite() {
        return HorizontalCornerDirection.byId(this.idOpposite);
    }

    public HorizontalCornerDirection rotateYClockwise() {
        return HorizontalCornerDirection.byId(Math.floorMod(this.id + 1, VALUES.length));
    }

    public HorizontalCornerDirection rotateYCounterclockwise() {
        return HorizontalCornerDirection.byId(Math.floorMod(this.id - 1, VALUES.length));
    }

    public String getName() {
        return this.name;
    }

    public float asRotation() {
        return (float)(((double)(this.id & 3) + 0.5) * 90.0);
    }

    public String toString() {
        return this.name;
    }

    public class_2382 getVector() {
        return this.vector;
    }

    public HorizontalCornerDirection rotate(class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11463 -> this.rotateYClockwise();
            case class_2470.field_11464 -> this.getOpposite();
            case class_2470.field_11465 -> this.rotateYCounterclockwise();
            default -> this;
        };
    }

    public HorizontalCornerDirection mirror(class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11301 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield NORTH_WEST;
                    }
                    case 1: {
                        yield NORTH_EAST;
                    }
                    case 3: {
                        yield SOUTH_WEST;
                    }
                    case 0: 
                }
                yield SOUTH_EAST;
            }
            case class_2415.field_11300 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield SOUTH_EAST;
                    }
                    case 1: {
                        yield SOUTH_WEST;
                    }
                    case 3: {
                        yield NORTH_EAST;
                    }
                    case 0: 
                }
                yield NORTH_WEST;
            }
            default -> this;
        };
    }

    static {
        ALL = HorizontalCornerDirection.values();
        NAME_MAP = Arrays.stream(ALL).collect(Collectors.toMap(HorizontalCornerDirection::getName, direction -> direction));
        VALUES = (HorizontalCornerDirection[])Arrays.stream(ALL).sorted(Comparator.comparingInt(direction -> direction.id)).toArray(HorizontalCornerDirection[]::new);
    }
}

