/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics;

import com.mojang.logging.LogUtils;
import com.wintercogs.appliedpneumatics.Config;
import com.wintercogs.appliedpneumatics.common.init.APBlockEntities;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import com.wintercogs.appliedpneumatics.common.init.APCreativeModeTabs;
import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import com.wintercogs.appliedpneumatics.common.me.AEPlugin;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="appliedpneumatics")
public class AppliedPneumatics {
    public static final String MODID = "appliedpneumatics";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MEGA_CELL_MODID = "megacells";
    public static boolean MEGA_CELL_LOADED = false;
    public static final String EAE_MODID = "extendedae";
    public static boolean EAE_LOADED = false;

    public AppliedPneumatics(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::constructMod);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals(Registries.BLOCK)) {
                AEPlugin.init();
            }
        });
        APMenus.registerMenus(modEventBus);
        APCreativeModeTabs.register(modEventBus);
        APItems.register(modEventBus);
        APBlocks.register(modEventBus);
        APBlockEntities.register(modEventBus);
        APDataComponents.register(modEventBus);
    }

    private void constructMod(FMLConstructModEvent event) {
        if (ModList.get().isLoaded(MEGA_CELL_MODID)) {
            MEGA_CELL_LOADED = true;
        }
        if (ModList.get().isLoaded(EAE_MODID)) {
            EAE_LOADED = true;
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AEPlugin.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("AppliedPneumatics server side setup");
    }

    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

