/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.api.GenericInv;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import org.jetbrains.annotations.Nullable;

public class CombinedGenericInternalInventory
implements GenericInternalInventory {
    protected final GenericInternalInventory[] delegates;
    protected final int[] baseIndex;
    protected final int slotCount;

    public CombinedGenericInternalInventory(GenericInternalInventory ... delegates) {
        this.delegates = delegates == null ? new GenericInternalInventory[]{} : (GenericInternalInventory[])delegates.clone();
        this.baseIndex = new int[this.delegates.length];
        int sum = 0;
        for (int i = 0; i < this.delegates.length; ++i) {
            GenericInternalInventory inv = this.delegates[i];
            int sz = inv == null ? 0 : inv.size();
            this.baseIndex[i] = sum += sz;
        }
        this.slotCount = sum;
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected GenericInternalInventory getInventoryFromIndex(int index) {
        if (index < 0 || index >= this.delegates.length) {
            return EmptyInventory.INSTANCE;
        }
        GenericInternalInventory inv = this.delegates[index];
        return inv != null ? inv : EmptyInventory.INSTANCE;
    }

    protected int getLocalSlot(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    public int size() {
        return this.slotCount;
    }

    @Nullable
    public GenericStack getStack(int slot) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.getStack(local);
    }

    @Nullable
    public AEKey getKey(int slot) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.getKey(local);
    }

    public long getAmount(int slot) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.getAmount(local);
    }

    public long getMaxAmount(AEKey key) {
        if (key == null) {
            return 0L;
        }
        long max = 0L;
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            long v = inv.getMaxAmount(key);
            if (v > max) {
                max = v;
            }
            if (max == Long.MAX_VALUE) break;
        }
        return Math.max(0L, max);
    }

    public long getCapacity(AEKeyType keyType) {
        if (keyType == null) {
            return 0L;
        }
        long sum = 0L;
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            long c = inv.getCapacity(keyType);
            if (c < 0L) {
                c = 0L;
            }
            if ((sum = CombinedGenericInternalInventory.saturatingAdd(sum, c)) == Long.MAX_VALUE) break;
        }
        return sum;
    }

    public boolean canInsert() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null || !inv.canInsert()) continue;
            return true;
        }
        return false;
    }

    public boolean canExtract() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null || !inv.canExtract()) continue;
            return true;
        }
        return false;
    }

    public void setStack(int slot, @Nullable GenericStack newStack) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        inv.setStack(local, newStack);
    }

    public boolean isSupportedType(AEKeyType type) {
        if (type == null) {
            return false;
        }
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null || !inv.isSupportedType(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedIn(int slot, AEKey what) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.isAllowedIn(local, what);
    }

    public long insert(int slot, AEKey what, long amount, Actionable mode) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.insert(local, what, amount, mode);
    }

    public long extract(int slot, AEKey what, long amount, Actionable mode) {
        int idx = this.getIndexForSlot(slot);
        GenericInternalInventory inv = this.getInventoryFromIndex(idx);
        int local = this.getLocalSlot(slot, idx);
        return inv.extract(local, what, amount, mode);
    }

    public void beginBatch() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            inv.beginBatch();
        }
    }

    public void endBatch() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            inv.endBatch();
        }
    }

    public void endBatchSuppressed() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            inv.endBatchSuppressed();
        }
    }

    public void onChange() {
        for (GenericInternalInventory inv : this.delegates) {
            if (inv == null) continue;
            inv.onChange();
        }
    }

    private static long saturatingAdd(long a, long b) {
        long limit = Long.MAX_VALUE - a;
        if (b > limit) {
            return Long.MAX_VALUE;
        }
        long r = a + b;
        return r < 0L ? Long.MAX_VALUE : r;
    }

    private static final class EmptyInventory
    implements GenericInternalInventory {
        static final EmptyInventory INSTANCE = new EmptyInventory();

        private EmptyInventory() {
        }

        public int size() {
            return 0;
        }

        @Nullable
        public GenericStack getStack(int slot) {
            return null;
        }

        @Nullable
        public AEKey getKey(int slot) {
            return null;
        }

        public long getAmount(int slot) {
            return 0L;
        }

        public long getMaxAmount(AEKey key) {
            return 0L;
        }

        public long getCapacity(AEKeyType keyType) {
            return 0L;
        }

        public boolean canInsert() {
            return false;
        }

        public boolean canExtract() {
            return false;
        }

        public void setStack(int slot, @Nullable GenericStack newStack) {
        }

        public boolean isSupportedType(AEKeyType type) {
            return false;
        }

        public boolean isAllowedIn(int slot, AEKey what) {
            return false;
        }

        public long insert(int slot, AEKey what, long amount, Actionable mode) {
            return 0L;
        }

        public long extract(int slot, AEKey what, long amount, Actionable mode) {
            return 0L;
        }

        public void beginBatch() {
        }

        public void endBatch() {
        }

        public void endBatchSuppressed() {
        }

        public void onChange() {
        }
    }
}

