/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.client.me.render;

import appeng.api.client.AEKeyRenderHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import com.wintercogs.appliedpneumatics.common.me.keys.types.AirKeyType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class AirKeyRenderHandler
implements AEKeyRenderHandler<AirKey> {
    private static final ResourceLocation AIR_PARTICLE_TEX = ResourceLocation.fromNamespaceAndPath((String)"pneumaticcraft", (String)"textures/particle/air_particle.png");
    private static final int SLOT_SIZE = 16;
    private static final int EMIT_MIN = 3;
    private static final int EMIT_MAX = 10;
    private static final float SPEED_PX_PER_TICK = 0.3f;
    private static final int BASE_SCREEN_SIZE = 3;
    private static final int SIZE_JITTER_PX = 1;
    private static final int MAX_TICKS_LIFE = 50;
    private static final float START_ALPHA = 0.9f;
    private static final float Z_LAYER = 0.01f;
    private final Emitter sharedEmitter = new Emitter();

    public void drawInGui(Minecraft mc, GuiGraphics gg, int x, int y, AirKey key) {
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        long gameTime = level.getGameTime();
        float partial = (float)mc.getFrameTimeNs() / 1.0E9f * 20.0f;
        float nowT = (float)gameTime + partial;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AIR_PARTICLE_TEX);
        this.sharedEmitter.tickAndSpawn((Level)level, gameTime);
        gg.pose().pushPose();
        gg.pose().translate(0.0f, 0.0f, 0.01f);
        this.sharedEmitter.drawAt(gg, nowT, x, y);
        gg.pose().popPose();
        gg.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AirKey what, float scale, int combinedLight, Level level) {
    }

    public Component getDisplayName(AirKey stack) {
        return AirKeyType.NAME;
    }

    private static final class Emitter {
        private final List<P> particles = new ArrayList<P>();
        private long lastEmitTick = Long.MIN_VALUE;

        Emitter() {
        }

        void tickAndSpawn(Level level, long gameTime) {
            this.particles.removeIf(p -> (float)gameTime - p.birthTick > 50.0f);
            if (this.lastEmitTick == gameTime) {
                return;
            }
            this.lastEmitTick = gameTime;
            int count = Mth.nextInt((RandomSource)level.random, (int)3, (int)10);
            float centerX = 8.0f;
            float centerY = 8.0f;
            for (int i = 0; i < count; ++i) {
                float dirY;
                float angle = level.random.nextFloat() * ((float)Math.PI * 2);
                float dirX = Mth.cos((float)angle);
                float len = Mth.sqrt((float)(dirX * dirX + (dirY = Mth.sin((float)angle)) * dirY));
                if (len != 0.0f) {
                    dirX /= len;
                    dirY /= len;
                }
                int screenSize = Mth.clamp((int)(3 + Mth.nextInt((RandomSource)level.random, (int)-1, (int)1)), (int)1, (int)16);
                float xStart = 8.0f - (float)screenSize / 2.0f;
                float yStart = 8.0f - (float)screenSize / 2.0f;
                float speed = 0.3f * (0.9f + 0.2f * level.random.nextFloat());
                float vx = dirX * speed;
                float vy = dirY * speed;
                float left = 0.0f;
                float top = 0.0f;
                float right = 16 - screenSize;
                float bottom = 16 - screenSize;
                float timeX = Float.POSITIVE_INFINITY;
                float timeY = Float.POSITIVE_INFINITY;
                if (vx > 0.0f) {
                    timeX = (right - xStart) / vx;
                } else if (vx < 0.0f) {
                    timeX = (0.0f - xStart) / vx;
                }
                if (vy > 0.0f) {
                    timeY = (bottom - yStart) / vy;
                } else if (vy < 0.0f) {
                    timeY = (0.0f - yStart) / vy;
                }
                float timeToEdge = Float.POSITIVE_INFINITY;
                if (timeX > 0.0f && Float.isFinite(timeX)) {
                    timeToEdge = Math.min(timeToEdge, timeX);
                }
                if (timeY > 0.0f && Float.isFinite(timeY)) {
                    timeToEdge = Math.min(timeToEdge, timeY);
                }
                if (!Float.isFinite(timeToEdge)) {
                    timeToEdge = 1.0f;
                }
                float life = Math.min(timeToEdge, 50.0f);
                float spawnPhase = level.random.nextFloat() * 0.1f;
                this.particles.add(new P(xStart, yStart, vx, vy, (float)gameTime - spawnPhase, life, screenSize));
            }
        }

        void drawAt(GuiGraphics gg, float nowT, int offsetX, int offsetY) {
            int texW = 32;
            int texH = 32;
            for (int i = this.particles.size() - 1; i >= 0; --i) {
                P p = this.particles.get(i);
                float age = nowT - p.birthTick;
                if (age < 0.0f) {
                    age = 0.0f;
                }
                if (age > p.life) {
                    this.particles.remove(i);
                    continue;
                }
                float posX = p.x0 + p.vx * age;
                float posY = p.y0 + p.vy * age;
                float left = 0.0f;
                float top = 0.0f;
                float right = 16 - p.screenSize;
                float bottom = 16 - p.screenSize;
                posX = Mth.clamp((float)posX, (float)0.0f, (float)right);
                posY = Mth.clamp((float)posY, (float)0.0f, (float)bottom);
                float t = age / p.life;
                float alpha = t < 0.15f ? 0.9f * (t / 0.15f) : 0.9f * (1.0f - (t - 0.15f) / 0.85f);
                alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AIR_PARTICLE_TEX);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                gg.blit(AIR_PARTICLE_TEX, (int)((float)offsetX + posX), (int)((float)offsetY + posY), p.screenSize, p.screenSize, 0.0f, 0.0f, 32, 32, 32, 32);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private record P(float x0, float y0, float vx, float vy, float birthTick, float life, int screenSize) {
    }
}

