/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.eventlistner;

import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.items.IAirStorageCell;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;

@EventBusSubscriber(modid="appliedpneumatics", bus=EventBusSubscriber.Bus.GAME)
public class APDelayedBreaker {
    private static final Set<BlockKey> QUEUE = ConcurrentHashMap.newKeySet();

    public static void breakNextTick(ResourceKey<Level> dim, BlockPos pos) {
        QUEUE.add(new BlockKey(dim, pos.immutable()));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post e) {
        if (QUEUE.isEmpty()) {
            return;
        }
        MinecraftServer server = e.getServer();
        ArrayList<BlockKey> todo = new ArrayList<BlockKey>(QUEUE);
        QUEUE.clear();
        for (BlockKey key : todo) {
            ServerLevel level = server.getLevel(key.dim());
            if (level == null || !level.hasChunkAt(key.pos())) continue;
            APDelayedBreaker.ejectOrBreak((Level)level, key.pos);
        }
    }

    public static void ejectOrBreak(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        boolean didAnything = false;
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extracted;
                IAirStorageCell cell;
                Item item;
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof IAirStorageCell) || IAirStorageCell.remainingAmount((cell = (IAirStorageCell)item).getTotalBytes(), (Long)stack.getOrDefault(APDataComponents.AIR_STORED, (Object)0L)) > 0L || cell.getUpgrades(stack).isInstalled(APItems.SECURITY_CARD) || cell.getUpgrades(stack).isInstalled(APItems.VACUUM_CARD) || (extracted = itemHandler.extractItem(i, 1, false)).isEmpty()) continue;
                ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, extracted.copy());
                drop.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)drop);
                APDelayedBreaker.spawnLeakBurst(server, pos);
                didAnything = true;
            }
        }
        if (!didAnything) {
            level.destroyBlock(pos, true);
            APDelayedBreaker.spawnLeakBurst(server, pos);
        }
    }

    private static void spawnLeakBurst(ServerLevel server, BlockPos pos) {
        double cx = (double)pos.getX() + 0.5;
        double cy = (double)pos.getY() + 1.1;
        double cz = (double)pos.getZ() + 0.5;
        int count = 16;
        double spread = 0.2;
        double speed = 0.25;
        server.sendParticles((ParticleOptions)AirParticleData.DENSE, cx, cy, cz, count, spread, spread, spread, speed);
        server.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public record BlockKey(ResourceKey<Level> dim, BlockPos pos) {
    }
}

