/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.items;

import appeng.api.inventories.InternalInventory;
import com.wintercogs.appliedpneumatics.common.blocks.MEAmadronProcessStation;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.MEAmadronProcessStationBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class AmadronProcessUpgradeItem
extends Item {
    public AmadronProcessUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!(blockEntity instanceof MEAmadronProcessStationBlockEntity)) {
            return InteractionResult.PASS;
        }
        MEAmadronProcessStationBlockEntity be = (MEAmadronProcessStationBlockEntity)blockEntity;
        if (be.getBlockState().getBlock() == APBlocks.ME_AMADRON_PROCESS_STATION.get()) {
            if (be.getJobAmount() > 0 || !be.getInputInv().isEmpty() || !be.getOutputInv().isEmpty()) {
                player.sendSystemMessage((Component)Component.translatable((String)"tooltip.appliedpneumatics.amadron_upgrade.amadron_process_busy"));
                return InteractionResult.PASS;
            }
            InternalInventory patternInv = be.getTerminalPatternInventory();
            ArrayList<ItemStack> patterns = new ArrayList<ItemStack>(patternInv.size());
            for (int i = 0; i < patternInv.size(); ++i) {
                patterns.add(i, patternInv.getStackInSlot(i).copy());
            }
            patternInv.clear();
            be.cancelAllJobs((Component)Component.empty());
            level.setBlockAndUpdate(pos, ((MEAmadronProcessStation)((Object)APBlocks.ME_AMADRON_EXTENDED_PROCESS_STATION.get())).defaultBlockState());
            BlockEntity newBlockEntity = level.getBlockEntity(pos);
            if (newBlockEntity instanceof MEAmadronProcessStationBlockEntity) {
                MEAmadronProcessStationBlockEntity newBE = (MEAmadronProcessStationBlockEntity)newBlockEntity;
                for (int i = 0; i < patterns.size(); ++i) {
                    ItemStack stack = (ItemStack)patterns.get(i);
                    if (stack == null || stack.isEmpty()) continue;
                    newBE.getTerminalPatternInventory().insertItem(i, stack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

