/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.MEAmadronProcessStationBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import com.wintercogs.appliedpneumatics.common.menu.host.AmadronWirelessTerminalMenuHost;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmadronWirelessTerminalItem
extends WirelessTerminalItem
implements IPositionProvider {
    public AmadronWirelessTerminalItem(DoubleSupplier powerCapacity, Item.Properties props) {
        super(powerCapacity, props);
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        IAEItemPowerStorage powerStorage = (IAEItemPowerStorage)APItems.AMADRON_WIRELESS_TERMINAL.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, powerStorage), new ItemLike[]{APItems.AMADRON_WIRELESS_TERMINAL});
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack is = player.getItemInHand(hand);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            ItemMenuHostLocator locator = MenuLocators.forHand((Player)player, (InteractionHand)hand);
            AmadronWirelessTerminalMenuHost menuHost = this.getMenuHost(player, locator, null);
            if (this.getAECurrentPower(locator.locateItem(player)) <= 0.0) {
                player.sendSystemMessage((Component)GuiText.OutOfPower.text());
                return new InteractionResultHolder(InteractionResult.PASS, (Object)is);
            }
            if (!menuHost.getLinkStatus().connected()) {
                player.sendSystemMessage((Component)PlayerMessages.LinkedNetworkNotFound.text());
                return new InteractionResultHolder(InteractionResult.PASS, (Object)is);
            }
            if (MenuOpener.open(this.getMenuType(), (Player)player, (MenuHostLocator)locator)) {
                return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)is);
            }
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)is);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        super.useOn(context);
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MEAmadronProcessStationBlockEntity && player != null && player.isShiftKeyDown()) {
            ItemStack tabletStack = player.getItemInHand(context.getHand());
            GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos);
            if (!level.isClientSide()) {
                AmadronWirelessTerminalItem.toggleLinkToAmadronProcess(tabletStack, globalPos);
            } else {
                player.playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        GlobalPos amadronStationPos = AmadronWirelessTerminalItem.getLinkedAmadronPos(stack);
        if (amadronStationPos == null) {
            lines.add((Component)Component.translatable((String)"tooltip.appliedpneumatics.item.amadron.unlink").withStyle(ChatFormatting.RED));
        } else {
            ResourceKey dim = amadronStationPos.dimension();
            MutableComponent dimName = Component.translatable((String)("dimension." + dim.location().getNamespace() + "." + dim.location().getPath()));
            BlockPos pos = amadronStationPos.pos();
            lines.add((Component)Component.translatable((String)"tooltip.appliedpneumatics.item.amadron.linked", (Object[])new Object[]{dimName, pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN));
        }
    }

    public MenuType<?> getMenuType() {
        return APMenus.AMADRON_WIRELESS_TERMINAL_MENU.get();
    }

    @Nullable
    public AmadronWirelessTerminalMenuHost getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new AmadronWirelessTerminalMenuHost(this, player, locator, (p, sm) -> this.openFromInventory((Player)p, locator, true));
    }

    private static void toggleLinkToAmadronProcess(ItemStack stack, GlobalPos pos) {
        if (stack.has(APDataComponents.AMADRON_PROCESS_POS) && Objects.equals(stack.get(APDataComponents.AMADRON_PROCESS_POS), pos)) {
            stack.remove(APDataComponents.AMADRON_PROCESS_POS);
        } else {
            stack.set(APDataComponents.AMADRON_PROCESS_POS, (Object)pos);
        }
    }

    @Nullable
    public static GlobalPos getLinkedAmadronPos(ItemStack stack) {
        return (GlobalPos)stack.get(APDataComponents.AMADRON_PROCESS_POS);
    }

    @Nullable
    public static MEAmadronProcessStationBlockEntity getLinkWithAmadronProcess(ItemStack stack, Level level) {
        ServerLevel serverLevel;
        if (level.isClientSide) {
            return null;
        }
        GlobalPos pos = (GlobalPos)stack.get(APDataComponents.AMADRON_PROCESS_POS);
        if (pos == null) {
            return null;
        }
        ServerLevel serverLevel2 = serverLevel = level.getServer() != null ? level.getServer().getLevel(pos.dimension()) : null;
        if (serverLevel == null) {
            return null;
        }
        BlockEntity be = serverLevel.getBlockEntity(pos.pos());
        if (be instanceof MEAmadronProcessStationBlockEntity) {
            MEAmadronProcessStationBlockEntity station = (MEAmadronProcessStationBlockEntity)be;
            return station;
        }
        return null;
    }

    @NotNull
    public List<BlockPos> getStoredPositions(UUID player, @NotNull ItemStack itemStack) {
        GlobalPos amadronPos = AmadronWirelessTerminalItem.getLinkedAmadronPos(itemStack);
        if (amadronPos != null) {
            return List.of(amadronPos.pos());
        }
        return List.of();
    }

    public int getRenderColor(int index) {
        return -1878786176;
    }

    public IConfigManager getConfigManager(Supplier<ItemStack> target) {
        return IConfigManager.builder(target).registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE).registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL).registerSetting(Settings.TERMINAL_STYLE, (Enum)TerminalStyle.MEDIUM).build();
    }
}

