/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.items;

import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeableItem;
import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.me.keys.types.AirKeyType;
import net.minecraft.world.item.ItemStack;

public interface IAirStorageCell
extends IUpgradeableItem {
    public int getTotalBytes();

    public double getIdleDrain();

    public static long getStoredAir(ItemStack stack) {
        return (Long)stack.getOrDefault(APDataComponents.AIR_STORED, (Object)0L);
    }

    public static long amountPerByte() {
        return AirKeyType.INSTANCE.getAmountPerByte();
    }

    public static long usedBytes(long storedAir) {
        long apb = IAirStorageCell.amountPerByte();
        return apb <= 0L ? 0L : (storedAir + apb - 1L) / apb;
    }

    public static long freeBytes(int totalBytes, long usedBytes) {
        long f = (long)totalBytes - usedBytes;
        return Math.max(0L, f);
    }

    public static long unusedInCurrentByte(long storedAir) {
        long apb = IAirStorageCell.amountPerByte();
        if (apb <= 0L) {
            return 0L;
        }
        long mod = storedAir % apb;
        return mod == 0L ? 0L : apb - mod;
    }

    public static long remainingAmount(int totalBytes, long storedAir) {
        long apb = IAirStorageCell.amountPerByte();
        if (apb <= 0L) {
            return 0L;
        }
        long fb = IAirStorageCell.freeBytes(totalBytes, IAirStorageCell.usedBytes(storedAir));
        return fb * apb + IAirStorageCell.unusedInCurrentByte(storedAir);
    }

    public static CellState calcState(int totalBytes, long storedAir) {
        if (storedAir <= 0L) {
            return CellState.EMPTY;
        }
        return IAirStorageCell.remainingAmount(totalBytes, storedAir) > 0L ? CellState.TYPES_FULL : CellState.FULL;
    }
}

