/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.items;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.PoweredContainerItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import appeng.util.Platform;
import com.wintercogs.appliedpneumatics.common.air.PortableAirCellItemStackHandler;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.items.IAirStorageCell;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class PortableAirStorageCell
extends AbstractPortableCell
implements IAirStorageCell {
    private final double idleDrain;
    private final int totalBytes;

    public PortableAirStorageCell(MenuType<?> menuType, Item.Properties props, int defaultColor, double idleDrain, int kilobytes) {
        super(menuType, props, defaultColor);
        this.idleDrain = idleDrain;
        this.totalBytes = kilobytes * 1024;
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        PortableAirStorageCell powerStorage1k = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_1K.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage1k), new ItemLike[]{APItems.PORTABLE_AIR_CELL_1K});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_1K});
        PortableAirStorageCell powerStorage4k = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_4K.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage4k), new ItemLike[]{APItems.PORTABLE_AIR_CELL_4K});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_4K});
        PortableAirStorageCell powerStorage16k = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_16K.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage16k), new ItemLike[]{APItems.PORTABLE_AIR_CELL_16K});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_16K});
        PortableAirStorageCell powerStorage64k = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_64K.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage64k), new ItemLike[]{APItems.PORTABLE_AIR_CELL_64K});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_64K});
        PortableAirStorageCell powerStorage256k = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_256K.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage256k), new ItemLike[]{APItems.PORTABLE_AIR_CELL_256K});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_256K});
        PortableAirStorageCell powerStorage1m = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_1M.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage1m), new ItemLike[]{APItems.PORTABLE_AIR_CELL_1M});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_1M});
        PortableAirStorageCell powerStorage4m = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_4M.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage4m), new ItemLike[]{APItems.PORTABLE_AIR_CELL_4M});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_4M});
        PortableAirStorageCell powerStorage16m = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_16M.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage16m), new ItemLike[]{APItems.PORTABLE_AIR_CELL_16M});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_16M});
        PortableAirStorageCell powerStorage64m = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_64M.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage64m), new ItemLike[]{APItems.PORTABLE_AIR_CELL_64M});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_64M});
        PortableAirStorageCell powerStorage256m = (PortableAirStorageCell)APItems.PORTABLE_AIR_CELL_256M.get();
        event.registerItem(Capabilities.EnergyStorage.ITEM, (o, unused) -> new PoweredItemCapabilities(o, (IAEItemPowerStorage)powerStorage256m), new ItemLike[]{APItems.PORTABLE_AIR_CELL_256M});
        event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (o, unused) -> new PortableAirCellItemStackHandler((ItemStack)o), new ItemLike[]{APItems.PORTABLE_AIR_CELL_256M});
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1) {
            PoweredContainerItem poweredContainer;
            Item item2 = stack.getItem();
            if (item2 instanceof PoweredContainerItem && (poweredContainer = (PoweredContainerItem)item2).getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            long stored = IAirStorageCell.getStoredAir(stack);
            CellState state = IAirStorageCell.calcState(((IAirStorageCell)stack.getItem()).getTotalBytes(), stored);
            return state.getStateColor();
        }
        if (tintIndex == 2 && (item = stack.getItem()) instanceof AbstractPortableCell) {
            AbstractPortableCell portableCell = (AbstractPortableCell)item;
            return portableCell.getColor(stack);
        }
        return 0xFFFFFF;
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack));
    }

    public ResourceLocation getRecipeId() {
        return AppEng.makeId((String)("tools/" + Objects.requireNonNull(this.getRegistryName()).getPath()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        if (Platform.isClient()) {
            long stored = IAirStorageCell.getStoredAir(stack);
            long used = IAirStorageCell.usedBytes(stored);
            lines.add(Tooltips.bytesUsed((long)used, (long)this.getTotalBytes()));
            int typesUsed = stored > 0L ? 1 : 0;
            lines.add(Tooltips.typesUsed((long)typesUsed, (long)1L));
            IAirHandler handler = (IAirHandler)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM);
            if (handler != null) {
                lines.add((Component)Component.translatable((String)"appliedpneumatics.portable_air_cell.bar", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", Float.valueOf(handler.getPressure()))}).withStyle(ChatFormatting.DARK_GREEN));
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        long stored;
        boolean showUpg = AEConfig.instance().isTooltipShowCellUpgrades();
        boolean showCnt = AEConfig.instance().isTooltipShowCellContent();
        ArrayList upgrades = new ArrayList();
        if (showUpg) {
            this.getUpgrades(stack).forEach(upgrades::add);
        }
        List<Object> content = Collections.emptyList();
        boolean hasMore = false;
        if (showCnt && (stored = IAirStorageCell.getStoredAir(stack)) > 0L) {
            content = List.of(new GenericStack((AEKey)AirKey.INSTANCE, stored));
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, hasMore, true));
    }

    @Override
    public int getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)5, (x$0, x$1) -> super.onUpgradesChanged(x$0, x$1));
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % 20L != 0L) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        final Player player = (Player)entity;
        if (!this.getUpgrades(stack).isInstalled(APItems.CHARGING_CARD)) {
            return;
        }
        if (this.getAECurrentPower(stack) <= 0.0) {
            return;
        }
        IAirHandler src = (IAirHandler)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM);
        if (src == null) {
            return;
        }
        float DEAD_BAND_BAR = 0.05f;
        int BASE_AIR_PER_TICK = 20000;
        double AE_PER_AIR = 0.02;
        Iterable loops = () -> new Iterator<ItemStack>(this){
            final List<ItemStack> all = new ArrayList<ItemStack>();
            int idx;
            {
                this.all.addAll((Collection<ItemStack>)player.getInventory().items);
                this.all.addAll((Collection<ItemStack>)player.getInventory().armor);
                this.all.addAll((Collection<ItemStack>)player.getInventory().offhand);
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.all.size();
            }

            @Override
            public ItemStack next() {
                return this.all.get(this.idx++);
            }
        };
        for (ItemStack other : loops) {
            int dstAir;
            int dstMaxAir;
            int dstFreeAir;
            float pDst;
            float pSrc;
            float diff;
            IAirHandler dst;
            if (other.isEmpty() || other == stack || other.getItem() instanceof IAirStorageCell || (dst = (IAirHandler)other.getCapability(PNCCapabilities.AIR_HANDLER_ITEM)) == null || (diff = (pSrc = src.getPressure()) - (pDst = dst.getPressure())) <= 0.05f || (dstFreeAir = Math.max(0, (dstMaxAir = (int)(dst.maxPressure() * (float)dst.getVolume())) - (dstAir = dst.getAir()))) <= 0) continue;
            int srcAir = src.getAir();
            if (srcAir <= 0) break;
            int byRate = 20000;
            int byDelta = (int)(diff / 2.0f * (float)dst.getVolume());
            if (byDelta <= 0) continue;
            double aeAvail = this.extractAEPower(stack, Double.MAX_VALUE, Actionable.SIMULATE);
            int byEnergy = (int)Math.floor(aeAvail / 0.02);
            if (byEnergy <= 0) break;
            int moveWant = Math.min(Math.min(byRate, byDelta), Math.min(srcAir, dstFreeAir));
            double aeNeed = (double)(moveWant = Math.min(moveWant, byEnergy)) * 0.02;
            double aeSpent = this.extractAEPower(stack, aeNeed, Actionable.MODULATE);
            int move = (int)Math.floor(aeSpent / 0.02);
            if (move <= 0) continue;
            dst.addAir(move);
            src.addAir(-move);
            if (!(this.getAECurrentPower(stack) <= 0.0) && src.getAir() > 0) continue;
            break;
        }
    }
}

