/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.p2p;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import com.wintercogs.appliedpneumatics.common.me.keys.types.AirKeyType;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class AirP2PTunnelPart
extends P2PTunnelPart<AirP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels(ResourceLocation.tryBuild((String)"appliedpneumatics", (String)"part/p2p/p2p_tunnel_air"));
    private static final BlockCapability<IAirHandlerMachine, Direction> AIR_CAP = PNCCapabilities.AIR_HANDLER_MACHINE;
    @Nullable
    private BlockCapabilityCache<IAirHandlerMachine, Direction> inputAdjacentCache;
    private int reentryDepth = 0;
    private final IAirHandlerMachine inputHandler = new InputHandler();
    private final IAirHandlerMachine outputHandler = new OutputHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public AirP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
    }

    public IAirHandlerMachine getExposedApi() {
        return this.isOutput() ? this.outputHandler : this.inputHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IAirHandlerMachine resolveInputAdjacentOrNull() {
        if (this.reentryDepth++ > 0) {
            --this.reentryDepth;
            return null;
        }
        try {
            BlockEntity be = this.getBlockEntity();
            Direction side = this.getSide();
            if (be == null || side == null) {
                IAirHandlerMachine iAirHandlerMachine = null;
                return iAirHandlerMachine;
            }
            Level level = be.getLevel();
            if (level == null) {
                IAirHandlerMachine iAirHandlerMachine = null;
                return iAirHandlerMachine;
            }
            if (level instanceof ServerLevel) {
                BlockPos relativedPos;
                ServerLevel sl = (ServerLevel)level;
                if (this.inputAdjacentCache == null) {
                    relativedPos = be.getBlockPos().relative(side);
                    Direction face = side.getOpposite();
                    this.inputAdjacentCache = BlockCapabilityCache.create(AIR_CAP, (ServerLevel)sl, (BlockPos)relativedPos, (Object)face);
                }
                relativedPos = (IAirHandlerMachine)this.inputAdjacentCache.getCapability();
                return relativedPos;
            }
            BlockEntity nbe = level.getBlockEntity(be.getBlockPos().relative(side));
            if (nbe == null) {
                IAirHandlerMachine iAirHandlerMachine = null;
                return iAirHandlerMachine;
            }
            IAirHandlerMachine iAirHandlerMachine = PNCCapabilities.getAirHandler((BlockEntity)nbe, (Direction)side.getOpposite()).orElse(null);
            return iAirHandlerMachine;
        }
        finally {
            --this.reentryDepth;
        }
    }

    @Nullable
    private static IAirHandlerMachine resolveOutputAdjacentOrNull(AirP2PTunnelPart out) {
        BlockEntity be = out.getBlockEntity();
        Direction face = out.getSide();
        if (be == null || face == null) {
            return null;
        }
        Level level = be.getLevel();
        if (level == null) {
            return null;
        }
        BlockPos relativedPos = be.getBlockPos().relative(face);
        Direction capSide = face.getOpposite();
        return (IAirHandlerMachine)level.getCapability(AIR_CAP, relativedPos, (Object)capSide);
    }

    private void resetInputAdjacentCacheAndInvalidate() {
        this.inputAdjacentCache = null;
        this.getBlockEntity().invalidateCapabilities();
        if (!this.isOutput()) {
            for (AirP2PTunnelPart out : this.getOutputs()) {
                out.getBlockEntity().invalidateCapabilities();
            }
        } else {
            AirP2PTunnelPart in = (AirP2PTunnelPart)this.getInput();
            if (in != null) {
                in.getBlockEntity().invalidateCapabilities();
            }
        }
    }

    public void onTunnelNetworkChange() {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onTunnelConfigChange() {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        this.resetInputAdjacentCacheAndInvalidate();
    }

    public void onUpdateShape(Direction side) {
        if (side == this.getSide()) {
            this.resetInputAdjacentCacheAndInvalidate();
        }
    }

    private class InputHandler
    implements IAirHandlerMachine {
        private InputHandler() {
        }

        public void addAir(int inputAir) {
            if (inputAir <= 0) {
                return;
            }
            IAirHandlerMachine src = AirP2PTunnelPart.this.resolveInputAdjacentOrNull();
            if (src == null) {
                return;
            }
            float myP = src.getPressure();
            List outs = AirP2PTunnelPart.this.getOutputs();
            if (outs.isEmpty()) {
                return;
            }
            record Target(IAirHandlerMachine handler, float weight) {
            }
            ArrayList<Target> targets = new ArrayList<Target>(outs.size());
            float sumW = 0.0f;
            for (AirP2PTunnelPart out : outs) {
                float outWeight;
                IAirHandlerMachine outHandler = AirP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (outHandler == null || !((outWeight = Math.max(0.0f, myP - outHandler.getPressure())) > 0.0f)) continue;
                targets.add(new Target(outHandler, outWeight));
                sumW += outWeight;
            }
            if (targets.isEmpty() || sumW <= 0.0f) {
                return;
            }
            int delivered = 0;
            int remain = inputAir;
            for (int i = 0; i < targets.size(); ++i) {
                int toSend;
                Target target = (Target)targets.get(i);
                int n = toSend = i == targets.size() - 1 ? remain : Math.max(0, Math.round((float)inputAir * (target.weight / sumW)));
                if (toSend == 0) continue;
                target.handler.addAir(toSend);
                delivered += toSend;
                if ((remain -= toSend) <= 0) break;
            }
            if (delivered > 0) {
                AirP2PTunnelPart.this.deductTransportCost(delivered, AirKeyType.INSTANCE);
            }
        }

        public int getBaseVolume() {
            return 0;
        }

        public void setBaseVolume(int i) {
        }

        public float getPressure() {
            float sum = 0.0f;
            int n = 0;
            for (AirP2PTunnelPart out : AirP2PTunnelPart.this.getOutputs()) {
                IAirHandlerMachine h = AirP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                sum += h.getPressure();
                ++n;
            }
            return n == 0 ? 50.0f : sum / (float)n;
        }

        public int getAir() {
            int total = 0;
            for (AirP2PTunnelPart out : AirP2PTunnelPart.this.getOutputs()) {
                IAirHandlerMachine h = AirP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                total += h.getAir();
            }
            return total;
        }

        public int getVolume() {
            int total = 0;
            for (AirP2PTunnelPart out : AirP2PTunnelPart.this.getOutputs()) {
                IAirHandlerMachine h = AirP2PTunnelPart.resolveOutputAdjacentOrNull(out);
                if (h == null) continue;
                total += h.getVolume();
            }
            return total;
        }

        public float maxPressure() {
            return 0.0f;
        }

        public float getDangerPressure() {
            return 0.0f;
        }

        public float getCriticalPressure() {
            return 0.0f;
        }

        public void setPressure(float p) {
        }

        public void setVolumeUpgrades(int v) {
        }

        public void enableSafetyVenting(FloatPredicate c, Direction d) {
        }

        public void disableSafetyVenting() {
        }

        public void tick(BlockEntity ownerTE) {
        }

        public void setSideLeaking(@Nullable Direction dir) {
        }

        @Nullable
        public Direction getSideLeaking() {
            return null;
        }

        public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
            return List.of();
        }

        public void setConnectableFaces(Collection<Direction> sides) {
        }

        public Tag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag tag) {
        }

        public void addPendingAir(int pendingAir) {
        }

        public void printManometerMessage(Player p, List<Component> curInfo) {
            curInfo.add((Component)Component.translatable((String)"appliedpneumatics.cur.tooltip.p2p_input", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(this.getPressure()))}));
        }
    }

    private static class OutputHandler
    implements IAirHandlerMachine {
        private OutputHandler() {
        }

        public float getPressure() {
            return 50.0f;
        }

        public void addAir(int ml) {
        }

        public int getBaseVolume() {
            return 1;
        }

        public void setBaseVolume(int i) {
        }

        public int getAir() {
            return 1;
        }

        public int getVolume() {
            return 1;
        }

        public float maxPressure() {
            return 0.0f;
        }

        public float getDangerPressure() {
            return Float.MAX_VALUE;
        }

        public float getCriticalPressure() {
            return Float.MAX_VALUE;
        }

        public void setPressure(float p) {
        }

        public void setVolumeUpgrades(int v) {
        }

        public void enableSafetyVenting(FloatPredicate c, Direction d) {
        }

        public void disableSafetyVenting() {
        }

        public void tick(BlockEntity ownerTE) {
        }

        public void setSideLeaking(@Nullable Direction dir) {
        }

        @Nullable
        public Direction getSideLeaking() {
            return null;
        }

        public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
            return List.of();
        }

        public void setConnectableFaces(Collection<Direction> sides) {
        }

        public Tag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag tag) {
        }

        public void addPendingAir(int pendingAir) {
        }

        public void printManometerMessage(Player p, List<Component> curInfo) {
            curInfo.add((Component)Component.translatable((String)"appliedpneumatics.cur.tooltip.p2p_output", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(this.getPressure()))}));
        }
    }
}

