/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.strategies;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import com.wintercogs.appliedpneumatics.util.APMath;
import com.wintercogs.appliedpneumatics.util.AirHandlerHelper;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundActions;
import org.jetbrains.annotations.Nullable;

public class AirContainerItemStrategy
implements ContainerItemStrategy<AirKey, Context> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        IAirHandler airHandler = (IAirHandler)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM);
        if (airHandler != null && airHandler.getAir() > 0) {
            return new GenericStack((AEKey)AirKey.INSTANCE, (long)airHandler.getAir());
        }
        return null;
    }

    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        if (menu.getCarried().getCapability(PNCCapabilities.AIR_HANDLER_ITEM) != null) {
            return new CarriedContext(player, menu);
        }
        return null;
    }

    @Nullable
    public Context findPlayerSlotContext(Player player, int slot) {
        if (player.getInventory().getItem(slot).getCapability(PNCCapabilities.AIR_HANDLER_ITEM) != null) {
            return new PlayerInvContext(player, slot);
        }
        return null;
    }

    public long extract(Context context, AirKey what, long amount, Actionable mode) {
        if (amount <= 0L) {
            return 0L;
        }
        ItemStack stack = context.getStack();
        ItemStack copy = stack.copyWithCount(1);
        IAirHandler airHandler = (IAirHandler)copy.getCapability(PNCCapabilities.AIR_HANDLER_ITEM);
        if (airHandler == null) {
            return 0L;
        }
        long available = Math.max(0, airHandler.getAir());
        long wantExtract = Math.min(available, amount);
        int maxExtract = APMath.ClampToInt(wantExtract);
        if (!mode.isSimulate() && maxExtract > 0) {
            stack.shrink(1);
            airHandler.addAir(-maxExtract);
            context.addOverflow(copy);
        }
        return maxExtract;
    }

    public long insert(Context context, AirKey what, long amount, Actionable mode) {
        if (amount <= 0L) {
            return 0L;
        }
        ItemStack stack = context.getStack();
        ItemStack copy = stack.copyWithCount(1);
        IAirHandler airHandler = (IAirHandler)copy.getCapability(PNCCapabilities.AIR_HANDLER_ITEM);
        if (airHandler == null) {
            return 0L;
        }
        long space = Math.max(0L, AirHandlerHelper.getMaxAirInAirHandler(airHandler) - (long)airHandler.getAir());
        long wantInsert = Math.min(space, amount);
        int maxInsert = APMath.ClampToInt(wantInsert);
        if (!mode.isSimulate() && maxInsert > 0) {
            stack.shrink(1);
            airHandler.addAir(maxInsert);
            context.addOverflow(copy);
        }
        return maxInsert;
    }

    public void playFillSound(Player player, AirKey what) {
        SoundEvent fillSound = Fluids.WATER.getFluidType().getSound((Entity)player, SoundActions.BUCKET_FILL);
        if (fillSound != null) {
            player.playNotifySound(fillSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void playEmptySound(Player player, AirKey what) {
        SoundEvent fillSound = Fluids.WATER.getFluidType().getSound((Entity)player, SoundActions.BUCKET_EMPTY);
        if (fillSound != null) {
            player.playNotifySound(fillSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.getStack());
    }

    private record CarriedContext(Player player, AbstractContainerMenu menu) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.menu.getCarried();
        }

        @Override
        public void setStack(ItemStack stack) {
            this.menu.setCarried(stack);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            if (this.menu.getCarried().isEmpty()) {
                this.menu.setCarried(stack);
            } else {
                this.player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }

    private record PlayerInvContext(Player player, int slot) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.player.getInventory().getItem(this.slot);
        }

        @Override
        public void setStack(ItemStack stack) {
            this.player.getInventory().setItem(this.slot, stack);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            this.player.getInventory().placeItemBackInInventory(stack);
        }
    }

    static interface Context {
        public ItemStack getStack();

        public void setStack(ItemStack var1);

        public void addOverflow(ItemStack var1);
    }
}

