/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.strategies;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.core.localization.GuiText;
import appeng.me.storage.ExternalStorageFacade;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import com.wintercogs.appliedpneumatics.common.me.keys.types.AirKeyType;
import com.wintercogs.appliedpneumatics.util.APMath;
import com.wintercogs.appliedpneumatics.util.AirHandlerHelper;
import java.util.Set;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class AirMachineExternalStorageFacade
extends ExternalStorageFacade {
    private final IAirHandlerMachine airHandler;

    public AirMachineExternalStorageFacade(IAirHandlerMachine airHandler) {
        this.airHandler = airHandler;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return false;
    }

    public int getSlots() {
        return 1;
    }

    @Nullable
    public GenericStack getStackInSlot(int slot) {
        return new GenericStack((AEKey)AirKey.INSTANCE, (long)this.airHandler.getAir());
    }

    public AEKeyType getKeyType() {
        return AirKeyType.INSTANCE;
    }

    protected int insertExternal(AEKey what, int amount, Actionable mode) {
        if (!(what instanceof AirKey)) {
            return 0;
        }
        long space = Math.max(0L, AirHandlerHelper.getMaxAirInPressure(this.airHandler) - (long)this.airHandler.getAir());
        long wantInsert = Math.min(space, (long)amount);
        int maxInsert = APMath.ClampToInt(wantInsert);
        if (!mode.isSimulate() && maxInsert > 0) {
            this.airHandler.addAir(maxInsert);
        }
        return maxInsert;
    }

    protected int extractExternal(AEKey what, int amount, Actionable mode) {
        if (!(what instanceof AirKey)) {
            return 0;
        }
        long available = Math.max(0, this.airHandler.getAir());
        long wantExtract = Math.min(available, (long)amount);
        int maxExtract = APMath.ClampToInt(wantExtract);
        if (!mode.isSimulate() && maxExtract > 0) {
            this.airHandler.addAir(-maxExtract);
        }
        return maxExtract;
    }

    public boolean containsAnyFuzzy(Set<AEKey> keys) {
        return keys.contains((Object)AirKey.INSTANCE);
    }

    public void getAvailableStacks(KeyCounter out) {
        super.getAvailableStacks(out);
        out.add((AEKey)AirKey.INSTANCE, (long)this.airHandler.getAir());
    }

    public Component getDescription() {
        return GuiText.ExternalStorage.text(new Object[]{AirKeyType.INSTANCE.getDescription()});
    }
}

