/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.menu;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.me.storage.NullInventory;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.RestrictedInputSlot;
import com.wintercogs.appliedpneumatics.common.amadron.ImmutableBasketArg;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.MEAmadronProcessStationBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import com.wintercogs.appliedpneumatics.common.items.AmadronWirelessTerminalItem;
import com.wintercogs.appliedpneumatics.common.me.crafting.AmadronPatternDetails;
import com.wintercogs.appliedpneumatics.common.menu.host.AmadronWirelessTerminalMenuHost;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.amadron.ImmutableBasket;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AmadronWirelessTerminalMenu
extends UpgradeableMenu<AmadronWirelessTerminalMenuHost> {
    private static String submitOrderAction = "submit_amadron_order_action";
    private static String savePatternAction = "save_amadron_pattern_action";
    private final List<ResourceLocation> offerIdsSnapshot = AmadronOfferManager.getInstance().getActiveOffers().stream().map(AmadronOffer::getOfferId).toList();

    public AmadronWirelessTerminalMenu(int id, Inventory playerInv, @NotNull AmadronWirelessTerminalMenuHost host) {
        super(APMenus.AMADRON_WIRELESS_TERMINAL_MENU.get(), id, playerInv, (IUpgradeableObject)host);
        this.registerClientAction(submitOrderAction, ImmutableBasketArg.class, immutableBasketArg -> this.onSubmitOrder(immutableBasketArg.basket()));
        this.registerClientAction(savePatternAction, String.class, offerId -> this.onSavePatternAction(ResourceLocation.parse((String)offerId)));
    }

    private void onSubmitOrder(ImmutableBasket basket) {
        MEStorage storage = ((AmadronWirelessTerminalMenuHost)this.getHost()).getInventory();
        if (!((AmadronWirelessTerminalMenuHost)this.getHost()).getLinkStatus().connected() || storage == NullInventory.of()) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.me_disconnected"));
            return;
        }
        MEAmadronProcessStationBlockEntity processBE = AmadronWirelessTerminalItem.getLinkWithAmadronProcess(((AmadronWirelessTerminalMenuHost)this.getHost()).getItemStack(), this.getPlayer().level());
        if (processBE == null || processBE.isRemoved()) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.cant_find_process_station"));
            return;
        }
        if (!processBE.getMainNode().isActive()) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.process_station_not_active"));
            return;
        }
        if (basket.isEmpty()) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.basket_empty"));
            return;
        }
        HashMap<AEKey, Long> totalNeed = new HashMap<AEKey, Long>();
        ArrayList<AbstractMap.SimpleEntry<Object, GenericStack>> jobsToCreate = new ArrayList<AbstractMap.SimpleEntry<Object, GenericStack>>();
        int totalUnits = 0;
        for (Object offerId : basket) {
            int n = basket.getUnits((ResourceLocation)offerId);
            if (n <= 0) continue;
            AmadronOffer amadronOffer = AmadronOfferManager.getInstance().getOffer((ResourceLocation)offerId);
            if (amadronOffer == null || !AmadronOfferManager.getInstance().isActive((ResourceLocation)offerId)) {
                this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.order_invaild", (Object[])new Object[]{offerId.toString()}));
                return;
            }
            GenericStack genericStack = !amadronOffer.getInput().getItem().isEmpty() ? GenericStack.fromItemStack((ItemStack)amadronOffer.getInput().getItem()) : GenericStack.fromFluidStack((FluidStack)amadronOffer.getInput().getFluid());
            long totalForOffer = Math.multiplyExact(genericStack.amount(), (long)n);
            totalNeed.merge(genericStack.what(), totalForOffer, Long::sum);
            for (int i = 0; i < n; ++i) {
                jobsToCreate.add(new AbstractMap.SimpleEntry<Object, GenericStack>(offerId, new GenericStack(genericStack.what(), genericStack.amount())));
            }
            totalUnits += n;
        }
        if (totalNeed.isEmpty()) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.have_not_vaild_order"));
            return;
        }
        if (jobsToCreate.size() + processBE.getJobAmount() > 512) {
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.order_too_much"));
            return;
        }
        IActionSource src = IActionSource.ofPlayer((Player)this.getPlayer());
        for (Map.Entry entry : totalNeed.entrySet()) {
            long l = storage.extract((AEKey)entry.getKey(), ((Long)entry.getValue()).longValue(), Actionable.SIMULATE, src);
            if (l >= (Long)entry.getValue()) continue;
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.missing_materials", (Object[])new Object[]{entry.getValue(), ((AEKey)entry.getKey()).getDisplayName()}));
            return;
        }
        ArrayList<Map.Entry<AEKey, Long>> committed = new ArrayList<Map.Entry<AEKey, Long>>();
        try {
            for (Map.Entry entry : totalNeed.entrySet()) {
                long l = storage.extract((AEKey)entry.getKey(), ((Long)entry.getValue()).longValue(), Actionable.MODULATE, src);
                if (l < (Long)entry.getValue()) {
                    throw new IllegalStateException("\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u539f\u6599\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u5b8c\u6210\u539f\u5b50\u6263\u51cf");
                }
                committed.add(Map.entry((AEKey)entry.getKey(), (Long)entry.getValue()));
            }
            for (AbstractMap.SimpleEntry simpleEntry : jobsToCreate) {
                ResourceLocation resourceLocation = (ResourceLocation)simpleEntry.getKey();
                GenericStack reserved = (GenericStack)simpleEntry.getValue();
                processBE.addJob(resourceLocation, reserved, this.getPlayer().getUUID());
            }
        }
        catch (Exception exception) {
            for (Map.Entry entry : committed) {
                storage.insert((AEKey)entry.getKey(), ((Long)entry.getValue()).longValue(), Actionable.MODULATE, src);
            }
            this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_fail.for_details"));
            return;
        }
        processBE.setChanged();
        this.getPlayer().sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.order_success", (Object[])new Object[]{totalUnits}));
    }

    public void sendSubmitOrderAction(ImmutableBasket basket) {
        this.sendClientAction(submitOrderAction, new ImmutableBasketArg(basket));
    }

    private void onSavePatternAction(ResourceLocation offerId) {
        InternalInventory patternInv = ((AmadronWirelessTerminalMenuHost)this.getHost()).getPatternInv();
        if (!patternInv.getStackInSlot(1).isEmpty()) {
            return;
        }
        ItemStack extracted = patternInv.extractItem(0, 1, false);
        if (!extracted.isEmpty()) {
            ItemStack encodedPattern = new ItemStack((ItemLike)APItems.AMADRON_PATTERN.get(), 1);
            AmadronPatternDetails.encode(encodedPattern, offerId);
            patternInv.insertItem(1, encodedPattern, false);
        }
    }

    public void sendSavePatternAction(ResourceLocation offerId) {
        this.sendClientAction(savePatternAction, offerId.toString());
    }

    public List<ResourceLocation> getOfferIdsSnapshot() {
        return this.offerIdsSnapshot;
    }

    protected void setupInventorySlots() {
        RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, ((AmadronWirelessTerminalMenuHost)this.getHost()).getPatternInv(), 0);
        this.addSlot((Slot)slot, SlotSemantics.BLANK_PATTERN);
        RestrictedInputSlot outputPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, ((AmadronWirelessTerminalMenuHost)this.getHost()).getPatternInv(), 1);
        this.addSlot((Slot)outputPatternSlot, SlotSemantics.ENCODED_PATTERN);
    }

    public boolean stillValid(@NotNull Player player) {
        return ((AmadronWirelessTerminalMenuHost)this.getHost()).isValid();
    }
}

