/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.util.ConfigMenuInventory;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.MEAmadronProcessStationBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEAmadronProcessStationMenu
extends UpgradeableMenu<MEAmadronProcessStationBlockEntity> {
    private static String cancelAllJobsAction = "cancel_all_jobs";
    @GuiSync(value=10)
    public int latestJobs = 0;

    public MEAmadronProcessStationMenu(int id, Inventory playerInv, @NotNull MEAmadronProcessStationBlockEntity host) {
        super(APMenus.ME_AMADRON_PROCESS_STATION_MENU.get(), id, playerInv, (IUpgradeableObject)host);
        this.registerClientAction(cancelAllJobsAction, this::onJobCancel);
    }

    private void onJobCancel() {
        MEAmadronProcessStationBlockEntity be = this.getBlockEntity();
        if (be != null) {
            be.cancelAllJobs((Component)Component.translatable((String)"amadron.appliedpneumatics.process_fail.order_cancel", (Object[])new Object[]{be.getBlockPos().toShortString()}));
        }
    }

    public void senCancelJobAction() {
        this.sendClientAction(cancelAllJobsAction);
    }

    public String getScreenStyle() {
        if (this.getBlockEntity() != null) {
            if (this.getBlockEntity().getTerminalPatternInventory().size() > 9) {
                return "/screens/me_amadron_extended_process_station.json";
            }
            return "/screens/me_amadron_process_station.json";
        }
        return "/screens/me_amadron_process_station.json";
    }

    protected void setupInventorySlots() {
        if (this.getBlockEntity() == null) {
            return;
        }
        for (int i = 0; i < this.getBlockEntity().getTerminalPatternInventory().size(); ++i) {
            AppEngSlot slot = new AppEngSlot(((MEAmadronProcessStationBlockEntity)this.getHost()).getTerminalPatternInventory(), i);
            this.addSlot((Slot)slot, SlotSemantics.ENCODED_PATTERN);
        }
        ConfigMenuInventory inputWrapper = this.getBlockEntity().getInputInv().createMenuWrapper();
        for (int i = 0; i < inputWrapper.size(); ++i) {
            AppEngSlot slot = new AppEngSlot((InternalInventory)inputWrapper, i);
            this.addSlot((Slot)slot, SlotSemantics.MACHINE_INPUT);
        }
        ConfigMenuInventory outputWrapper = this.getBlockEntity().getOutputInv().createMenuWrapper();
        for (int i = 0; i < outputWrapper.size(); ++i) {
            AppEngSlot slot = new AppEngSlot(this, (InternalInventory)outputWrapper, i){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            };
            this.addSlot((Slot)slot, SlotSemantics.MACHINE_OUTPUT);
        }
    }

    public void broadcastChanges() {
        this.latestJobs = this.getBlockEntity() == null ? 0 : this.getBlockEntity().getJobAmount();
        super.broadcastChanges();
    }

    @Nullable
    public MEAmadronProcessStationBlockEntity getBlockEntity() {
        return (MEAmadronProcessStationBlockEntity)this.getHost();
    }

    public boolean stillValid(@NotNull Player player) {
        return !((MEAmadronProcessStationBlockEntity)this.getHost()).isRemoved();
    }
}

