/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.menu;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.METemperatureInterfaceBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class METemperatureInterfaceMenu
extends UpgradeableMenu<METemperatureInterfaceBlockEntity> {
    public static String changeExpectedTemperatureAction = "change_expected_temperature";
    @GuiSync(value=10)
    public double latestTemperature = 0.0;
    @GuiSync(value=11)
    public double latestHeatCap = 0.0;
    @GuiSync(value=12)
    public double latestExpectedTemperature = 0.0;

    public METemperatureInterfaceMenu(int id, Inventory playerInv, @NotNull METemperatureInterfaceBlockEntity host) {
        super(APMenus.ME_TEMPERATURE_INTERFACE_MENU.get(), id, playerInv, (IUpgradeableObject)host);
        this.registerClientAction(changeExpectedTemperatureAction, Double.class, this::onClientChangeExpectedTemperature);
    }

    public void broadcastChanges() {
        METemperatureInterfaceBlockEntity be = (METemperatureInterfaceBlockEntity)this.getHost();
        this.latestTemperature = be.getHeatHandler().getTemperature();
        this.latestHeatCap = be.getHeatHandler().getThermalCapacity();
        this.latestExpectedTemperature = be.getExpectedTemperature();
        super.broadcastChanges();
    }

    public void sendExpectedTemperatureActionToServer(double expectedTemperatureDelta) {
        this.sendClientAction(changeExpectedTemperatureAction, expectedTemperatureDelta);
    }

    private void onClientChangeExpectedTemperature(double delta) {
        METemperatureInterfaceBlockEntity be = (METemperatureInterfaceBlockEntity)this.getHost();
        if (be.isRemoved()) {
            return;
        }
        double now = be.getExpectedTemperature();
        be.setExpectedTemperature(now + delta);
    }

    @Nullable
    public METemperatureInterfaceBlockEntity getBlockEntity() {
        return (METemperatureInterfaceBlockEntity)this.getHost();
    }

    public boolean stillValid(@NotNull Player player) {
        return !((METemperatureInterfaceBlockEntity)this.getHost()).isRemoved();
    }
}

