/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.datagen;

import com.wintercogs.appliedpneumatics.common.init.APBlockStates;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "appliedpneumatics", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(APBlocks.ME_PRESSURE_INTERFACE_BLOCK);
        this.cubeAllPerState(APBlocks.ME_TEMPERATURE_INTERFACE, APBlockStates.TEMP_STATE);
        this.blockWithItem(APBlocks.ME_AMADRON_PROCESS_STATION);
        this.blockWithItem(APBlocks.ME_AMADRON_EXTENDED_PROCESS_STATION);
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    public <E extends Enum<E>> void cubeAllPerState(DeferredBlock<? extends Block> defBlock, EnumProperty<E> prop) {
        Block block = (Block)defBlock.get();
        StateDefinition def = block.getStateDefinition();
        if (!def.getProperties().contains(prop)) {
            throw new IllegalArgumentException("Block " + String.valueOf(block) + " does not contain property " + prop.getName());
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Enum defaultVal = (Enum)((Object)block.defaultBlockState().getValue(prop));
        ModelBuilder defaultModel = null;
        for (Enum value : prop.getPossibleValues()) {
            String state = ((StringRepresentable)value).getSerializedName();
            String name = id.getPath() + "/" + state;
            ModelBuilder model = this.models().cubeAll(name, this.modLoc("block/" + name));
            builder.partialState().with(prop, (Comparable)((Object)value)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            if (value != defaultVal) continue;
            defaultModel = model;
        }
        this.simpleBlockItem(block, (ModelFile)defaultModel);
    }
}

