/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.client.gui;

import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.StyleManager;
import appeng.menu.implementations.UpgradeableMenu;
import com.wintercogs.appliedpneumatics.common.menu.MEPressureInterfaceMenu;
import com.wintercogs.appliedpneumatics.util.GuiRenderHelper;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class MEPressureInterfaceGUI
extends UpgradeableScreen<MEPressureInterfaceMenu> {
    public MEPressureInterfaceGUI(MEPressureInterfaceMenu menu, Inventory inv, Component title) {
        super((UpgradeableMenu)menu, inv, title, StyleManager.loadStyleDoc((String)"/screens/me_pressure_interface.json"));
        this.widgets.addButton("add_button_1", (Component)Component.literal((String)"+1"), () -> {
            float mult = MEPressureInterfaceGUI.hasShiftDown() ? 5.0f : 1.0f;
            menu.sendExpectedPressureActionToServer(1.0f * mult);
        });
        this.widgets.addButton("add_button_01", (Component)Component.literal((String)"+0.1"), () -> {
            float mult = MEPressureInterfaceGUI.hasShiftDown() ? 5.0f : 1.0f;
            menu.sendExpectedPressureActionToServer(0.1f * mult);
        });
        this.widgets.addButton("reduce_button_01", (Component)Component.literal((String)"-0.1"), () -> {
            float mult = MEPressureInterfaceGUI.hasShiftDown() ? 5.0f : 1.0f;
            menu.sendExpectedPressureActionToServer(-0.1f * mult);
        });
        this.widgets.addButton("reduce_button_1", (Component)Component.literal((String)"-1"), () -> {
            float mult = MEPressureInterfaceGUI.hasShiftDown() ? 5.0f : 1.0f;
            menu.sendExpectedPressureActionToServer(-1.0f * mult);
        });
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        String airStr = String.format(Locale.ROOT, "%.1f", Float.valueOf((float)((MEPressureInterfaceMenu)this.menu).latestAir / 1000.0f));
        String maxStr = String.format(Locale.ROOT, "%.0f", Float.valueOf((float)((MEPressureInterfaceMenu)this.menu).latestVolume / 1000.0f));
        String currentPressureStr = String.format(Locale.ROOT, "%.0f", Float.valueOf((float)((MEPressureInterfaceMenu)this.menu).latestAir / (float)((MEPressureInterfaceMenu)this.menu).latestVolume));
        String pressureStr = String.format(Locale.ROOT, "%.1f", ((MEPressureInterfaceMenu)this.menu).latestExpectedPressure);
        GuiRenderHelper.drawCenteredInRegion(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.appliedpneumatics.me_pressure_interface.air_amount", (Object[])new Object[]{airStr, maxStr, currentPressureStr}), 13, 148, 22, 0x404040, false);
        GuiRenderHelper.drawCenteredInRegion(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.appliedpneumatics.me_pressure_interface.max_pressure", (Object[])new Object[]{((MEPressureInterfaceMenu)this.menu).latestDangerPressure}), 13, 148, 38, 0x404040, false);
        GuiRenderHelper.drawCenteredInRegion(guiGraphics, this.font, (Component)Component.literal((String)pressureStr), 13, 168, 82, 0x404040, false);
        GuiRenderHelper.drawCenteredInRegion(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.appliedpneumatics.me_pressure_interface.expected_pressure_text"), 13, 168, 60, 0x404040, false);
        GuiRenderHelper.drawCenteredInRegion(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.appliedpneumatics.me_pressure_interface.expected_pressure_change_mult_text"), 13, 168, 100, 0x404040, false);
    }
}

