/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.blocks.entitis;

import appeng.api.AECapabilities;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.wintercogs.appliedpneumatics.common.init.APBlockEntities;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.common.pressure.AirHandlerMachineFactory;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class MEPressureInterfaceBlockEntity
extends AENetworkedBlockEntity
implements IAirListener,
IUpgradeableObject,
ServerTickingBlockEntity {
    private static final double AE_ENERGY_COST_PER_ML = 1.25;
    private final IUpgradeInventory upgrades = UpgradeInventories.forMachine(APBlocks.ME_PRESSURE_INTERFACE_BLOCK, (int)5, this::onUpgradesChanged);
    private float expectedPressure = 2.0f;
    private static final int BASE_VOLUME_UNIT = 1000;
    private final IAirHandlerMachine airHandler = AirHandlerMachineFactory.getInstance().createTierTwoAirHandler(1000);
    private int lastAir = 0;
    private final AppEngInternalInventory inventory = new AppEngInternalInventory(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MEPressureInterfaceBlockEntity.this.setChanged();
        }
    };

    public MEPressureInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(APBlockEntities.ME_PRESSURE_INTERFACE_BLOCK_ENTITY.get(), pos, state);
        this.getMainNode().setIdlePowerUsage(8.0).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setExposedOnSides(EnumSet.allOf(Direction.class));
        this.airHandler.setConnectableFaces(EnumSet.allOf(Direction.class));
        this.inventory.setFilter(new IAEItemFilter(this){

            public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
                return !stack.isEmpty() && stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM) != null;
            }
        });
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, APBlockEntities.ME_PRESSURE_INTERFACE_BLOCK_ENTITY.get(), (be, unused) -> be);
        event.registerBlockEntity(PNCCapabilities.AIR_HANDLER_MACHINE, APBlockEntities.ME_PRESSURE_INTERFACE_BLOCK_ENTITY.get(), (be, direction) -> be.airHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, APBlockEntities.ME_PRESSURE_INTERFACE_BLOCK_ENTITY.get(), (be, direction) -> be.inventory.toItemHandler());
    }

    public AppEngInternalInventory getInventory() {
        return this.inventory;
    }

    public IAirHandlerMachine getAirHandler() {
        return this.airHandler;
    }

    public int getVolume() {
        return this.airHandler.getVolume();
    }

    public int getMaxVolume() {
        return (int)((double)this.getVolume() * (double)this.airHandler.getDangerPressure());
    }

    public float getExpectedPressure() {
        return this.expectedPressure;
    }

    public void setExpectedPressure(float expectedPressure) {
        expectedPressure = Math.min(20.0f, expectedPressure);
        float bottomPressure = this.isUpgradedWith((ItemLike)APItems.VACUUM_CARD) ? -1.0f : 0.0f;
        this.expectedPressure = expectedPressure = Math.max(bottomPressure, expectedPressure);
        this.setChanged();
    }

    @Nullable
    public MEStorage getNetworkInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return null;
        }
        IStorageService ss = grid.getStorageService();
        return ss != null ? ss.getInventory() : null;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.airHandler.deserializeNBT(tag.getCompound("air_handler"));
        this.inventory.readFromNBT(tag, "inv", registries);
        this.expectedPressure = tag.getFloat("expected_pressure");
        this.upgrades.readFromNBT(tag, "interface_upgrades", registries);
    }

    public void onLoad() {
        super.onLoad();
        this.onUpgradesChanged();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("air_handler", this.airHandler.serializeNBT());
        this.inventory.writeToNBT(tag, "inv", registries);
        tag.putFloat("expected_pressure", this.expectedPressure);
        this.upgrades.writeToNBT(tag, "interface_upgrades", registries);
    }

    private void onUpgradesChanged() {
        this.setExpectedPressure(this.expectedPressure);
        int upgradeVolumeCount = 2 * this.getInstalledUpgrades((ItemLike)APItems.VOLUME_CARD);
        this.airHandler.setBaseVolume(1000 * (1 << upgradeVolumeCount));
        MEPressureInterfaceBlockEntity.interactWithMESystem(this.level, this.worldPosition, this.getBlockState(), this);
        if (this.getUpgrades().isInstalled(APItems.SECURITY_CARD)) {
            this.airHandler.enableSafetyVenting(p -> p >= 20.0f, Direction.UP);
        } else {
            this.airHandler.disableSafetyVenting();
        }
        this.setChanged();
    }

    public void serverTick() {
        IAirHandler itemAirHandler;
        ItemStack containerItem;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.getMainNode().isActive()) {
            MEPressureInterfaceBlockEntity.interactWithMESystem(this.level, this.worldPosition, this.getBlockState(), this);
        }
        if (!(containerItem = this.inventory.getStackInSlot(0)).isEmpty() && (itemAirHandler = (IAirHandler)containerItem.getCapability(PNCCapabilities.AIR_HANDLER_ITEM)) != null) {
            float bePressure = this.airHandler.getPressure();
            float itemPressure = itemAirHandler.getPressure();
            float itemVolume = itemAirHandler.getVolume();
            float delta = Math.abs(bePressure - itemPressure) / 2.0f;
            int airInItem = itemAirHandler.getAir();
            int airPerTick = 1000;
            if (PneumaticCraftUtils.epsilonEquals((float)bePressure, (float)0.0f) && delta < 0.1f) {
                if (airInItem != 0) {
                    itemAirHandler.addAir(-airInItem);
                }
            } else if (itemPressure > bePressure + 0.01f && itemPressure > 0.0f) {
                int move = Math.min(Math.min(airPerTick, airInItem), (int)(delta * (float)this.getVolume()));
                if (move > 0) {
                    itemAirHandler.addAir(-move);
                    this.airHandler.addAir(move);
                }
            } else if (itemPressure < bePressure - 0.01f && itemPressure < itemAirHandler.maxPressure()) {
                int maxAirInItem = (int)(itemAirHandler.maxPressure() * itemVolume);
                float boost = bePressure < 15.0f ? 1.0f : 1.0f + (bePressure - 15.0f) / 5.0f;
                int move = Math.min(Math.min((int)((float)airPerTick * boost), this.airHandler.getAir()), maxAirInItem - airInItem);
                if ((move = Math.min(move, (int)(delta * itemVolume))) > 0) {
                    itemAirHandler.addAir(move);
                    this.airHandler.addAir(-move);
                }
            }
        }
        this.airHandler.tick((BlockEntity)this);
        if (this.lastAir != this.airHandler.getAir()) {
            this.lastAir = this.airHandler.getAir();
            this.setChanged();
        }
    }

    private static void interactWithMESystem(Level level, BlockPos pos, BlockState state, MEPressureInterfaceBlockEntity be) {
        MEStorage storage = be.getNetworkInventory();
        IGrid grid = be.getMainNode().getGrid();
        if (storage == null || grid == null) {
            return;
        }
        IEnergyService energy = grid.getEnergyService();
        if (energy == null) {
            return;
        }
        float targetPressure = be.expectedPressure;
        float currentPressure = be.airHandler.getPressure();
        float diffP = targetPressure - currentPressure;
        int wantedAir = (int)(diffP * (float)be.getVolume());
        int demand = Math.abs(wantedAir);
        if (demand <= 0) {
            return;
        }
        double costPerAir = 1.25 * ((float)wantedAir >= 0.0f ? 0.1 : 1.0);
        IActionSource src = IActionSource.ofMachine((IActionHost)be);
        int byStorage = wantedAir > 0 ? (int)storage.extract((AEKey)AirKey.INSTANCE, (long)demand, Actionable.SIMULATE, src) : (int)storage.insert((AEKey)AirKey.INSTANCE, (long)demand, Actionable.SIMULATE, src);
        if (byStorage <= 0) {
            return;
        }
        double aeAvail = energy.getStoredPower();
        int byEnergy = (int)Math.floor(aeAvail / costPerAir);
        if (byEnergy <= 0) {
            return;
        }
        int movePlan = Math.min(demand, Math.min(byStorage, byEnergy));
        double aeNeed = (double)movePlan * costPerAir;
        double aeSpent = energy.extractAEPower(aeNeed, Actionable.MODULATE, PowerMultiplier.CONFIG);
        int moveByEnergy = (int)Math.floor(aeSpent / costPerAir);
        if (moveByEnergy <= 0) {
            return;
        }
        if (wantedAir > 0) {
            int extracted = (int)storage.extract((AEKey)AirKey.INSTANCE, (long)moveByEnergy, Actionable.MODULATE, src);
            if (extracted > 0) {
                be.airHandler.addAir(extracted);
            }
        } else {
            int inserted = (int)storage.insert((AEKey)AirKey.INSTANCE, (long)moveByEnergy, Actionable.MODULATE, src);
            if (inserted > 0) {
                be.airHandler.addAir(-inserted);
            }
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        ItemStack dropStack = this.inventory.getStackInSlot(0);
        if (!dropStack.isEmpty()) {
            drops.add(dropStack);
        }
        for (int i = 0; i < this.upgrades.size(); ++i) {
            ItemStack slotContent = this.upgrades.getStackInSlot(i);
            if (slotContent.isEmpty()) continue;
            drops.add(slotContent.copy());
        }
    }
}

