/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.me.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPart;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import com.wintercogs.appliedpneumatics.common.eventlistner.APDelayedBreaker;
import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.items.IAirStorageCell;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import com.wintercogs.appliedpneumatics.common.me.keys.types.AirKeyType;
import java.lang.reflect.Field;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class AirCellInventory
implements StorageCell {
    private long storedAir;
    private final ItemStack itemStack;
    private final IAirStorageCell cellType;
    @Nullable
    private final ISaveProvider host;
    @Nullable
    private final APDelayedBreaker.BlockKey hostPos;
    private final boolean hasSecurityUpgrade;
    private final boolean hasVacuumUpgrade;
    private boolean isPersisted = true;

    public AirCellInventory(ItemStack stack, IAirStorageCell cell, @Nullable ISaveProvider host) {
        this.itemStack = stack;
        this.cellType = cell;
        this.host = host;
        BlockEntity be = AirCellInventory.tryGetHostBE(host);
        this.hostPos = be != null && be.getLevel() != null ? new APDelayedBreaker.BlockKey((ResourceKey<Level>)be.getLevel().dimension(), be.getBlockPos()) : null;
        this.storedAir = this.getAirFromStack();
        this.hasSecurityUpgrade = this.cellType.getUpgrades(this.itemStack).isInstalled(APItems.SECURITY_CARD);
        this.hasVacuumUpgrade = this.cellType.getUpgrades(this.itemStack).isInstalled(APItems.VACUUM_CARD);
    }

    public CellState getStatus() {
        if (this.storedAir <= 0L) {
            return CellState.EMPTY;
        }
        return this.getRemainingAmount() > 0L ? CellState.NOT_EMPTY : CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public void persist() {
        if (!this.isPersisted) {
            if (this.storedAir <= 0L) {
                this.itemStack.remove(APDataComponents.AIR_STORED);
            } else {
                this.itemStack.set(APDataComponents.AIR_STORED, (Object)this.storedAir);
            }
            this.isPersisted = true;
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return !this.hasVacuumUpgrade && what == AirKey.INSTANCE;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L || what != AirKey.INSTANCE) {
            return 0L;
        }
        long remaining = this.getRemainingAmount();
        if (remaining <= 0L) {
            if (this.hasVacuumUpgrade) {
                return amount;
            }
            if (!this.hasSecurityUpgrade && mode == Actionable.MODULATE) {
                this.markChanged();
                if (this.hostPos != null) {
                    APDelayedBreaker.breakNextTick(this.hostPos.dim(), this.hostPos.pos());
                }
            }
            return 0L;
        }
        long toStore = Math.min(amount, remaining);
        if (mode == Actionable.MODULATE) {
            this.storedAir += toStore;
            this.markChanged();
            long overflow = amount - toStore;
            if (overflow > 0L) {
                if (this.hasVacuumUpgrade) {
                    return amount;
                }
                if (!this.hasSecurityUpgrade && this.hostPos != null) {
                    APDelayedBreaker.breakNextTick(this.hostPos.dim(), this.hostPos.pos());
                }
            }
        }
        return toStore;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L || what != AirKey.INSTANCE) {
            return 0L;
        }
        if (this.storedAir <= 0L) {
            return 0L;
        }
        long taken = Math.min(amount, this.storedAir);
        if (mode == Actionable.MODULATE) {
            this.storedAir -= taken;
            this.markChanged();
        }
        return taken;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedAir > 0L) {
            out.add((AEKey)AirKey.INSTANCE, this.storedAir);
        }
    }

    public Component getDescription() {
        return this.itemStack.getHoverName();
    }

    private void markChanged() {
        if (Platform.isClient()) {
            return;
        }
        this.isPersisted = false;
        if (this.host != null) {
            this.host.saveChanges();
        } else {
            this.persist();
        }
    }

    public long getTotalBytes() {
        return this.cellType.getTotalBytes();
    }

    public long getAmountPerByte() {
        return AirKeyType.INSTANCE.getAmountPerByte();
    }

    public long getUsedBytes() {
        long apb = this.getAmountPerByte();
        return (this.storedAir + apb - 1L) / apb;
    }

    public long getFreeBytes() {
        long free = this.getTotalBytes() - this.getUsedBytes();
        return Math.max(0L, free);
    }

    public long getUnusedInCurrentByte() {
        long apb = this.getAmountPerByte();
        long mod = this.storedAir % apb;
        return mod == 0L ? 0L : apb - mod;
    }

    public long getRemainingAmount() {
        long apb = this.getAmountPerByte();
        return this.getFreeBytes() * apb + this.getUnusedInCurrentByte();
    }

    public long getAirFromStack() {
        return (Long)this.itemStack.getOrDefault(APDataComponents.AIR_STORED, (Object)0L);
    }

    private void writeAirToStack(long value) {
        this.itemStack.set(APDataComponents.AIR_STORED, (Object)Math.max(0L, value));
    }

    @Nullable
    public static BlockEntity tryGetHostBE(ISaveProvider host) {
        IActionHost actionHost;
        IGridNode node;
        if (host == null) {
            return null;
        }
        if (host instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)host;
            return be;
        }
        if (host instanceof IPart) {
            IPart part = (IPart)host;
            if (part instanceof AEBasePart) {
                AEBasePart aeBasePart = (AEBasePart)part;
                return aeBasePart.getBlockEntity();
            }
            IGridNode node2 = part.getGridNode();
            if (node2 != null) {
                Object object = node2.getOwner();
                if (object instanceof BlockEntity) {
                    BlockEntity be = (BlockEntity)object;
                    return be;
                }
                if (node2 instanceof AEBasePart) {
                    AEBasePart aeBasePart = (AEBasePart)node2;
                    return aeBasePart.getBlockEntity();
                }
            }
        }
        if (host instanceof IActionHost && (node = (actionHost = (IActionHost)host).getActionableNode()) != null) {
            Object aeBasePart = node.getOwner();
            if (aeBasePart instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)aeBasePart;
                return be;
            }
            if (node instanceof AEBasePart) {
                AEBasePart aeBasePart2 = (AEBasePart)node;
                return aeBasePart2.getBlockEntity();
            }
        }
        Class hostClass = host.getClass();
        try {
            for (Field field : hostClass.getDeclaredFields()) {
                IActionHost actionHost2;
                IGridNode node3;
                field.setAccessible(true);
                Object value = field.get(host);
                if (value == null) continue;
                if (value instanceof BlockEntity) {
                    BlockEntity be = (BlockEntity)value;
                    return be;
                }
                if (value instanceof IPart) {
                    IPart part = (IPart)value;
                    if (part instanceof AEBasePart) {
                        AEBasePart aeBasePart = (AEBasePart)part;
                        return aeBasePart.getBlockEntity();
                    }
                    IGridNode node4 = part.getGridNode();
                    if (node4 != null) {
                        Object object = node4.getOwner();
                        if (object instanceof BlockEntity) {
                            BlockEntity be = (BlockEntity)object;
                            return be;
                        }
                        if (node4 instanceof AEBasePart) {
                            AEBasePart aeBasePart = (AEBasePart)node4;
                            return aeBasePart.getBlockEntity();
                        }
                    }
                }
                if (!(value instanceof IActionHost) || (node3 = (actionHost2 = (IActionHost)value).getActionableNode()) == null) continue;
                Object object = node3.getOwner();
                if (object instanceof BlockEntity) {
                    BlockEntity be = (BlockEntity)object;
                    return be;
                }
                if (!(node3 instanceof AEBasePart)) continue;
                AEBasePart aeBasePart = (AEBasePart)node3;
                return aeBasePart.getBlockEntity();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

