/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.StyleManager;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.menu.implementations.UpgradeableMenu;
import com.wintercogs.appliedpneumatics.AppliedPneumatics;
import com.wintercogs.appliedpneumatics.client.gui.widgets.AE2TinyButton;
import com.wintercogs.appliedpneumatics.client.gui.widgets.AmadronOfferPanel;
import com.wintercogs.appliedpneumatics.common.menu.AmadronWirelessTerminalMenu;
import com.wintercogs.appliedpneumatics.util.AmadronOfferHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.common.amadron.MutableBasket;
import me.desht.pneumaticcraft.common.amadron.ShoppingBasket;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class AmadronWirelessTerminalGUI
extends UpgradeableScreen<AmadronWirelessTerminalMenu> {
    private static final ResourceLocation BG_TEX = AppliedPneumatics.makeId("textures/gui/amadron_wireless_terminal.png");
    private static final UVBounds HEADER = new UVBounds(0, 0, 195, 18);
    private static final UVBounds FIRST_ROW = new UVBounds(0, 18, 195, 23);
    private static final UVBounds MID_ROW = new UVBounds(0, 41, 195, 23);
    private static final UVBounds LAST_ROW = new UVBounds(0, 87, 195, 31);
    private static final UVBounds ENDER = new UVBounds(0, 118, 176, 152);
    private static final int PANELS_PER_ROW = 2;
    private static final int PANEL_W = 79;
    private static final int PANEL_H = 22;
    private static final int GAP_X = 1;
    private static final int GAP_Y = 1;
    private static final int GRID_OFFSET_X = 9;
    private static final int GRID_OFFSET_Y = 19;
    private static final int HIDE_X = -10000;
    private static final int HIDE_Y = -10000;
    private final Scrollbar scrollbar;
    private final AETextField searchField;
    private final AE2TinyButton submitButton;
    private final IconButton savePatternButton;
    private int totalRows = 0;
    private int lastTopRow = -1;
    private int visibleRows = 2;
    private final List<AmadronOfferPanel> pagePanels = new ArrayList<AmadronOfferPanel>();
    private String searchQuery = "";
    private final List<Integer> filteredIndex = new ArrayList<Integer>();
    @Nullable
    private AmadronOfferPanel lastClickedPanel = null;

    public AmadronWirelessTerminalGUI(AmadronWirelessTerminalMenu menu, Inventory playerInventory, Component title) {
        super((UpgradeableMenu)menu, playerInventory, title, StyleManager.loadStyleDoc((String)"/screens/amadron_wireless_terminal.json"));
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.BIG);
        this.submitButton = new AE2TinyButton((Component)Component.translatable((String)"menu.appliedpneumatics.button.submit"), b -> this.onSubmit());
        this.widgets.add("submit_button", (AbstractWidget)this.submitButton);
        this.savePatternButton = new IconButton(this, btn -> {
            if (this.lastClickedPanel != null) {
                menu.sendSavePatternAction(this.lastClickedPanel.getOfferId());
            }
        }){

            protected Icon getIcon() {
                return Icon.ARROW_LEFT;
            }
        };
        this.widgets.add("save_pattern_button", (AbstractWidget)this.savePatternButton);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(s -> {
            this.searchQuery = s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
            this.rebuildFilter();
            this.lastTopRow = -1;
            this.relayoutVisiblePanels();
        });
        TerminalStyle terminalStyle = this.config.getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
    }

    protected void init() {
        this.visibleRows = this.computeVisibleRows();
        this.imageWidth = Math.max(AmadronWirelessTerminalGUI.HEADER.width, AmadronWirelessTerminalGUI.ENDER.width);
        this.imageHeight = 19 + AmadronWirelessTerminalGUI.backgroundRowsHeight(this.visibleRows) + AmadronWirelessTerminalGUI.ENDER.height;
        super.init();
        this.rebuildFilter();
        this.ensurePanelPoolUpToDate();
        this.reattachPanelPool();
        this.updateScrollbarFrameAndRange();
        this.lastTopRow = -1;
        this.relayoutVisiblePanels();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        this.config.setTerminalStyle(next);
        btn.set((Enum)next);
        this.init();
    }

    private int computeVisibleRows() {
        int usable = Math.max(0, this.height - 36 - AmadronWirelessTerminalGUI.HEADER.height - AmadronWirelessTerminalGUI.ENDER.height);
        TerminalStyle style = this.config.getTerminalStyle();
        int maxRows = usable / 22;
        return Math.max(2, style.getRows(maxRows));
    }

    private static int backgroundRowsHeight(int rows) {
        if (rows <= 1) {
            return AmadronWirelessTerminalGUI.FIRST_ROW.height;
        }
        if (rows == 2) {
            return AmadronWirelessTerminalGUI.FIRST_ROW.height + AmadronWirelessTerminalGUI.LAST_ROW.height;
        }
        return AmadronWirelessTerminalGUI.FIRST_ROW.height + (rows - 2) * AmadronWirelessTerminalGUI.MID_ROW.height + AmadronWirelessTerminalGUI.LAST_ROW.height;
    }

    private void updateScrollbarFrameAndRange() {
        int gridPixelH = this.visibleRows * 23 - 1;
        gridPixelH = Math.max(1, gridPixelH);
        this.scrollbar.setHeight(gridPixelH);
        this.updateScrollbarRangeBySize(this.filteredIndex.size());
    }

    public void containerTick() {
        super.containerTick();
        int topRow = this.scrollbar.getCurrentScroll();
        if (topRow != this.lastTopRow) {
            this.lastTopRow = topRow;
            this.relayoutVisiblePanels();
        }
    }

    public boolean mouseClicked(double x, double y, int btn) {
        for (AmadronOfferPanel panel : this.pagePanels) {
            if (!panel.isActive() || !panel.isMouseOver(x, y)) continue;
            panel.onClicked(x, y, btn, AmadronWirelessTerminalGUI.hasShiftDown());
            this.updateLastClickedPanel(panel);
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }

    private void updateLastClickedPanel(AmadronOfferPanel clicked) {
        if (clicked.getOfferType().isPlayer() || !clicked.getOfferType().isStatic()) {
            return;
        }
        if (this.lastClickedPanel != null) {
            this.removeWidget((GuiEventListener)this.lastClickedPanel);
        }
        this.lastClickedPanel = AmadronOfferPanel.fromOfferId(this.getGuiRight() - 183, this.getGuiBottom() - 125, clicked.getOfferId(), b -> {});
        this.addRenderableWidget((GuiEventListener)this.lastClickedPanel);
    }

    private void ensurePanelPoolUpToDate() {
        int i;
        List<ResourceLocation> ids = ((AmadronWirelessTerminalMenu)this.menu).getOfferIdsSnapshot();
        for (i = this.pagePanels.size(); i < ids.size(); ++i) {
            ResourceLocation id = ids.get(i);
            AmadronOfferPanel p = AmadronOfferPanel.fromOfferId(-10000, -10000, id, b -> {});
            p.active = false;
            p.visible = false;
            this.addRenderableWidget((GuiEventListener)p);
            this.pagePanels.add(p);
        }
        for (i = ids.size(); i < this.pagePanels.size(); ++i) {
            AmadronOfferPanel p = this.pagePanels.get(i);
            p.active = false;
            p.visible = false;
            p.setX(-10000);
            p.setY(-10000);
        }
    }

    private void reattachPanelPool() {
        for (AmadronOfferPanel p : this.pagePanels) {
            if (this.renderables.contains((Object)p)) continue;
            this.addRenderableWidget((GuiEventListener)p);
        }
    }

    private void relayoutVisiblePanels() {
        this.updateScrollbarRangeBySize(this.filteredIndex.size());
        this.ensurePanelPoolUpToDate();
        for (AmadronOfferPanel p : this.pagePanels) {
            p.active = false;
            p.visible = false;
            p.setX(-10000);
            p.setY(-10000);
        }
        if (this.filteredIndex.isEmpty()) {
            return;
        }
        int maxTop = Math.max(0, this.totalRows - this.visibleRows);
        int startRow = Math.min(this.scrollbar.getCurrentScroll(), maxTop);
        int startIndex = startRow * 2;
        int capacity = this.visibleRows * 2;
        int endExclusive = Math.min(startIndex + capacity, this.filteredIndex.size());
        for (int index = startIndex; index < endExclusive; ++index) {
            int local = index - startIndex;
            int row = local / 2;
            int col = local % 2;
            int x = this.leftPos + 9 + col * 80;
            int y = this.topPos + 19 + row * 23;
            int idxInSnapshot = this.filteredIndex.get(index);
            AmadronOfferPanel panel = this.pagePanels.get(idxInSnapshot);
            panel.setX(x);
            panel.setY(y);
            panel.active = true;
            panel.visible = true;
        }
        this.updateScrollbarFrameAndRange();
    }

    private void rebuildFilter() {
        this.filteredIndex.clear();
        List<ResourceLocation> ids = ((AmadronWirelessTerminalMenu)this.menu).getOfferIdsSnapshot();
        if (ids.isEmpty()) {
            this.updateScrollbarRangeBySize(0);
            return;
        }
        if (this.searchQuery.isEmpty()) {
            for (int i = 0; i < ids.size(); ++i) {
                this.filteredIndex.add(i);
            }
        } else {
            for (int i = 0; i < ids.size(); ++i) {
                if (!this.offerMatches(ids.get(i), this.searchQuery)) continue;
                this.filteredIndex.add(i);
            }
        }
        this.updateScrollbarRangeBySize(this.filteredIndex.size());
    }

    private boolean offerMatches(ResourceLocation id, String q) {
        String needle = q.toLowerCase(Locale.ROOT);
        if (id.toString().toLowerCase(Locale.ROOT).contains(needle)) {
            return true;
        }
        AmadronOffer offer = AmadronOfferHelper.getActiveOffer(id);
        if (offer == null) {
            return false;
        }
        String inName = AmadronWirelessTerminalGUI.safeNameLower(offer, true);
        String outName = AmadronWirelessTerminalGUI.safeNameLower(offer, false);
        return !inName.isEmpty() && inName.contains(needle) || !outName.isEmpty() && outName.contains(needle);
    }

    private static String safeNameLower(AmadronOffer offer, boolean input) {
        try {
            String name = input ? offer.getInput().getName() : offer.getOutput().getName();
            return name == null ? "" : name.toLowerCase(Locale.ROOT);
        }
        catch (Throwable t) {
            return "";
        }
    }

    private void updateScrollbarRangeBySize(int filteredSize) {
        this.totalRows = (int)Math.ceil((double)filteredSize / 2.0);
        int maxScroll = Math.max(0, this.totalRows - this.visibleRows);
        int pageStep = Math.max(1, Math.max(1, this.visibleRows / 6));
        this.scrollbar.setRange(0, maxScroll, pageStep);
    }

    private void onSubmit() {
        MutableBasket basket = ShoppingBasket.createMutable();
        for (AmadronOfferPanel panel : this.pagePanels) {
            int want = panel.getWantedStock();
            if (want <= 0) continue;
            basket.addUnitsToOffer(panel.getOfferId(), want);
        }
        ((AmadronWirelessTerminalMenu)this.menu).sendSubmitOrderAction(basket.toImmutable());
    }

    public void drawFG(GuiGraphics gg, int ox, int oy, int mx, int my) {
        super.drawFG(gg, ox, oy, mx, my);
        for (AmadronOfferPanel p : this.pagePanels) {
            if (!p.isActive()) continue;
            p.renderStackTooltip(gg, mx, my, ox, oy);
        }
    }

    public void drawBG(GuiGraphics gg, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int x0 = this.leftPos;
        int y0 = this.topPos;
        AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, y0, HEADER);
        int darwY = y0 + AmadronWirelessTerminalGUI.HEADER.height;
        if (this.visibleRows >= 2) {
            AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, darwY, FIRST_ROW);
            darwY += AmadronWirelessTerminalGUI.FIRST_ROW.height;
            for (int i = 0; i < this.visibleRows - 2; ++i) {
                AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, darwY, MID_ROW);
                darwY += AmadronWirelessTerminalGUI.MID_ROW.height;
            }
            AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, darwY, LAST_ROW);
            darwY += AmadronWirelessTerminalGUI.LAST_ROW.height;
        } else if (this.visibleRows == 1) {
            AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, darwY, LAST_ROW);
            darwY += AmadronWirelessTerminalGUI.LAST_ROW.height;
        }
        AmadronWirelessTerminalGUI.blit(gg, BG_TEX, x0, darwY, ENDER);
        super.drawBG(gg, x, y, mouseX, mouseY, partialTicks);
    }

    private int getGuiRight() {
        return this.getGuiLeft() + this.imageWidth;
    }

    private int getGuiBottom() {
        return this.getGuiTop() + this.imageHeight;
    }

    private static void blit(GuiGraphics gg, ResourceLocation tex, int x, int y, UVBounds uv) {
        gg.blit(tex, x, y, (float)uv.x, (float)uv.y, uv.width, uv.height, 512, 512);
    }

    private record UVBounds(int x, int y, int width, int height) {
    }
}

