/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.air;

import com.wintercogs.appliedpneumatics.common.init.APDataComponents;
import com.wintercogs.appliedpneumatics.common.items.IAirStorageCell;
import com.wintercogs.appliedpneumatics.util.APMath;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class PortableAirCellItemStackHandler
implements IAirHandlerItem {
    private final ItemStack container;
    private final IAirStorageCell storageCell;

    public PortableAirCellItemStackHandler(ItemStack container) {
        Validate.isTrue((boolean)(container.getItem() instanceof IAirStorageCell), (String)("itemstack " + String.valueOf(container) + " must be an IAirStorageCell!"), (Object[])new Object[0]);
        this.storageCell = (IAirStorageCell)container.getItem();
        this.container = container;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    public float getPressure() {
        return (float)IAirStorageCell.getStoredAir(this.container) / ((float)((long)this.storageCell.getTotalBytes() * IAirStorageCell.amountPerByte()) / this.maxPressure());
    }

    public int getAir() {
        return APMath.ClampToInt(IAirStorageCell.getStoredAir(this.container));
    }

    public void addAir(int amount) {
        long wanted = IAirStorageCell.getStoredAir(this.container) + (long)amount;
        long actual = Math.min(Math.max(0L, wanted), (long)this.storageCell.getTotalBytes() * IAirStorageCell.amountPerByte());
        this.container.set(APDataComponents.AIR_STORED, (Object)actual);
    }

    public int getBaseVolume() {
        return (int)((float)((long)this.storageCell.getTotalBytes() * IAirStorageCell.amountPerByte()) / this.maxPressure());
    }

    public void setBaseVolume(int size) {
    }

    public int getVolume() {
        return this.getBaseVolume();
    }

    public float maxPressure() {
        return 20.0f;
    }
}

