/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.blocks.entitis;

import appeng.api.AECapabilities;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.helpers.IPriorityHost;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.inv.AppEngInternalInventory;
import com.wintercogs.appliedpneumatics.api.GenericInv.CombinedGenericInternalInventory;
import com.wintercogs.appliedpneumatics.api.GenericInv.GenericStackInvWrapper;
import com.wintercogs.appliedpneumatics.common.blocks.MEAmadronProcessStation;
import com.wintercogs.appliedpneumatics.common.init.APBlockEntities;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import com.wintercogs.appliedpneumatics.common.me.crafting.AmadronPatternDetails;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.amadron.AmadronUtil;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEAmadronProcessStationBlockEntity
extends AENetworkedBlockEntity
implements IUpgradeableObject,
ICraftingProvider,
PatternContainer,
ServerTickingBlockEntity,
IPriorityHost {
    private static final int MAX_ITEM_STACKS_PER_DRONE = 36;
    private static final int MAX_FLUID_MB_PER_DRONE = 576000;
    private final AppEngInternalInventory patternInventory;
    private final IUpgradeInventory upgrades = UpgradeInventories.forMachine(APBlocks.ME_AMADRON_PROCESS_STATION, (int)4, () -> {});
    private final GenericStackInv inputInv = new GenericStackInv(() -> ((MEAmadronProcessStationBlockEntity)this).setChanged(), 9);
    private final GenericStackInv outputInv = new GenericStackInv(() -> ((MEAmadronProcessStationBlockEntity)this).setChanged(), 9);
    private int priority = 0;
    private final List<Job> jobs = new ArrayList<Job>();
    private boolean needAmadronRefresh = true;

    public MEAmadronProcessStationBlockEntity(BlockEntityType<? extends MEAmadronProcessStationBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int patternSize) {
        super(blockEntityType, pos, blockState);
        this.patternInventory = new AppEngInternalInventory(patternSize){

            public boolean isItemValid(int slot, ItemStack stack) {
                return super.isItemValid(slot, stack) && stack.getItem() == APItems.AMADRON_PATTERN.get();
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ICraftingProvider.requestUpdate((IManagedGridNode)MEAmadronProcessStationBlockEntity.this.getMainNode());
                MEAmadronProcessStationBlockEntity.this.setChanged();
            }
        };
        this.inputInv.useRegisteredCapacities();
        this.inputInv.setCapacity(AEKeyType.fluids(), 64000L);
        this.outputInv.useRegisteredCapacities();
        this.outputInv.setCapacity(AEKeyType.fluids(), 64000L);
        this.getMainNode().setIdlePowerUsage(8.0).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setExposedOnSides(EnumSet.allOf(Direction.class)).addService(ICraftingProvider.class, (IGridNodeService)this);
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, APBlockEntities.ME_AMADRON_PROCESS_STATION_BLOCK_ENTITY.get(), (be, unused) -> be);
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, APBlockEntities.ME_AMADRON_EXTENDED_PROCESS_STATION_BLOCK_ENTITY.get(), (be, unused) -> be);
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, APBlockEntities.ME_AMADRON_PROCESS_STATION_BLOCK_ENTITY.get(), (be, direction) -> {
            GenericStackInvWrapper inputWrapper = new GenericStackInvWrapper((GenericInternalInventory)be.inputInv){

                @Override
                public long insert(int slot, AEKey what, long amount, Actionable mode) {
                    return 0L;
                }
            };
            GenericStackInvWrapper outputWrapper = new GenericStackInvWrapper((GenericInternalInventory)be.outputInv, (MEAmadronProcessStationBlockEntity)((Object)be)){
                final /* synthetic */ MEAmadronProcessStationBlockEntity val$be;
                {
                    this.val$be = mEAmadronProcessStationBlockEntity;
                    super(arg0);
                }

                @Override
                public long insert(int slot, AEKey what, long amount, Actionable mode) {
                    MEStorage storage = this.val$be.getNetworkInventory();
                    long remaining = amount;
                    long firstInsert = 0L;
                    if (storage != null && (remaining = amount - (firstInsert = storage.insert(what, amount, mode, IActionSource.ofMachine((IActionHost)this.val$be)))) <= 0L) {
                        return amount;
                    }
                    return firstInsert + super.insert(slot, what, remaining, mode);
                }

                @Override
                public long extract(int slot, AEKey what, long amount, Actionable mode) {
                    return 0L;
                }
            };
            return new CombinedGenericInternalInventory(inputWrapper, outputWrapper);
        });
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, APBlockEntities.ME_AMADRON_EXTENDED_PROCESS_STATION_BLOCK_ENTITY.get(), (be, direction) -> {
            GenericStackInvWrapper inputWrapper = new GenericStackInvWrapper((GenericInternalInventory)be.inputInv){

                @Override
                public long insert(int slot, AEKey what, long amount, Actionable mode) {
                    return 0L;
                }
            };
            GenericStackInvWrapper outputWrapper = new GenericStackInvWrapper((GenericInternalInventory)be.outputInv, (MEAmadronProcessStationBlockEntity)((Object)be)){
                final /* synthetic */ MEAmadronProcessStationBlockEntity val$be;
                {
                    this.val$be = mEAmadronProcessStationBlockEntity;
                    super(arg0);
                }

                @Override
                public long insert(int slot, AEKey what, long amount, Actionable mode) {
                    MEStorage storage = this.val$be.getNetworkInventory();
                    long remaining = amount;
                    long firstInsert = 0L;
                    if (storage != null && (remaining = amount - (firstInsert = storage.insert(what, amount, mode, IActionSource.ofMachine((IActionHost)this.val$be)))) <= 0L) {
                        return amount;
                    }
                    return firstInsert + super.insert(slot, what, remaining, mode);
                }

                @Override
                public long extract(int slot, AEKey what, long amount, Actionable mode) {
                    return 0L;
                }
            };
            return new CombinedGenericInternalInventory(inputWrapper, outputWrapper);
        });
    }

    public InternalInventory getTerminalPatternInventory() {
        return this.patternInventory;
    }

    public GenericStackInv getInputInv() {
        return this.inputInv;
    }

    public GenericStackInv getOutputInv() {
        return this.outputInv;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public MEStorage getNetworkInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return null;
        }
        IStorageService ss = grid.getStorageService();
        return ss != null ? ss.getInventory() : null;
    }

    @Nullable
    public IGrid getGrid() {
        return this.getMainNode().isReady() ? this.getMainNode().getGrid() : null;
    }

    public PatternContainerGroup getTerminalGroup() {
        return new PatternContainerGroup(AEItemKey.of(APBlocks.ME_AMADRON_PROCESS_STATION), (Component)((MEAmadronProcessStation)((Object)APBlocks.ME_AMADRON_PROCESS_STATION.get())).getName(), List.of());
    }

    public int getPriority() {
        return this.priority;
    }

    public int getJobAmount() {
        return this.jobs.size();
    }

    public void setPriority(int priority) {
        this.priority = priority;
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        this.setChanged();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(APMenus.ME_AMADRON_PROCESS_STATION_MENU.get(), (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getBlockState().getBlock());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.patternInventory.writeToNBT(tag, "pattern_inv", registries);
        this.inputInv.writeToChildTag(tag, "input_inv", registries);
        this.outputInv.writeToChildTag(tag, "output_inv", registries);
        this.upgrades.writeToNBT(tag, "upgrade_inv", registries);
        tag.putInt("priority", this.priority);
        ListTag jobList = new ListTag();
        for (Job j : this.jobs) {
            jobList.add((Object)j.writeToSubTag(registries));
        }
        tag.put("Jobs", (Tag)jobList);
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.patternInventory.readFromNBT(tag, "pattern_inv", registries);
        this.inputInv.readFromChildTag(tag, "input_inv", registries);
        this.outputInv.readFromChildTag(tag, "output_inv", registries);
        this.upgrades.readFromNBT(tag, "upgrade_inv", registries);
        this.priority = tag.getInt("priority");
        this.jobs.clear();
        if (tag.contains("Jobs", 9)) {
            ListTag jobList = tag.getList("Jobs", 10);
            for (int i = 0; i < jobList.size(); ++i) {
                CompoundTag jt = jobList.getCompound(i);
                this.jobs.add(Job.readFromSubTag(jt, registries));
            }
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        int i;
        int i2;
        super.addAdditionalDrops(level, pos, drops);
        for (i2 = 0; i2 < this.patternInventory.size(); ++i2) {
            ItemStack s = this.patternInventory.getStackInSlot(i2);
            if (s.isEmpty()) continue;
            drops.add(s.copy());
        }
        for (i2 = 0; i2 < this.upgrades.size(); ++i2) {
            ItemStack slotContent = this.upgrades.getStackInSlot(i2);
            if (slotContent.isEmpty()) continue;
            drops.add(slotContent.copy());
        }
        Consumer<GenericStack> toDrops = gs -> {
            if (gs == null) {
                return;
            }
            AEKey patt0$temp = gs.what();
            if (patt0$temp instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)patt0$temp;
                int amt = Math.clamp(gs.amount(), 0, Integer.MAX_VALUE);
                if (amt > 0) {
                    drops.add(itemKey.toStack(amt));
                }
            }
        };
        for (i = 0; i < this.inputInv.size(); ++i) {
            toDrops.accept(this.inputInv.getStack(i));
        }
        for (i = 0; i < this.outputInv.size(); ++i) {
            toDrops.accept(this.outputInv.getStack(i));
        }
        this.cancelAllJobs((Component)Component.translatable((String)"amadron.appliedpneumatics.process_fail.block_break", (Object[])new Object[]{this.worldPosition.toShortString()}));
    }

    public void clearContent() {
        super.clearContent();
        this.patternInventory.clear();
        this.upgrades.clear();
        this.inputInv.clear();
        this.outputInv.clear();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        ArrayList<IPatternDetails> result = new ArrayList<IPatternDetails>();
        for (int i = 0; i < this.patternInventory.size(); ++i) {
            IPatternDetails patternDetails;
            ItemStack stack = this.patternInventory.getStackInSlot(i);
            if (stack.isEmpty() || !((patternDetails = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.level)) instanceof AmadronPatternDetails)) continue;
            result.add(patternDetails);
        }
        return result;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (this.isBusy()) {
            return false;
        }
        if (patternDetails instanceof AmadronPatternDetails) {
            AmadronPatternDetails details = (AmadronPatternDetails)patternDetails;
            Object2LongMap.Entry entry = inputHolder[0].getFirstEntry();
            if (entry != null) {
                this.addJob(details.getOfferId(), new GenericStack((AEKey)entry.getKey(), entry.getLongValue()));
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.jobs.size() >= 512;
    }

    public int getPatternPriority() {
        return this.getPriority();
    }

    public void serverTick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.needAmadronRefresh && this.getMainNode().isReady() && (this.level.getGameTime() & 0x14L) == 0L && !AmadronOfferManager.getInstance().getActiveOffers().isEmpty()) {
            ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.needAmadronRefresh = false;
        }
        if (this.getMainNode().isActive()) {
            this.flushOutputToME();
            if (this.level.getGameTime() % 200L == 0L) {
                int maxDrones = 1 + Math.max(0, this.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD) - 1);
                int maxUnitsPerDrone = switch (this.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
                    case 1 -> 32;
                    case 2 -> 64;
                    case 3 -> 128;
                    case 4 -> 256;
                    default -> 16;
                };
                this.doJob(maxDrones, maxUnitsPerDrone);
            }
        }
    }

    private void flushOutputToME() {
        MEStorage me = this.getNetworkInventory();
        if (me == null) {
            return;
        }
        IActionSource src = IActionSource.ofMachine((IActionHost)this);
        boolean moved = false;
        for (int i = 0; i < this.outputInv.size(); ++i) {
            long ins;
            GenericStack gs = this.outputInv.getStack(i);
            if (gs == null || (ins = me.insert(gs.what(), gs.amount(), Actionable.MODULATE, src)) <= 0L) continue;
            this.outputInv.extract(gs.what(), ins, Actionable.MODULATE, src);
            moved = true;
        }
        if (moved) {
            this.setChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doJob(int maxDronesPerTick, int maxUnitsPerOfferPerDispatch) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        IActionSource src = IActionSource.ofMachine((IActionHost)this);
        if (this.jobs.isEmpty()) {
            return;
        }
        HashMap<ResourceLocation, List> withSelfByOffer = new HashMap<ResourceLocation, List>();
        for (Job j : this.jobs) {
            withSelfByOffer.computeIfAbsent(j.offerId(), k -> new ArrayList()).add(j);
        }
        ArrayList<Job> pending = new ArrayList<Job>();
        HashSet<ResourceLocation> usedThisRound = new HashSet<ResourceLocation>();
        int dispatched = 0;
        Consumer<Void> flushOutputs = v -> {
            MEStorage me = this.getNetworkInventory();
            if (me == null) {
                return;
            }
            for (int i = 0; i < this.outputInv.size(); ++i) {
                long ins;
                GenericStack gs = this.outputInv.getStack(i);
                if (gs == null || (ins = me.insert(gs.what(), gs.amount(), Actionable.MODULATE, src)) <= 0L) continue;
                this.outputInv.extract(gs.what(), ins, Actionable.MODULATE, src);
            }
        };
        for (Map.Entry entry : withSelfByOffer.entrySet()) {
            void var24_36;
            GlobalPos here;
            int i;
            ResourceLocation offerId = (ResourceLocation)entry.getKey();
            List list = (List)entry.getValue();
            if (dispatched >= maxDronesPerTick) {
                pending.addAll(list);
                continue;
            }
            if (list.isEmpty() || usedThisRound.contains(offerId)) {
                pending.addAll(list);
                continue;
            }
            if (!AmadronOfferManager.getInstance().isActive(offerId)) {
                Object job22;
                MEStorage me = this.getNetworkInventory();
                HashMap<UUID, Integer> refundedByPlayer = new HashMap<UUID, Integer>();
                for (Object job22 : list) {
                    AEKey aEKey;
                    GenericStack res = ((Job)job22).selfResource();
                    long remain = res.amount();
                    if (me != null) {
                        long inserted = me.insert(res.what(), remain, Actionable.MODULATE, src);
                        remain -= inserted;
                    }
                    if (remain > 0L && (aEKey = res.what()) instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)aEKey;
                        int drop = (int)Math.min(Integer.MAX_VALUE, remain);
                        Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)itemKey.toStack(drop));
                    }
                    if (((Job)job22).player() == null) continue;
                    refundedByPlayer.merge(((Job)job22).player(), 1, Integer::sum);
                }
                if (this.level.getServer() == null || refundedByPlayer.isEmpty()) continue;
                AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(offerId);
                job22 = refundedByPlayer.entrySet().iterator();
                while (job22.hasNext()) {
                    Map.Entry playerEntry = (Map.Entry)job22.next();
                    ServerPlayer player = this.level.getServer().getPlayerList().getPlayer((UUID)playerEntry.getKey());
                    if (player == null) continue;
                    if (offer != null) {
                        player.sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.process_fail", (Object[])new Object[]{offer.getInput().getName(), offer.getOutput().getName(), playerEntry.getValue()}));
                        continue;
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.process_fail.offer_invalid", (Object[])new Object[]{offerId.toString(), playerEntry.getValue()}));
                }
                continue;
            }
            AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(offerId);
            int payloadUnitsLimit = MEAmadronProcessStationBlockEntity.computeMaxUnitsPerDrone(offer);
            if (payloadUnitsLimit <= 0) {
                pending.addAll(list);
                continue;
            }
            int allowedUnits = Math.min(maxUnitsPerOfferPerDispatch, payloadUnitsLimit);
            ArrayList<Job> selected = new ArrayList<Job>();
            HashMap<AEKey, Long> insertedTotals = new HashMap<AEKey, Long>();
            int visited = 0;
            for (i = 0; i < list.size() && selected.size() < allowedUnits; ++i) {
                Job job = (Job)list.get(i);
                ++visited;
                GenericStack self = job.selfResource();
                long can = this.inputInv.insert(self.what(), self.amount(), Actionable.SIMULATE, src);
                if (can < self.amount()) {
                    pending.add(job);
                    continue;
                }
                this.inputInv.insert(self.what(), self.amount(), Actionable.MODULATE, src);
                selected.add(job);
                insertedTotals.merge(self.what(), self.amount(), Long::sum);
            }
            if (selected.isEmpty()) {
                for (i = visited; i < list.size(); ++i) {
                    pending.add((Job)list.get(i));
                }
                continue;
            }
            int units = selected.size();
            AmadroneEntity drone = MEAmadronProcessStationBlockEntity.retrieveOrder("appliedpneumatics", offer, units, here = new GlobalPos(this.level.dimension(), this.worldPosition), here);
            if (drone != null) {
                void var23_32;
                ItemStack tablet = new ItemStack((ItemLike)ModItems.AMADRON_TABLET.get(), 1);
                tablet.set(ModDataComponents.AMADRON_ITEM_POS, (Object)here);
                tablet.set(ModDataComponents.AMADRON_FLUID_POS, (Object)here);
                drone.setHandlingOffer(offer.getOfferId(), units, tablet, "appliedpneumatics", AmadroneEntity.AmadronAction.TAKING_PAYMENT);
                usedThisRound.add(offerId);
                ++dispatched;
                int n = visited;
                while (var23_32 < list.size()) {
                    pending.add((Job)list.get((int)var23_32));
                    ++var23_32;
                }
                continue;
            }
            for (Map.Entry entry2 : insertedTotals.entrySet()) {
                this.inputInv.extract((AEKey)entry2.getKey(), ((Long)entry2.getValue()).longValue(), Actionable.MODULATE, src);
            }
            MEStorage me = this.getNetworkInventory();
            for (Map.Entry entry3 : insertedTotals.entrySet()) {
                Object k2;
                long back;
                long l = back = me != null ? me.insert((AEKey)entry3.getKey(), ((Long)entry3.getValue()).longValue(), Actionable.MODULATE, src) : 0L;
                long remain = (Long)entry3.getValue() - back;
                if (remain <= 0L || !((k2 = entry3.getKey()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)k2;
                int drop = (int)Math.min(Integer.MAX_VALUE, remain);
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)itemKey.toStack(drop));
            }
            HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
            for (Job job : selected) {
                if (job.player() == null) continue;
                hashMap.merge(job.player(), 1, Integer::sum);
            }
            if (this.level.getServer() != null) {
                for (Map.Entry ent : hashMap.entrySet()) {
                    ServerPlayer p = this.level.getServer().getPlayerList().getPlayer((UUID)ent.getKey());
                    if (p == null) continue;
                    p.sendSystemMessage((Component)Component.translatable((String)"amadron.appliedpneumatics.process_fail", (Object[])new Object[]{offer.getInput().getName(), offer.getOutput().getName(), ent.getValue()}));
                }
            }
            int n = visited;
            while (var24_36 < list.size()) {
                pending.add((Job)list.get((int)var24_36));
                ++var24_36;
            }
        }
        flushOutputs.accept(null);
        this.jobs.clear();
        this.jobs.addAll(pending);
        this.setChanged();
    }

    public static AmadroneEntity retrieveOrder(String playerName, AmadronOffer offer, int units, GlobalPos itemGPos, GlobalPos liquidGPos) {
        boolean isAmadronRestock = playerName == null;
        return (AmadroneEntity)offer.getInput().apply(itemStack -> MEAmadronProcessStationBlockEntity.retrieveOrderItems(playerName, offer, units, itemGPos, isAmadronRestock), fluidStack -> MEAmadronProcessStationBlockEntity.retrieveOrderFluid(playerName, offer, units, liquidGPos, isAmadronRestock));
    }

    private static AmadroneEntity retrieveOrderFluid(String playerName, AmadronOffer offer, int units, GlobalPos liquidGPos, boolean isAmadronRestock) {
        if (liquidGPos != null && MEAmadronProcessStationBlockEntity.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            FluidStack queryingFluid = AmadronUtil.buildFluidStack((FluidStack)offer.getInput().getFluid(), (int)units);
            MEAmadronProcessStationBlockEntity.reduceStockLevel(offer, units, isAmadronRestock);
            return (AmadroneEntity)DroneRegistry.getInstance().retrieveFluidAmazonStyle(liquidGPos, queryingFluid);
        }
        return null;
    }

    private static AmadroneEntity retrieveOrderItems(String playerName, AmadronOffer offer, int units, GlobalPos itemGPos, boolean isAmadronRestock) {
        if (itemGPos != null && MEAmadronProcessStationBlockEntity.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            ItemStack queryingItems = offer.getInput().getItem();
            ItemStack[] stacks = AmadronUtil.buildStacks((ItemStack)queryingItems, (int)units);
            if (stacks.length == 0) {
                Log.error((String)"retrieveOrderItems: got empty itemstack list for offer {} x {} @ {}", (Object[])new Object[]{units, queryingItems, itemGPos});
                return null;
            }
            MEAmadronProcessStationBlockEntity.reduceStockLevel(offer, units, isAmadronRestock);
            return (AmadroneEntity)DroneRegistry.getInstance().retrieveItemsAmazonStyle(itemGPos, stacks);
        }
        return null;
    }

    private static void reduceStockLevel(AmadronOffer offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0)) {
            offer.setStock(offer.getStock() - units);
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal((CustomPacketPayload)new PacketAmadronStockUpdate(offer.getOfferId(), offer.getStock()));
        }
    }

    public static boolean validateStockLevel(String playerName, AmadronOffer offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && offer.getStock() >= 0 && units > offer.getStock()) {
            Log.warning((String)"ignoring suspicious order from player [{}] for {} x {} - only {} in stock right now!", (Object[])new Object[]{playerName, units, offer, offer.getStock()});
            return false;
        }
        return true;
    }

    private static int computeMaxUnitsPerDrone(AmadronOffer offer) {
        ItemStack outItem = offer.getOutput().getItem();
        if (!outItem.isEmpty()) {
            int perUnitCount = Math.max(1, outItem.getCount());
            int maxStackSize = Math.max(1, outItem.getMaxStackSize());
            long maxItemsCapacity = 36L * (long)maxStackSize;
            long byUnits = maxItemsCapacity / (long)perUnitCount;
            return (int)Math.min(byUnits, Integer.MAX_VALUE);
        }
        FluidStack perUnit = offer.getOutput().getFluid();
        int mbPerUnit = Math.max(1, perUnit.getAmount());
        long byUnits = 576000L / (long)mbPerUnit;
        return (int)byUnits;
    }

    public void addJob(ResourceLocation offerId, @NotNull GenericStack selfResource) {
        this.jobs.add(new Job(offerId, selfResource, null));
    }

    public void addJob(ResourceLocation offerId, @NotNull GenericStack selfResource, UUID player) {
        this.jobs.add(new Job(offerId, selfResource, player));
    }

    public void cancelAllJobs(Component message) {
        MEStorage me = this.getNetworkInventory();
        IActionSource src = IActionSource.ofMachine((IActionHost)this);
        HashSet<UUID> involvedPlayers = new HashSet<UUID>();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Job job : this.jobs) {
            AEKey aEKey;
            GenericStack res = job.selfResource();
            long remain = res.amount();
            if (me != null) {
                long inserted = me.insert(res.what(), remain, Actionable.MODULATE, src);
                remain -= inserted;
            }
            if (remain > 0L && (aEKey = res.what()) instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                int drop = (int)Math.min(remain, Integer.MAX_VALUE);
                drops.add(itemKey.toStack(drop));
            }
            if (job.player() == null) continue;
            involvedPlayers.add(job.player());
        }
        if (this.level != null && !drops.isEmpty()) {
            for (ItemStack stack : drops) {
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)stack);
            }
        }
        if (this.level != null && !involvedPlayers.isEmpty() && this.level.getServer() != null) {
            for (UUID uuid : involvedPlayers) {
                ServerPlayer p = this.level.getServer().getPlayerList().getPlayer(uuid);
                if (p == null) continue;
                p.sendSystemMessage(message);
            }
        }
        this.jobs.clear();
        this.setChanged();
    }

    private record Job(ResourceLocation offerId, @NotNull GenericStack selfResource, @Nullable UUID player) {
        private CompoundTag writeToSubTag(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.putString("offer", this.offerId.toString());
            tag.put("resource", (Tag)GenericStack.writeTag((HolderLookup.Provider)registries, (GenericStack)this.selfResource));
            if (this.player != null) {
                tag.putString("player", this.player.toString());
            }
            return tag;
        }

        public static Job readFromSubTag(CompoundTag tag, HolderLookup.Provider registries) {
            ResourceLocation offer = ResourceLocation.parse((String)tag.getString("offer"));
            GenericStack resource = GenericStack.readTag((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("resource"));
            UUID player = null;
            if (tag.contains("player")) {
                player = UUID.fromString(tag.getString("player"));
            }
            return new Job(offer, Objects.requireNonNull(resource), player);
        }
    }
}

