/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.wintercogs.appliedpneumatics.common.items.IAirStorageCell;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AirStorageCell
extends Item
implements ICellWorkbenchItem,
IAirStorageCell {
    private final double idleDrain;
    private final int totalBytes;

    public AirStorageCell(Item.Properties properties, double idleDrain, int kilobytes) {
        super(properties);
        this.idleDrain = idleDrain;
        this.totalBytes = kilobytes * 1024;
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        long stored = IAirStorageCell.getStoredAir(stack);
        CellState state = IAirStorageCell.calcState(((IAirStorageCell)stack.getItem()).getTotalBytes(), stored);
        return state.getStateColor();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag advancedTooltips) {
        if (Platform.isClient()) {
            long stored = IAirStorageCell.getStoredAir(stack);
            long used = IAirStorageCell.usedBytes(stored);
            lines.add(Tooltips.bytesUsed((long)used, (long)this.getTotalBytes()));
            int typesUsed = stored > 0L ? 1 : 0;
            lines.add(Tooltips.typesUsed((long)typesUsed, (long)1L));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        long stored;
        boolean showUpg = AEConfig.instance().isTooltipShowCellUpgrades();
        boolean showCnt = AEConfig.instance().isTooltipShowCellContent();
        ArrayList upgrades = new ArrayList();
        if (showUpg) {
            this.getUpgrades(stack).forEach(upgrades::add);
        }
        List<Object> content = Collections.emptyList();
        boolean hasMore = false;
        if (showCnt && (stored = IAirStorageCell.getStoredAir(stack)) > 0L) {
            content = List.of(new GenericStack((AEKey)AirKey.INSTANCE, stored));
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, hasMore, true));
    }

    @Override
    public int getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)2);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!InteractionUtil.isInAlternateUseMode((Player)player)) {
            return false;
        }
        List disassembledStacks = StorageCellDisassemblyRecipe.getDisassemblyResult((Level)level, (Item)stack.getItem());
        if (disassembledStacks.isEmpty()) {
            return false;
        }
        Inventory playerInventory = player.getInventory();
        if (playerInventory.getSelected() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
        if (inv != null && !inv.getAvailableStacks().isEmpty()) {
            player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            return false;
        }
        playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
        for (ItemStack disassembledStack : disassembledStacks) {
            playerInventory.placeItemBackInInventory(disassembledStack.copy());
        }
        this.getUpgrades(stack).forEach(arg_0 -> ((Inventory)playerInventory).placeItemBackInInventory(arg_0));
        return true;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.getLevel(), context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }
}

