/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.AppEngSlot;
import com.wintercogs.appliedpneumatics.common.blocks.entitis.MEPressureInterfaceBlockEntity;
import com.wintercogs.appliedpneumatics.common.init.APMenus;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEPressureInterfaceMenu
extends UpgradeableMenu<MEPressureInterfaceBlockEntity> {
    public static String changeExpectedPressureAction = "change_expected_pressure";
    @GuiSync(value=10)
    public int latestAir = 0;
    @GuiSync(value=11)
    public int latestVolume = 0;
    @GuiSync(value=12)
    public double latestExpectedPressure = 0.0;
    @GuiSync(value=13)
    public double latestDangerPressure = 0.0;

    public MEPressureInterfaceMenu(int id, Inventory playerInv, @NotNull MEPressureInterfaceBlockEntity host) {
        super(APMenus.ME_PRESSURE_INTERFACE_MENU.get(), id, playerInv, (IUpgradeableObject)host);
        this.registerClientAction(changeExpectedPressureAction, Float.class, this::onClientChangeExpectedPressure);
    }

    protected void setupInventorySlots() {
        AppEngSlot slot = new AppEngSlot((InternalInventory)((MEPressureInterfaceBlockEntity)this.getHost()).getInventory(), 0);
        this.addSlot((Slot)slot, SlotSemantics.MACHINE_INPUT);
    }

    public void broadcastChanges() {
        MEPressureInterfaceBlockEntity be = (MEPressureInterfaceBlockEntity)this.getHost();
        this.latestAir = be.getAirHandler().getAir();
        this.latestVolume = be.getVolume();
        this.latestExpectedPressure = be.getExpectedPressure();
        this.latestDangerPressure = be.getAirHandler().getDangerPressure();
        super.broadcastChanges();
    }

    public void sendExpectedPressureActionToServer(float expectedPressureDelta) {
        this.sendClientAction(changeExpectedPressureAction, Float.valueOf(expectedPressureDelta));
    }

    private void onClientChangeExpectedPressure(float delta) {
        MEPressureInterfaceBlockEntity be = (MEPressureInterfaceBlockEntity)this.getHost();
        if (be.isRemoved()) {
            return;
        }
        float now = be.getExpectedPressure();
        be.setExpectedPressure(now + delta);
    }

    @Nullable
    public MEPressureInterfaceBlockEntity getBlockEntity() {
        return (MEPressureInterfaceBlockEntity)this.getHost();
    }

    public boolean stillValid(@NotNull Player player) {
        return !((MEPressureInterfaceBlockEntity)this.getHost()).isRemoved();
    }
}

