---
navigation:
  title: Applied Pneumatics
  position: 200
---

# Applied Pneumatics

<Row>
  <BlockImage id="me_amadron_process_station" scale="4" />
  <BlockImage id="me_pressure_interface_block" scale="4" />
  <BlockImage id="me_temperature_interface" scale="4" />
</Row>

This add-on provides a bridge between **Applied Energistics 2 (AE2)** and **PneumaticCraft: Repressurized (PNC:R)**.  
It enables you to use the ME Network to control **compressed air**, **temperature**, and the **Amadron** system.

## Feature Overview

- **Air Storage Cells** (1k~256m) — Store compressed air directly in the ME Network.
- **Portable Air Storage Cells** — High-capacity portable air tanks, with a maximum pressure of 20 bar.
- **ME Pressure Interface** — Maintains a target pressure by interacting with the ME Network.
- **ME Temperature Interface** — Consumes compressed air and AE energy to maintain a target temperature.
- **P2P Tunnels** — Transfer temperature and compressed air through AE P2P channels.
- **Amadron Processing Station** — Connects the Amadron system to the AE auto-crafting network.
- **New Integrated Recipes** — Adds new recipes, including Amadron trades and Assembly Chamber recipes.

## See Also

- [Basic Support](basic_support.md)
- [Air Storage Cells](air_storage_cells.md)
- [New P2P Types](air_heat_p2p.md)
- [ME Pressure Interface](me_pressure_interface_block.md)
- [ME Temperature Interface](me_temperature_interface_block.md)
- [Amadron Wireless Terminal](amadron_wireless_terminal.md)
- [Amadron Processing Station](me_amadron_process_block.md)
- [New Upgrade Cards](upgrades.md)
- [New Integrated Recipes](new_recipe.md)