/*
 * Decompiled with CFR 0.152.
 */
package gh.cinefov;

import gh.cinefov.ConfigData;
import gh.cinefov.ConfigLoader;
import gh.cinefov.FovController;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7842;

@Environment(value=EnvType.CLIENT)
public class CineFovConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ConfigData config;
    private String currentTab = "General";
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();

    public CineFovConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"cinefov.title"));
        this.parent = parent;
        this.config = ConfigLoader.config;
    }

    protected void method_25426() {
        int frameWidth = 320;
        int frameHeight = 200;
        int frameX = this.field_22789 / 2 - frameWidth / 2;
        int frameY = this.field_22790 / 2 - frameHeight / 2;
        int padding = 10;
        this.method_37063((class_364)new class_7842(this.field_22789 / 2 - 100, frameY - 30, 200, 20, (class_2561)class_2561.method_43471((String)"cinefov.title"), this.field_22793));
        int tabButtonWidth = 98;
        int spacing = 3;
        String[] tabs = new String[]{"General", "FOV Settings", "About"};
        int totalWidth = tabs.length * tabButtonWidth + (tabs.length - 1) * spacing;
        int startX = frameX + (frameWidth - totalWidth) / 2;
        int tabY = frameY + padding;
        for (int i = 0; i < tabs.length; ++i) {
            String tab = tabs[i];
            int x = startX + i * (tabButtonWidth + spacing);
            boolean isCurrent = tab.equals(this.currentTab);
            class_5250 tabText = switch (tab) {
                case "General" -> class_2561.method_43471((String)"cinefov.tab.general");
                case "FOV Settings" -> class_2561.method_43471((String)"cinefov.tab.fov");
                case "About" -> class_2561.method_43471((String)"cinefov.tab.about");
                default -> class_2561.method_43470((String)tab);
            };
            class_4185 btn = class_4185.method_46430((class_2561)tabText, b -> this.switchTab(tab)).method_46434(x, tabY, tabButtonWidth, 20).method_46431();
            btn.method_25365(isCurrent);
            if (!isCurrent) {
                btn.method_25350(0.5f);
            }
            this.tabButtons.add((class_4185)this.method_37063((class_364)btn));
        }
        int tabBottomY = tabY + 20 + spacing;
        this.renderTabContents(frameX, frameY, frameWidth, frameHeight, tabBottomY);
    }

    private void switchTab(String tab) {
        this.currentTab = tab;
        this.method_37067();
        this.tabButtons.clear();
        this.method_25426();
    }

    private void renderTabContents(int frameX, int frameY, int frameWidth, int frameHeight, int startY) {
        int padding = 10;
        int x = frameX + padding;
        int elementWidth = frameWidth - padding * 2;
        int y = startY + padding + (this.currentTab.equals("About") ? 0 : 9);
        if (this.currentTab.equals("General")) {
            this.addToggle(x, y, elementWidth, "cinefov.option.enable", () -> this.config.enableMod, v -> {
                this.config.enableMod = v;
            });
            this.addToggle(x, y += 25, elementWidth, "cinefov.option.mouse_fov", () -> this.config.enableMouseSmoothing, v -> {
                this.config.enableMouseSmoothing = v;
            });
            this.addToggle(x, y += 25, elementWidth, "cinefov.option.vertical_motion", () -> this.config.enableVerticalInertia, v -> {
                this.config.enableVerticalInertia = v;
            });
            y += 25;
            y = this.addSlider(x, y, elementWidth, "cinefov.option.dynamic_fov", this.config.dynamicFovForce, 0.0f, 0.5f, v -> {
                this.config.dynamicFovForce = v;
            });
        } else if (this.currentTab.equals("FOV Settings")) {
            y = this.addSlider(x, y, elementWidth, "cinefov.option.mouse_force", this.config.mouseFovForce, 0.0f, 2.0f, v -> {
                this.config.mouseFovForce = v;
            });
            y = this.addSlider(x, y, elementWidth, "cinefov.option.mouse_speed", this.config.mouseSmoothing, 0.01f, 0.1f, v -> {
                this.config.mouseSmoothing = v;
            });
            y = this.addSlider(x, y, elementWidth, "cinefov.option.zoom_speed", this.config.zoomSmoothing, 0.02f, 0.2f, v -> {
                this.config.zoomSmoothing = v;
            });
            y = this.addSlider(x, y, elementWidth, "cinefov.option.movement_force", this.config.movementFOV, 0.0f, 1.0f, v -> {
                this.config.movementFOV = v;
            });
        } else if (this.currentTab.equals("About")) {
            int lineHeight = 12;
            for (int i = 1; i <= 10; ++i) {
                this.method_37063((class_364)new class_7842(x, y, elementWidth, lineHeight, (class_2561)class_2561.method_43471((String)("cinefov.about.line" + i)), this.field_22793));
                y += lineHeight;
            }
            int buttonY = frameY + frameHeight - padding - 20;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), b -> this.switchTab("General")).method_46434(x, buttonY, elementWidth, 20).method_46431());
            return;
        }
        int buttonY = frameY + frameHeight - padding - 20;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"cinefov.button.reset"), b -> {
            ConfigLoader.config = new ConfigData();
            this.field_22787.method_1507((class_437)new CineFovConfigScreen(this.parent));
        }).method_46434(x, buttonY, (elementWidth - 10) / 2, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), b -> {
            ConfigLoader.save();
            FovController.applyConfigValues();
            this.field_22787.method_1507(this.parent);
        }).method_46434(x + (elementWidth + 10) / 2, buttonY, (elementWidth - 10) / 2, 20).method_46431());
    }

    private void addToggle(int x, int y, int width, String translationKey, BooleanSupplier getter, ValueSetter setter) {
        class_4185[] toggleBtn;
        toggleBtn = new class_4185[]{class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> {
            boolean newVal = !getter.getAsBoolean();
            setter.set(newVal);
            toggleBtn[0].method_25355((class_2561)class_2561.method_43471((String)translationKey).method_27661().method_27693(": ").method_27693(newVal ? "ON" : "OFF"));
            FovController.applyConfigValues();
        }).method_46434(x, y, width, 20).method_46431()};
        toggleBtn[0].method_25355((class_2561)class_2561.method_43471((String)translationKey).method_27661().method_27693(": ").method_27693(getter.getAsBoolean() ? "ON" : "OFF"));
        this.method_37063((class_364)toggleBtn[0]);
    }

    private int addSlider(int x, int y, int width, String translationKey, float current, float min, float max, ValueConsumer consumer) {
        this.method_37063((class_364)new Slider(x, y, width, 20, translationKey, current, min, max, consumer));
        return y + 25;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int frameWidth = 320;
        int frameHeight = 200;
        int frameX = this.field_22789 / 2 - frameWidth / 2;
        int frameY = this.field_22790 / 2 - frameHeight / 2;
        context.method_25294(frameX, frameY, frameX + frameWidth, frameY + frameHeight, -1442840576);
        context.method_25294(frameX, frameY, frameX + frameWidth, frameY + 1, -1);
        context.method_25294(frameX, frameY + frameHeight, frameX + frameWidth, frameY + frameHeight + 1, -1);
        context.method_25294(frameX, frameY, frameX + 1, frameY + frameHeight, -1);
        context.method_25294(frameX + frameWidth, frameY, frameX + frameWidth + 1, frameY + frameHeight, -1);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        ConfigLoader.save();
        FovController.applyConfigValues();
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        super.method_25432();
        ConfigLoader.save();
        FovController.applyConfigValues();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface ValueSetter {
        public void set(boolean var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface ValueConsumer {
        public void apply(float var1);
    }

    @Environment(value=EnvType.CLIENT)
    private static class Slider
    extends class_357 {
        private final String translationKey;
        private final float min;
        private final float max;
        private final ValueConsumer onChange;

        public Slider(int x, int y, int width, int height, String translationKey, float value, float min, float max, ValueConsumer onChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), (double)((value - min) / (max - min)));
            this.translationKey = translationKey;
            this.min = min;
            this.max = max;
            this.onChange = onChange;
            this.method_25346();
        }

        protected void method_25346() {
            float val = (float)((double)this.min + this.field_22753 * (double)(this.max - this.min));
            this.method_25355((class_2561)class_2561.method_43471((String)this.translationKey).method_27661().method_27693(": " + String.format("%.3f", Float.valueOf(val))));
        }

        protected void method_25344() {
            float val = (float)((double)this.min + this.field_22753 * (double)(this.max - this.min));
            this.onChange.apply(val);
            FovController.applyConfigValues();
        }
    }
}

