/*
 * Decompiled with CFR 0.152.
 */
package gh.cinefov;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gh.cinefov.ConfigData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cinefov_config.json");
    public static ConfigData config = new ConfigData();

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (config == null) {
                    config = new ConfigData();
                    System.err.println("[CineFov] Config was null, using default.");
                } else {
                    if (ConfigLoader.config.movementFOV == 0.0f) {
                        ConfigLoader.config.movementFOV = 1.0f;
                    }
                    System.out.println("[CineFov] Config loaded.");
                }
            }
            catch (Exception e) {
                System.err.println("[CineFov] Failed to load config: " + e.getMessage());
                config = new ConfigData();
            }
        } else {
            ConfigLoader.save();
            System.out.println("[CineFov] Default config created.");
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            System.out.println("[CineFov] Config saved.");
        }
        catch (IOException e) {
            System.err.println("[CineFov] Failed to save config: " + e.getMessage());
        }
    }
}

