/*
 * Decompiled with CFR 0.152.
 */
package gh.cinefov;

import gh.cinefov.CineFovClient;
import gh.cinefov.ConfigData;
import gh.cinefov.ConfigLoader;
import gh.cinefov.mixin.client.CameraAccessorMixin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_4184;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class FovController {
    private static float speedFovBoost = 0.0f;
    private static float verticalFovBoost = 0.0f;
    private static float mouseFovBoost = 0.0f;
    private static float vanillaFovCompensation = 0.0f;
    public static float DYNAMIC_FOV_FORCE;
    public static float MOUSE_FOV_FORCE;
    public static float FOV_SMOOTHING_FACTOR;
    public static float MOUSE_SMOOTHING;
    public static float MAX_TOTAL_MULTIPLIER;
    public static float ZOOM_SMOOTHING;
    public static float SPEED_SMOOTHING;
    public static float VERTICAL_SMOOTHING;
    public static float VERTICAL_OFFSET;
    public static float MOVEMENT_FOV;
    public static boolean MODENABLED;
    public static boolean ENABLE_MOUSE_SMOOTHING;
    public static boolean ENABLE_VERTICAL_INERTIA;
    private static final float VANILLA_SMOOTHING = 0.03f;
    private static final float MAX_SPEED_BOOST = 0.3f;
    private static final float MAX_VERTICAL_BOOST = 0.18f;
    private static final float MAX_MOUSE_BOOST = 0.5f;
    private static final float VANILLA_SPRINT_BOOST = 0.05f;
    private static float lastYaw;
    private static float lastPitch;
    private static boolean zoomKeyHeld;
    private static float zoomFactor;
    private static final float ZOOM_BASE = 0.25f;
    private static Double originalSensitivity;
    private static float scrollZoomFactor;
    private static final float MIN_SCROLL = 0.1f;
    private static final float MAX_SCROLL = 3.5f;
    private static final float SCROLL_SENSITIVITY = 0.1f;
    private static float cinematicYaw;
    private static float cinematicPitch;
    private static final float CINEMATIC_SMOOTHING = 0.01f;
    public static class_304 toggleSmoothCameraKey;
    public static boolean smoothCameraEnabled;

    public static double applyVanillaStyleFov(double baseFov) {
        if (!MODENABLED) {
            return baseFov;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return baseFov;
        }
        class_746 player = client.field_1724;
        class_243 velocity = player.method_18798();
        double horizontalSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
        double normalizedSpeed = class_3532.method_15350((double)(horizontalSpeed / 0.35), (double)0.0, (double)1.0);
        float targetSpeedBoost = (float)(normalizedSpeed * (double)0.3f * (double)MOVEMENT_FOV);
        speedFovBoost = class_3532.method_16439((float)SPEED_SMOOTHING, (float)speedFovBoost, (float)targetSpeedBoost);
        double verticalSpeed = Math.abs(velocity.field_1351);
        double normalizedVertical = class_3532.method_15350((double)(verticalSpeed / 0.5), (double)0.0, (double)1.0);
        float targetVerticalBoost = (float)(normalizedVertical * (double)0.18f);
        verticalFovBoost = class_3532.method_16439((float)VERTICAL_SMOOTHING, (float)verticalFovBoost, (float)targetVerticalBoost);
        float currentYaw = player.method_36454();
        float currentPitch = player.method_36455();
        float yawDelta = Math.abs(currentYaw - lastYaw);
        float pitchDelta = Math.abs(currentPitch - lastPitch);
        lastYaw = currentYaw;
        lastPitch = currentPitch;
        float rotationDelta = yawDelta + pitchDelta;
        float normalizedRotation = class_3532.method_15363((float)(rotationDelta / 6.0f), (float)0.0f, (float)1.0f);
        float targetMouseBoost = ENABLE_MOUSE_SMOOTHING ? normalizedRotation * 0.5f : 0.0f;
        mouseFovBoost = class_3532.method_16439((float)MOUSE_SMOOTHING, (float)mouseFovBoost, (float)targetMouseBoost);
        float targetVanillaFov = player.method_5624() ? 0.05f : 0.0f;
        vanillaFovCompensation = class_3532.method_16439((float)0.03f, (float)vanillaFovCompensation, (float)targetVanillaFov);
        float totalBoost = speedFovBoost + verticalFovBoost + mouseFovBoost * MOUSE_FOV_FORCE;
        totalBoost *= DYNAMIC_FOV_FORCE;
        totalBoost = class_3532.method_15363((float)totalBoost, (float)0.0f, (float)(MAX_TOTAL_MULTIPLIER - 1.0f));
        float multiplier = class_3532.method_15363((float)(1.0f + totalBoost - vanillaFovCompensation), (float)0.5f, (float)MAX_TOTAL_MULTIPLIER);
        float maxAllowedFov = (float)baseFov * MAX_TOTAL_MULTIPLIER;
        float minAllowedFov = 30.0f;
        float targetFov = class_3532.method_15363((float)((float)baseFov * multiplier), (float)minAllowedFov, (float)maxAllowedFov);
        float smoothed = class_3532.method_16439((float)class_3532.method_15363((float)FOV_SMOOTHING_FACTOR, (float)0.0f, (float)1.0f), (float)((float)baseFov), (float)targetFov);
        float zoomTarget = zoomKeyHeld ? 0.25f * scrollZoomFactor : 1.0f;
        zoomFactor = class_3532.method_16439((float)ZOOM_SMOOTHING, (float)zoomFactor, (float)zoomTarget);
        zoomFactor = class_3532.method_15363((float)zoomFactor, (float)0.01f, (float)1.0f);
        return smoothed * zoomFactor;
    }

    public static void tickZoomLogic() {
        boolean usingSpyglass;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690 == null) {
            return;
        }
        if (client.field_1755 instanceof class_408) {
            return;
        }
        boolean cPressed = CineFovClient.zoomKey.method_1434();
        boolean bl = usingSpyglass = client.field_1690.method_31044().method_31034() && client.field_1724.method_6115() && client.field_1724.method_6030().method_31574(class_1802.field_27070);
        if (!cPressed && !usingSpyglass && zoomKeyHeld) {
            scrollZoomFactor = 1.0f;
        }
        zoomKeyHeld = cPressed || usingSpyglass;
        class_315 options = client.field_1690;
        if (originalSensitivity < 0.0) {
            originalSensitivity = (Double)options.method_42495().method_41753();
        }
        float target = (float)(zoomKeyHeld ? originalSensitivity * (double)zoomFactor : originalSensitivity);
        double current = (Double)options.method_42495().method_41753();
        float newValue = class_3532.method_16439((float)0.2f, (float)((float)current), (float)target);
        options.method_42495().method_41748((Object)newValue);
        class_4184 camera = client.field_1773.method_19418();
        if (zoomKeyHeld) {
            float realYaw = client.field_1724.method_36454();
            float realPitch = client.field_1724.method_36455();
            if (cinematicYaw == 0.0f && cinematicPitch == 0.0f) {
                cinematicYaw = realYaw;
                cinematicPitch = realPitch;
            }
            if (smoothCameraEnabled || ENABLE_MOUSE_SMOOTHING) {
                float smoothing = class_3532.method_15363((float)(0.01f * (1.0f - zoomFactor)), (float)0.01f, (float)1.0f);
                cinematicYaw = class_3532.method_16439((float)smoothing, (float)cinematicYaw, (float)realYaw);
                cinematicPitch = class_3532.method_16439((float)smoothing, (float)cinematicPitch, (float)realPitch);
            } else {
                cinematicYaw = realYaw;
                cinematicPitch = realPitch;
            }
            ((CameraAccessorMixin)camera).invokeSetRotation(cinematicYaw, cinematicPitch);
        } else {
            float yaw = client.field_1724.method_36454();
            float pitch = client.field_1724.method_36455();
            ((CameraAccessorMixin)camera).invokeSetRotation(yaw, pitch);
            cinematicYaw = 0.0f;
            cinematicPitch = 0.0f;
        }
    }

    public static boolean isZoomActive() {
        return zoomKeyHeld;
    }

    public static void adjustScrollZoom(float scrollDelta) {
        scrollZoomFactor -= scrollDelta * 0.1f;
        scrollZoomFactor = class_3532.method_15363((float)scrollZoomFactor, (float)0.1f, (float)3.5f);
    }

    public static void applyConfigValues() {
        ConfigData cfg = ConfigLoader.config;
        DYNAMIC_FOV_FORCE = cfg.dynamicFovForce;
        MOUSE_FOV_FORCE = cfg.mouseFovForce;
        MOUSE_SMOOTHING = cfg.mouseSmoothing;
        ZOOM_SMOOTHING = cfg.zoomSmoothing;
        SPEED_SMOOTHING = cfg.reactionSpeed;
        VERTICAL_SMOOTHING = cfg.verticalMovementSmooth;
        MODENABLED = cfg.enableMod;
        ENABLE_MOUSE_SMOOTHING = cfg.enableMouseSmoothing;
        ENABLE_VERTICAL_INERTIA = cfg.enableVerticalInertia;
        MOVEMENT_FOV = cfg.movementFOV;
    }

    static {
        FOV_SMOOTHING_FACTOR = 1.0f;
        MAX_TOTAL_MULTIPLIER = 2.0f;
        VERTICAL_OFFSET = 0.5f;
        lastYaw = 0.0f;
        lastPitch = 0.0f;
        zoomKeyHeld = false;
        zoomFactor = 1.0f;
        originalSensitivity = -1.0;
        scrollZoomFactor = 1.0f;
        cinematicYaw = 0.0f;
        cinematicPitch = 0.0f;
        smoothCameraEnabled = false;
    }
}

