/*
 * Decompiled with CFR 0.152.
 */
package gh.cinefov.mixin.client;

import gh.cinefov.FovController;
import gh.cinefov.mixin.client.CameraAccessorMixin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_4184.class})
public abstract class CameraMixin {
    private float offsetVelocity = 0.0f;
    private float smoothedOffsetY = 0.0f;
    private double lastCameraY = 0.0;
    private boolean firstUpdate = true;
    private boolean wasSneaking = false;
    private boolean wasOnGround = true;
    private float lastHealth = 20.0f;
    private static final float BASE_SENSITIVITY = 0.8f;
    private static final float RETURN_FORCE = 0.2f;
    private static final float DAMPING = 0.8f;
    private static final float MAX_OFFSET = 1.5f;
    private float verticalMovementPhys = 0.5f;
    private float reactionSpeed = 1.0f;
    private static final float SNEAK_MULTIPLIER = 0.4f;
    private static final float FALL_DAMAGE_IMPULSE = 0.4f;
    private static int tickCounter = 0;

    @Inject(method={"update"}, at={@At(value="TAIL")})
    private void onUpdate(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        if (!(focusedEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)focusedEntity;
        if (!FovController.ENABLE_VERTICAL_INERTIA) {
            return;
        }
        class_4184 camera = (class_4184)this;
        double currentY = camera.method_19326().field_1351;
        float verticalDelta = 0.0f;
        if (!this.firstUpdate) {
            verticalDelta = (float)(currentY - this.lastCameraY);
        } else {
            this.firstUpdate = false;
        }
        this.lastCameraY = currentY;
        boolean isSneaking = player.method_5715();
        boolean sneakChanged = isSneaking != this.wasSneaking;
        this.wasSneaking = isSneaking;
        boolean isOnGround = player.method_24828();
        boolean landed = !this.wasOnGround && isOnGround;
        this.wasOnGround = isOnGround;
        float sneakFactor = isSneaking ? 0.4f : 1.0f;
        float adjustedDelta = verticalDelta * this.reactionSpeed * sneakFactor;
        float sensitivity = 0.8f * this.verticalMovementPhys * sneakFactor;
        float returnForce = 0.2f * this.verticalMovementPhys;
        float maxOffset = 1.5f * this.verticalMovementPhys;
        if (sneakChanged) {
            this.offsetVelocity *= 0.4f;
        }
        if (landed && player.method_6032() < this.lastHealth) {
            this.offsetVelocity -= 0.4f;
        }
        this.lastHealth = player.method_6032();
        this.offsetVelocity += -adjustedDelta * sensitivity;
        this.offsetVelocity += -this.smoothedOffsetY * returnForce;
        this.offsetVelocity *= 0.8f;
        this.smoothedOffsetY += this.offsetVelocity;
        this.smoothedOffsetY = class_3532.method_15363((float)this.smoothedOffsetY, (float)(-maxOffset), (float)maxOffset);
        ((CameraAccessorMixin)camera).invokeSetPos(camera.method_19326().field_1352, camera.method_19326().field_1351 + (double)this.smoothedOffsetY, camera.method_19326().field_1350);
    }
}

