/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.block;

import java.util.function.Supplier;
import jeffdallama.features.block.custom.LavaSpongeBlock;
import jeffdallama.features.block.custom.TinkerStationBlock;
import jeffdallama.features.block.custom.WetLavaSpongeBlock;
import jeffdallama.features.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"functionalfeatures");
    public static final RegistryObject<Block> LAVA_SPONGE = ModBlocks.registerBlock("lava_sponge", () -> new LavaSpongeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50577_)));
    public static final RegistryObject<Block> LAVA_SPONGE_SOLID = ModBlocks.registerBlock("lava_sponge_solid", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_)));
    public static final RegistryObject<Block> LAVA_SPONGE_WET = ModBlocks.registerBlock("lava_sponge_wet", () -> new WetLavaSpongeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50577_)));
    public static final RegistryObject<Block> MOD_TABLE = ModBlocks.registerBlock("mod_table", () -> new TinkerStationBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> IRON_ALLOY_BLOCK = ModBlocks.registerBlock("iron_alloy_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60953_(state -> 8)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        if (name.startsWith("lava_sponge")) {
            return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41486_()));
        }
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

