/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.block.custom;

import jeffdallama.features.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class LavaSpongeBlock
extends Block {
    public static final int MAX_DEPTH = 12;
    public static final int MAX_COUNT = 128;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public LavaSpongeBlock(BlockBehaviour.Properties p_56796_) {
        super(p_56796_);
    }

    public void m_6807_(BlockState p_56811_, @NotNull Level p_56812_, @NotNull BlockPos p_56813_, BlockState p_56814_, boolean p_56815_) {
        if (!p_56814_.m_60713_(p_56811_.m_60734_())) {
            this.tryAbsorb(p_56812_, p_56813_);
        }
    }

    public void m_6861_(@NotNull BlockState p_56801_, @NotNull Level p_56802_, @NotNull BlockPos p_56803_, @NotNull Block p_56804_, @NotNull BlockPos p_56805_, boolean p_56806_) {
        this.tryAbsorb(p_56802_, p_56803_);
        super.m_6861_(p_56801_, p_56802_, p_56803_, p_56804_, p_56805_, p_56806_);
    }

    protected void tryAbsorb(Level p_56798_, BlockPos p_56799_) {
        if (this.removeLavaBreadthFirstSearch(p_56798_, p_56799_)) {
            p_56798_.m_7731_(p_56799_, ((Block)ModBlocks.LAVA_SPONGE_SOLID.get()).m_49966_(), 2);
        } else if (this.removeWaterBreadthFirstSearch(p_56798_, p_56799_)) {
            p_56798_.m_7731_(p_56799_, ((Block)ModBlocks.LAVA_SPONGE_WET.get()).m_49966_(), 2);
        }
    }

    private boolean removeLavaBreadthFirstSearch(Level p_56808_, BlockPos p_56809_) {
        return BlockPos.m_276833_((BlockPos)p_56809_, (int)12, (int)128, (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.m_121945_(direction));
            }
        }, p_296944_ -> {
            BucketPickup bucketpickup;
            if (p_296944_.equals((Object)p_56809_)) {
                return true;
            }
            BlockState blockstate = p_56808_.m_8055_(p_296944_);
            FluidState fluidstate = p_56808_.m_6425_(p_296944_);
            if (!fluidstate.m_205070_(FluidTags.f_13132_)) {
                return false;
            }
            Block block = blockstate.m_60734_();
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).m_142598_((LevelAccessor)p_56808_, p_296944_, blockstate).m_41619_()) {
                return true;
            }
            if (blockstate.m_60734_() instanceof LiquidBlock) {
                p_56808_.m_7731_(p_296944_, Blocks.f_50016_.m_49966_(), 3);
            } else {
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? p_56808_.m_7702_(p_296944_) : null;
                LavaSpongeBlock.m_49892_((BlockState)blockstate, (LevelAccessor)p_56808_, (BlockPos)p_296944_, (BlockEntity)blockentity);
                p_56808_.m_7731_(p_296944_, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }

    private boolean removeWaterBreadthFirstSearch(Level p_56808_, BlockPos p_56809_) {
        return BlockPos.m_276833_((BlockPos)p_56809_, (int)12, (int)128, (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.m_121945_(direction));
            }
        }, p_296944_ -> {
            BucketPickup bucketpickup;
            if (p_296944_.equals((Object)p_56809_)) {
                return true;
            }
            BlockState blockstate = p_56808_.m_8055_(p_296944_);
            FluidState fluidstate = p_56808_.m_6425_(p_296944_);
            if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
                return false;
            }
            Block block = blockstate.m_60734_();
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).m_142598_((LevelAccessor)p_56808_, p_296944_, blockstate).m_41619_()) {
                return true;
            }
            if (blockstate.m_60734_() instanceof LiquidBlock) {
                p_56808_.m_7731_(p_296944_, Blocks.f_50016_.m_49966_(), 3);
            } else {
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? p_56808_.m_7702_(p_296944_) : null;
                LavaSpongeBlock.m_49892_((BlockState)blockstate, (LevelAccessor)p_56808_, (BlockPos)p_296944_, (BlockEntity)blockentity);
                p_56808_.m_7731_(p_296944_, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }
}

