/*
 * Decompiled with CFR 0.152.
 */
package jeffdallama.features.block.entity;

import java.util.List;
import jeffdallama.features.block.entity.ModBlockEntities;
import jeffdallama.features.item.custom.ModToolItem;
import jeffdallama.features.item.custom.modules.ModuleItem;
import jeffdallama.features.networking.ModMessages;
import jeffdallama.features.networking.packet.CannotApplyS2CPacket;
import jeffdallama.features.util.ModTags;
import jeffdallama.features.util.ModuleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TinkerStationEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private static final int SLOT_0 = 0;
    private static final int SLOT_1 = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int flag = 0;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 0;
        }
    };

    public TinkerStationEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TINKER_STATION_ENTITY.get(), pPos, pBlockState);
    }

    public void doSounds(BlockPos pos, SoundEvent soundEvent) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        if (pTag.m_128441_("Flag")) {
            this.flag = pTag.m_128451_("Flag");
        }
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        pTag.m_128405_("Flag", this.flag);
    }

    public void interact(Player player, InteractionHand hand, Level level, BlockPos pos) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            ItemStack newstack = this.takeItem();
            if (!newstack.m_41619_()) {
                player.m_21008_(hand, newstack);
                this.doSounds(pos, SoundEvents.f_12019_);
            }
        } else if (!(stack.m_41720_() instanceof ModToolItem)) {
            if (this.addItem(stack)) {
                stack.m_41774_(1);
                this.doSounds(pos, SoundEvents.f_12017_);
            }
        } else if (!this.getFirstItem().m_41619_()) {
            this.useTool(stack, level, pos, player);
        }
    }

    public boolean addItem(ItemStack stack) {
        for (int i = 0; i < 2; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            if (i == 0 && !stack.m_204117_(ModTags.Items.ALL_UPGRADABLE)) {
                return false;
            }
            if (i == 1 && !(stack.m_41720_() instanceof ModuleItem)) {
                return false;
            }
            this.items.set(i, (Object)stack.m_255036_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public ItemStack takeItem() {
        for (int i = 1; i > -1; --i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            ItemStack stack = (ItemStack)this.items.get(i);
            this.items.set(i, (Object)ItemStack.f_41583_);
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void useTool(ItemStack toolstack, Level level, BlockPos pos, Player player) {
        ItemStack target = this.getFirstItem();
        ItemStack modstack = this.getSecondItem();
        List<ItemStack> mods = ModuleUtil.getSpecsModules(target);
        double xpos = (double)pos.m_123341_() + 0.5;
        double ypos = (double)pos.m_123342_() + 1.15;
        double zpos = (double)pos.m_123343_() + 0.5;
        if (target.m_41619_()) {
            return;
        }
        boolean damageflag = true;
        ItemStack output = target.m_41777_();
        Object fail = null;
        if (!modstack.m_41619_()) {
            Item item;
            boolean activeflag = false;
            for (ItemStack stack : mods) {
                ModuleItem moditem;
                Item item2 = stack.m_41720_();
                if (!(item2 instanceof ModuleItem) || !(moditem = (ModuleItem)item2).getActive() && !moditem.getInventoryActive()) continue;
                activeflag = true;
            }
            int max = ModuleUtil.getSpecsMaxModules(target);
            int num = ModuleUtil.getSpecsNumModules(target);
            int tooltier = ((ModToolItem)toolstack.m_41720_()).getTier();
            boolean applyflag = false;
            if (num < max && (item = modstack.m_41720_()) instanceof ModuleItem) {
                ModuleItem mod = (ModuleItem)item;
                if (!activeflag || !mod.getInventoryActive() && !mod.getActive()) {
                    int modtier = mod.getTier();
                    if (tooltier >= modtier) {
                        if (mod.CanApply(target, modstack)) {
                            ModuleUtil.giveModule(output, mod);
                            applyflag = true;
                            this.doSounds(pos, SoundEvents.f_12471_);
                        } else {
                            fail = mod.CannotApplyText(target, modstack);
                        }
                    } else {
                        fail = "Requires Mod Tool Tier " + modtier + "!";
                    }
                } else {
                    fail = "Item Only Supports 1 Active Module!";
                }
            } else if (num >= max) {
                fail = "Item Cannot Support More Modules!";
            }
            if (!applyflag) {
                if (fail != null) {
                    ModMessages.sendtoplayer(new CannotApplyS2CPacket((String)fail), (ServerPlayer)player);
                }
                ItemEntity modEntity = new ItemEntity(level, xpos, ypos, zpos, modstack);
                level.m_7967_((Entity)modEntity);
                this.doSounds(pos, SoundEvents.f_12494_);
            }
        } else {
            List<ItemStack> list = ModuleUtil.getSpecsModules(target);
            CompoundTag tags = target.m_41784_();
            if (!list.isEmpty()) {
                ListTag outputlist = new ListTag();
                boolean didremoval = false;
                for (ItemStack oldmod : list) {
                    Item item = oldmod.m_41720_();
                    if (!(item instanceof ModuleItem)) continue;
                    ModuleItem modItem = (ModuleItem)item;
                    if (!modItem.CanRemove(target, oldmod)) {
                        outputlist.add((Object)oldmod.m_41739_(new CompoundTag()));
                        continue;
                    }
                    ItemEntity modEntity = new ItemEntity(level, xpos, ypos, zpos, oldmod);
                    level.m_7967_((Entity)modEntity);
                    didremoval = true;
                }
                if (didremoval) {
                    this.doSounds(pos, SoundEvents.f_12494_);
                }
                if (tags.m_128441_("Items")) {
                    ListTag listtag = tags.m_128437_("Items", 10);
                    for (int i = 0; i < listtag.size(); ++i) {
                        CompoundTag compoundtag1 = listtag.m_128728_(i);
                        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                        ItemEntity itemEntity = new ItemEntity(level, xpos, ypos, zpos, itemstack);
                        level.m_7967_((Entity)itemEntity);
                    }
                    tags.m_128473_("Items");
                }
                output.m_41751_(tags);
                output.m_41784_().m_128365_("modules", (Tag)outputlist);
            } else {
                damageflag = false;
            }
        }
        if (damageflag) {
            toolstack.m_220157_(1, RandomSource.m_216327_(), null);
        }
        this.items.clear();
        this.items.set(0, (Object)output);
        this.m_6596_();
    }

    public void drops() {
        if (this.f_58857_ == null) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(2);
        for (int i = 0; i < 2; ++i) {
            inventory.m_6836_(i, (ItemStack)this.items.get(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public ItemStack getFirstItem() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack getSecondItem() {
        return (ItemStack)this.items.get(1);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }
}

